var puremvc = {};

(function(t) {
"use strict";
var e = function() {
function t(t, e) {
this.notify = null;
this.context = null;
this.setNotifyMethod(t);
this.setNotifyContext(e);
}
t.prototype.getNotifyMethod = function() {
return this.notify;
};
t.prototype.setNotifyMethod = function(t) {
this.notify = t;
};
t.prototype.getNotifyContext = function() {
return this.context;
};
t.prototype.setNotifyContext = function(t) {
this.context = t;
};
t.prototype.notifyObserver = function(t) {
this.getNotifyMethod().call(this.getNotifyContext(), t);
};
t.prototype.compareNotifyContext = function(t) {
return t === this.context;
};
return t;
}();
t.Observer = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function() {
function e() {
this.mediatorMap = null;
this.observerMap = null;
if (e.instance) throw Error(e.SINGLETON_MSG);
e.instance = this;
this.mediatorMap = {};
this.observerMap = {};
this.initializeView();
}
e.prototype.initializeView = function() {};
e.prototype.registerObserver = function(t, e) {
var n = this.observerMap[t];
n ? n.push(e) : this.observerMap[t] = [ e ];
};
e.prototype.removeObserver = function(t, e) {
for (var n = this.observerMap[t], o = n.length; o--; ) if (n[o].compareNotifyContext(e)) {
n.splice(o, 1);
break;
}
0 == n.length && delete this.observerMap[t];
};
e.prototype.notifyObservers = function(t) {
var e = t.getName(), n = this.observerMap[e];
if (n) for (var o = n.slice(0), i = o.length, r = 0; r < i; r++) o[r].notifyObserver(t);
};
e.prototype.registerMediator = function(e) {
var n = e.getMediatorName();
if (!this.mediatorMap[n]) {
this.mediatorMap[n] = e;
var o = e.listNotificationInterests(), i = o.length;
if (i > 0) for (var r = new t.Observer(e.handleNotification, e), s = 0; s < i; s++) this.registerObserver(o[s], r);
e.onRegister();
}
};
e.prototype.retrieveMediator = function(t) {
return this.mediatorMap[t] || null;
};
e.prototype.removeMediator = function(t) {
var e = this.mediatorMap[t];
if (!e) return null;
for (var n = e.listNotificationInterests(), o = n.length; o--; ) this.removeObserver(n[o], e);
delete this.mediatorMap[t];
e.onRemove();
return e;
};
e.prototype.hasMediator = function(t) {
return null != this.mediatorMap[t];
};
e.SINGLETON_MSG = "View singleton already constructed!";
e.instance = null;
e.getInstance = function() {
e.instance || (e.instance = new e());
return e.instance;
};
return e;
}();
t.View = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function() {
function e() {
this.view = null;
this.commandMap = null;
if (e.instance) throw Error(e.SINGLETON_MSG);
e.instance = this;
this.commandMap = {};
this.initializeController();
}
e.prototype.initializeController = function() {
this.view = t.View.getInstance();
};
e.prototype.executeCommand = function(t) {
var e = this.commandMap[t.getName()];
e && new e().execute(t);
};
e.prototype.registerCommand = function(e, n) {
this.commandMap[e] || this.view.registerObserver(e, new t.Observer(this.executeCommand, this));
this.commandMap[e] = n;
};
e.prototype.hasCommand = function(t) {
return null != this.commandMap[t];
};
e.prototype.removeCommand = function(t) {
if (this.hasCommand(t)) {
this.view.removeObserver(t, this);
delete this.commandMap[t];
}
};
e.instance = null;
e.SINGLETON_MSG = "Controller singleton already constructed!";
e.getInstance = function() {
e.instance || (e.instance = new e());
return e.instance;
};
return e;
}();
t.Controller = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function() {
function t() {
this.proxyMap = null;
if (t.instance) throw Error(t.SINGLETON_MSG);
t.instance = this;
this.proxyMap = {};
this.initializeModel();
}
t.prototype.initializeModel = function() {};
t.prototype.registerProxy = function(t) {
this.proxyMap[t.getProxyName()] = t;
t.onRegister();
};
t.prototype.removeProxy = function(t) {
var e = this.proxyMap[t];
if (e) {
delete this.proxyMap[t];
e.onRemove();
}
return e;
};
t.prototype.retrieveProxy = function(t) {
return this.proxyMap[t] || null;
};
t.prototype.hasProxy = function(t) {
return null != this.proxyMap[t];
};
t.SINGLETON_MSG = "Model singleton already constructed!";
t.instance = null;
t.getInstance = function() {
t.instance || (t.instance = new t());
return t.instance;
};
return t;
}();
t.Model = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function() {
function t(t, e, n) {
"undefined" == typeof e && (e = null);
"undefined" == typeof n && (n = null);
this.name = null;
this.body = null;
this.type = null;
this.name = t;
this.body = e;
this.type = n;
}
t.prototype.getName = function() {
return this.name;
};
t.prototype.setBody = function(t) {
this.body = t;
};
t.prototype.getBody = function() {
return this.body;
};
t.prototype.setType = function(t) {
this.type = t;
};
t.prototype.getType = function() {
return this.type;
};
t.prototype.toString = function() {
var t = "Notification Name: " + this.getName();
return (t += "\nBody:" + (null == this.getBody() ? "null" : this.getBody().toString())) + "\nType:" + (null == this.getType() ? "null" : this.getType());
};
return t;
}();
t.Notification = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function() {
function e() {
this.model = null;
this.view = null;
this.controller = null;
if (e.instance) throw Error(e.SINGLETON_MSG);
e.instance = this;
this.initializeFacade();
}
e.prototype.initializeFacade = function() {
this.initializeModel();
this.initializeController();
this.initializeView();
};
e.prototype.initializeModel = function() {
this.model || (this.model = t.Model.getInstance());
};
e.prototype.initializeController = function() {
this.controller || (this.controller = t.Controller.getInstance());
};
e.prototype.initializeView = function() {
this.view || (this.view = t.View.getInstance());
};
e.prototype.registerCommand = function(t, e) {
this.controller.registerCommand(t, e);
};
e.prototype.removeCommand = function(t) {
this.controller.removeCommand(t);
};
e.prototype.hasCommand = function(t) {
return this.controller.hasCommand(t);
};
e.prototype.registerProxy = function(t) {
this.model.registerProxy(t);
};
e.prototype.retrieveProxy = function(t) {
return this.model.retrieveProxy(t);
};
e.prototype.removeProxy = function(t) {
var e;
this.model && (e = this.model.removeProxy(t));
return e;
};
e.prototype.hasProxy = function(t) {
return this.model.hasProxy(t);
};
e.prototype.registerMediator = function(t) {
this.view && this.view.registerMediator(t);
};
e.prototype.retrieveMediator = function(t) {
return this.view.retrieveMediator(t);
};
e.prototype.removeMediator = function(t) {
var e;
this.view && (e = this.view.removeMediator(t));
return e;
};
e.prototype.hasMediator = function(t) {
return this.view.hasMediator(t);
};
e.prototype.notifyObservers = function(t) {
this.view && this.view.notifyObservers(t);
};
e.prototype.sendNotification = function(e, n, o) {
"undefined" == typeof n && (n = null);
"undefined" == typeof o && (o = null);
this.notifyObservers(new t.Notification(e, n, o));
};
e.SINGLETON_MSG = "Facade singleton already constructed!";
e.instance = null;
e.getInstance = function() {
e.instance || (e.instance = new e());
return e.instance;
};
return e;
}();
t.Facade = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function() {
function e() {
this.facade = null;
this.facade = t.Facade.getInstance();
}
e.prototype.sendNotification = function(t, e, n) {
"undefined" == typeof e && (e = null);
"undefined" == typeof n && (n = null);
this.facade.sendNotification(t, e, n);
};
return e;
}();
t.Notifier = e;
})(puremvc || (puremvc = {}));

var __extends = function(t, e) {
function n() {
this.constructor = t;
}
n.prototype = e.prototype;
t.prototype = new n();
};

(function(t) {
"use strict";
var e = function(t) {
__extends(e, t);
function e() {
t.call(this);
this.subCommands = null;
this.subCommands = new Array();
this.initializeMacroCommand();
}
e.prototype.initializeMacroCommand = function() {};
e.prototype.addSubCommand = function(t) {
this.subCommands.push(t);
};
e.prototype.execute = function(t) {
for (var e = this.subCommands.slice(0), n = this.subCommands.length, o = 0; o < n; o++) new (0, 
e[o])().execute(t);
this.subCommands.splice(0);
};
return e;
}(t.Notifier);
t.MacroCommand = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function(t) {
__extends(e, t);
function e() {
t.apply(this, arguments);
}
e.prototype.execute = function() {};
return e;
}(t.Notifier);
t.SimpleCommand = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function(t) {
__extends(e, t);
function e(n, o) {
"undefined" == typeof n && (n = null);
"undefined" == typeof o && (o = null);
t.call(this);
this.mediatorName = null;
this.viewComponent = null;
this.mediatorName = null != n ? n : e.NAME;
this.viewComponent = o;
}
e.prototype.getMediatorName = function() {
return this.mediatorName;
};
e.prototype.getViewComponent = function() {
return this.viewComponent;
};
e.prototype.setViewComponent = function(t) {
this.viewComponent = t;
};
e.prototype.listNotificationInterests = function() {
return new Array();
};
e.prototype.handleNotification = function() {};
e.prototype.onRegister = function() {};
e.prototype.onRemove = function() {};
e.NAME = "Mediator";
return e;
}(t.Notifier);
t.Mediator = e;
})(puremvc || (puremvc = {}));

(function(t) {
"use strict";
var e = function(t) {
__extends(e, t);
function e(n, o) {
"undefined" == typeof n && (n = null);
"undefined" == typeof o && (o = null);
t.call(this);
this.proxyName = null;
this.data = null;
this.proxyName = null != n ? n : e.NAME;
null != o && this.setData(o);
}
e.prototype.getProxyName = function() {
return this.proxyName;
};
e.prototype.setData = function(t) {
this.data = t;
};
e.prototype.getData = function() {
return this.data;
};
e.prototype.onRegister = function() {};
e.prototype.onRemove = function() {};
e.NAME = "Proxy";
return e;
}(t.Notifier);
t.Proxy = e;
})(puremvc || (puremvc = {}));

window.puremvc = puremvc;