var app = window.app || {},
business_paypal = ''; // aquí va tu correo electrónico de paypal

(function($){
	'use strict';

	//no coflict con underscores

	app.init = function(){
		//totalItems totalAmount
		var total = 0,
		items = 0
		var cart = (JSON.parse(localStorage.getItem('cart')) != null) ? JSON.parse(localStorage.getItem('cart')) : {items : []} ;
		
		if(undefined != cart.items && cart.items != null && cart.items != '' && cart.items.length > 0){
			_.forEach(cart.items, function(n, key) {
			   items = (items + n.cant)
			   total = total + (n.cant * n.price)
			});

		}

		$('#totalItems').text(items)
		$('.totalAmount').text('$ '+total+ ' MXN')
		
	}

	app.createProducts = function(){
		var productos = [
			{
				id : 1,
				img : 'https://www.gobro.com.mx/images/misushikin/misushikin1.jpg',
				name : 'Manhattan',
				price : 299.00,
				desc : 'Queso, fresa, rutimi y por fuera philadelphia con fresa y salsa de anguila.',
				stock : 10
			},
			{
				id : 2,
				name : 'Palawan',
				img : 'https://www.gobro.com.mx/images/misushikin/misushikin2.jpg',
				price : 199.00,
				desc : 'Arroz al vapor, salmón, queso philadelphia, aguacate, mango, zanahoria, calabaza envuelto en hoja de arroz.',
				stock : 10
			},
			{
				id : 3,
				name : 'Baleares',
				img : 'https://www.gobro.com.mx/images/misushikin/misushikin3.jpg',
				price : 99.00,
				desc : 'Queso aguacate camarón a la plancha y chipotle cubierto de ajonjolí y chipotle.',
				stock : 10
			},
			{
				id : 4,
				name : 'Cozumel',
				img : 'https://www.gobro.com.mx/images/misushikin/misushikin4.jpg',
				price : 80.00,
				desc : 'Aguacate, queso mozalera, calabaza, zanahoria envuelto en pollo y salsa de chipotle.',
				stock : 10
			},
			{
				id : 5,
				name : 'Iguana Cay',
				img : 'https://www.gobro.com.mx/images/misushikin/misushikin5.jpg',
				price : 1.00,
				desc : 'Cangrejo empanizado, philadelfia y pepino envuelto en aguacate, bañado en anguila y chipotle.',
				stock : 10
			}			
		],
		wrapper = $('.productosWrapper'),
		contenido = ''

		for(var i = 0; i < productos.length; i++){

			if(productos[i].stock > 0){

				contenido+= '<div class="coin-wrapper" align="center" > <div class="clearfix">'
				contenido+= '		<span class="col-sm-4 columns product-details">'
				contenido+= '			<h4>'+productos[i].name+' <span class="price">$ '+productos[i].price+' MXN</span></h4>'
				contenido+= '		</span>'
				contenido+= '		<img src="'+productos[i].img+'" alt="'+productos[i].name+'" width="250px">' 
				contenido+= '		<p align="justify">'+productos[i].desc+'</p>' 								
				contenido+= '		<a class="col-sm-4 columns btn submit ladda-button prod-'+productos[i].id+'" data-style="slide-center" onclick="app.addtoCart('+productos[i].id+');">Agregar +</a>'
				contenido+= '		<div class="clearfix"></div>'
				contenido+= '</div><br>'

			}

		}

		wrapper.html(contenido)

		localStorage.setItem('productos',JSON.stringify(productos))
	}

	app.addtoCart = function(id){
		var l = Ladda.create( document.querySelector( '.prod-'+id ) );

		l.start();
		var productos = JSON.parse(localStorage.getItem('productos')),
		producto = _.find(productos,{ 'id' : id }),
		cant = 1
		if(cant <= producto.stock){
			if(undefined != producto){
				if(cant > 0){
					setTimeout(function(){
						var cart = (JSON.parse(localStorage.getItem('cart')) != null) ? JSON.parse(localStorage.getItem('cart')) : {items : []} ;
						app.searchProd(cart,producto.id,parseInt(cant),producto.name,producto.price,producto.img,producto.stock)
						l.stop();
					},2000)
				}else{
					alert('Solo se permiten cantidades mayores a cero')
				}
			}else{
				alert('Oops! algo malo ocurrió, inténtalo de nuevo más tarde')
			}
		}else{
			alert('No se pueden añadir más de este producto')
		}
	}

	app.searchProd = function(cart,id,cant,name,price,img,available){
		//si le pasamos un valor negativo a la cantidad, se descuenta del carrito
		var curProd = _.find(cart.items, { 'id': id })

		if(undefined != curProd && curProd != null){
			//ya existe el producto, aÃ±adimos uno mÃ¡s a su cantidad
			if(curProd.cant < available){
				curProd.cant = parseInt(curProd.cant + cant)
			}else{
				alert('No se pueden añadir más de este producto')
			}
			
		}else{
			//sino existe lo agregamos al carrito
			var prod = {
				id : id,
				cant : cant,
				name : name,
				price : price,
				img : img,
				available : available
			}
			cart.items.push(prod)
			
		}
		localStorage.setItem('cart',JSON.stringify(cart))
		app.init()
		app.getProducts()
		app.updatePayForm()
	}

	app.getProducts = function(){
		var cart = (JSON.parse(localStorage.getItem('cart')) != null) ? JSON.parse(localStorage.getItem('cart')) : {items : []},
		msg = '',
		wrapper = $('.cart'),
		total = 0
		wrapper.html('')

		if(undefined == cart || null == cart || cart == '' || cart.items.length == 0){
			wrapper.html('<li><b>Carrito Vacio.</b></li>');
			$('.cart').css('left','-400%')
		}else{
			var items = '';
			_.forEach(cart.items, function(n, key) {
	
			   total = total  + (n.cant * n.price)
			   items += '<li>'
			   items += '<p class="title">'+n.name+'<br><span class="price">'+n.cant+' x $ '+n.price+' MXN</span> <button class="add" onclick="app.updateItem('+n.id+','+n.available+')"><b>X</b></button><div class="clearfix"></div></p>'
			   items += '</li>'
			});
			var totalr = total + 0
			sessionStorage.setItem('usuario',totalr);
			//agregar el total al carrito
			items += '<li id="total"><b>Total : $ '+totalr+' MXN <div id="submitForm"></div></li>'
			wrapper.html(items)
			$('.cart').css('left','-500%')
		}
	}

	app.updateItem = function(id,available){
		//resta uno a la cantidad del carrito de compras
		var cart = (JSON.parse(localStorage.getItem('cart')) != null) ? JSON.parse(localStorage.getItem('cart')) : {items : []} ,
		curProd = _.find(cart.items, { 'id': id })
			//actualizar el carrito
			curProd.cant = curProd.cant - 1;
			//validar que la cantidad no sea menor a 0
			if(curProd.cant > 0){
				localStorage.setItem('cart',JSON.stringify(cart))
				app.init()
				app.getProducts()
				app.updatePayForm()
			}else{
				app.deleteProd(id,true)
			}
	}

	app.delete = function(id){
		var cart = (JSON.parse(localStorage.getItem('cart')) != null) ? JSON.parse(localStorage.getItem('cart')) : {items : []} ;
		var curProd = _.find(cart.items, { 'id': id })
		_.remove(cart.items, curProd);
		localStorage.setItem('cart',JSON.stringify(cart))
		app.init()
		app.getProducts()
		app.updatePayForm()
	}

	app.deleteProd = function(id,remove){
		if(undefined != id && id > 0){
			
			if(remove == true){
				app.delete(id)
			}else{
				var conf = confirm('¿Deseas eliminar este producto?')
				if(conf){
					app.delete(id)
				}
			}
			
		}
	}

	app.updatePayForm = function(){
		//eso va a generar un formulario dinamico para paypal
		//con los productos y sus precios   method="post"
		var cart = (JSON.parse(localStorage.getItem('cart')) != null) ? JSON.parse(localStorage.getItem('cart')) : {items : []} ;
		var statics = '<form name="f1" id="f1" action="principal.html">',
		dinamic = '',
		wrapper = $('#submitForm')
		var envio = 0.00;
		wrapper.html('')
		
		if(undefined != cart && null != cart && cart != ''){
			var i = 1;
			_.forEach(cart.items, function(prod, key) {
					dinamic += prod.cant+' : '+prod.name+' '
					dinamic += 'Precio :$'+prod.price+'.ºº    |  '
				i++;
			})
			 //var tot = t.toString();
             //document.f1.carritos.value=tot;   
             //alert(dinamic)
            statics += '<p>Incluye Envio:$'+ envio +'</p>' 
			statics += '<button type="submit" class="pay">Odenar</button></form>'

			  var ram = Math.round(Math.random()*10000000);
			  var restaurante = "MISUSHIKIN";
			  //Asignamos el valor al objeto SessionStorage
			 
			 sessionStorage.setItem('usuario2',dinamic);
			 sessionStorage.setItem('restaurante',restaurante); 
			 sessionStorage.setItem('ram',ram); 
			wrapper.html(statics)
		}
	}
	$(document).ready(function(){
		app.init()
		app.getProducts()
		app.updatePayForm()
		app.createProducts()
	})

})(jQuery)