package com.alibaba.tesseract.page;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Created by yiwei on 2020-10-16.
 */
public class PageCache {

    public void saveCache(Context context, String name, JSONObject data) {
        if (context == null || TextUtils.isEmpty(name) || data == null) {
            return;
        }
        try {
            saveString2File(getCacheFilePath(context, name), data.toString());
        } catch (Throwable e) {}
    }

    public JSONObject getCacheData(Context context, String name) {
        if (context == null || TextUtils.isEmpty(name)) {
            return null;
        }
        try {
            String jsonString = readFile2String(getCacheFilePath(context, name));
            if (!TextUtils.isEmpty(jsonString)) {
                return JSON.parseObject(jsonString);
            }
        } catch (Exception e) {
            Log.e("PageCache", e.getMessage());
        }
        return null;
    }

    public void cleanCache(Context context, String name) {
        if (context == null || TextUtils.isEmpty(name)) {
            return;
        }
        File cacheFile = new File(getCacheFilePath(context, name));
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    private static String readFile2String(String filePath) {
        File target = new File(filePath);
        FileInputStream is = null;
        StringBuilder stringBuilder = null;
        try {
            if (target.length() != 0) {
                is = new FileInputStream(target);
                InputStreamReader streamReader = new InputStreamReader(is);
                BufferedReader reader = new BufferedReader(streamReader);
                String line;
                stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    // stringBuilder.append(line);
                    stringBuilder.append(line);
                }
                reader.close();
                is.close();
            } else {
                return "";
            }
        } catch (Exception e) {
            Log.e("PageCache", e.getMessage());
        }
        return String.valueOf(stringBuilder);
    }

    private String getCacheFilePath(Context context, String name) {
        return context.getFilesDir().getAbsolutePath() + File.pathSeparatorChar + name + ".json";
    }

    private void saveString2File(String path, String content) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(path);
            writer.write(content);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}
