package com.alibaba.tesseract.page.activity;

import static com.alibaba.tesseract.page.activity.Constants.MULTI_PAGE_REQUEST_API;
import static com.alibaba.tesseract.page.activity.Constants.REQUEST_TYPE_FORCE;
import static com.alibaba.tesseract.page.activity.Constants.REQUEST_TYPE_LOAD;
import static com.alibaba.tesseract.page.activity.Constants.REQUEST_TYPE_LOGIN;
import static com.alibaba.tesseract.page.activity.Constants.REQUEST_TYPE_NORMAL_REFRESH;
import static com.alibaba.tesseract.page.activity.Constants.REQUEST_TYPE_PULL_FRESH;
import static com.alibaba.tesseract.page.activity.Constants.REQUEST_TYPE_RESUME;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.alibaba.android.tesseract.core.event.base.ISubscriber;
import com.alibaba.android.tesseract.core.instance.ITesseract;
import com.alibaba.android.tesseract.core.instance.ITesseractInstance;
import com.alibaba.android.tesseract.core.instance.TesseractInstanceConfig;
import com.alibaba.android.tesseract.core.request.IRequestCallback;
import com.alibaba.android.tesseract.core.request.Request;
import com.alibaba.android.tesseract.core.request.RequestBuilder;
import com.alibaba.android.tesseract.sdk.common.model.IDMComponent;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.account.IUserManagerService;
import com.alibaba.gov.android.api.account.UserInfo;
import com.alibaba.gov.android.api.dynamicres.Coordinate;
import com.alibaba.gov.android.api.dynamicres.IDynamicResourceService;
import com.alibaba.gov.android.api.jupiter.IJupiterRightBtnService;
import com.alibaba.gov.android.api.location.ILocationService;
import com.alibaba.gov.android.api.login.ILoginService;
import com.alibaba.gov.android.api.network.request.body.ZWJSONObjectRequestBody;
import com.alibaba.gov.android.api.site.ISiteMidService;
import com.alibaba.gov.android.api.site.SiteModel;
import com.alibaba.gov.android.api.switchchannel.ISwitchChannelService;
import com.alibaba.gov.android.api.switchchannel.SwitchChannelConst;
import com.alibaba.gov.android.api.video.IVideoPlayService;
import com.alibaba.gov.android.api.zwmonitor.IAppMonitorApi;
import com.alibaba.gov.android.api.zwmonitor.IUserOperationApi;
import com.alibaba.gov.android.api.zwmonitor.IZWMonitor;
import com.alibaba.gov.android.common.config.AppConfig;
import com.alibaba.gov.android.foundation.base.fragment.BaseFragment;
import com.alibaba.gov.android.foundation.env.EnvUtil;
import com.alibaba.gov.android.foundation.event.CommonEvent;
import com.alibaba.gov.android.foundation.utils.File2JsonUtil;
import com.alibaba.gov.android.foundation.utils.ScreenUtil;
import com.alibaba.gov.android.foundation.utils.ToastUtil;
import com.alibaba.gov.android.navigation.UniversalNavigationBar;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;
import com.alibaba.gov.android.tesseract.page.R;
import com.alibaba.tesseract.page.PageCache;
import com.alibaba.tesseract.page.events.ModifyDataEvent;
import com.alibaba.tesseract.page.events.RefreshPageEvent;
import com.alibaba.tesseract.page.inter.ILifecycleCallback;
import com.alibaba.tesseract.page.inter.ILoadMoreListener;
import com.alibaba.tesseract.page.inter.IRefreshListener;
import com.alibaba.tesseract.page.manager.BaseSubscribeUtil;
import com.alibaba.tesseract.page.manager.TesseractPageManager;
import com.alibaba.tesseract.page.utils.RVHeightUtils;
import com.alibaba.tesseract.page.utils.UrlParserUtils;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by yiwei on 2020-04-08.
 */
public class BaseTesseractFragment extends BaseFragment implements OnRefreshListener, OnLoadMoreListener {
    public ITesseractInstance mTesseractInstance;
    protected RefreshLayout mRefreshLayout;
    private ClassicsHeader mRefreshHeader;
    protected FrameLayout mBody;
    protected String mSinglePageRequestUrl;
    protected String mMultiPageRequestUrl;
    private String mSiteId;
    private String mUserChannel;
    private String mPageId;
    private String mUrlTitle;
    private String mPageName;
    protected boolean mEnableLoadMore = true;
    protected boolean mEnablePullRefresh = true;
    //同时禁止recyclerview滚动、下拉刷新、加载更多
    protected boolean mDisableAllScroll = false;
    //禁止recyclerview滚动
    protected boolean mEnableScrollVertical = true;
    protected boolean mEnableLoginReceive = false;
    protected boolean mEnableResumeRefresh = false;
    protected boolean mMgopRequest = false;
    protected boolean mHideHeaderBar = false;
    protected boolean mHideLoading = false;
    protected boolean mMgopRequestNeedLogin = false;
    protected boolean mEnableRefreshColor = true;
    private Map<String, String> mRequestHeader;
    private FrameLayout mHeaderLayout;
    private FrameLayout mBottomLayout;
    private View mHeaderView;
    private UniversalNavigationBar mNavBar;
    private View mBottomView;

    private HashMap<String, String> mMonitorInfo;
    private IRefreshListener refreshListener;
    private Map<String, ISubscriber> mEventSubscriber;
    private ILoadMoreListener loadMoreListener;
    private ILoginService mLoginService;
    private LoginStateChangeReceiver mLoginBroadcast;
    private ILifecycleCallback mLifecycle;
    private PageCache mPageCache;
    private JSONObject mLastGlobal;
    private String mPageBgColor = "#ffffff";
    protected boolean fragmentVisible = false;
    private IVideoPlayService playService;
    protected boolean forceRefreshFromEvent = false;
    private String sceneCode;

    @Override
    public int getLayoutResId() {
        return R.layout.base_tesseract_fragment_layout;
    }

    @Override
    public void findViews(View rootView) {
        mRefreshLayout = (RefreshLayout)rootView.findViewById(R.id.tesseract_fragment_refreshlayout);
        mRefreshHeader = rootView.findViewById(R.id.tesseract_refresh_header);
        mHeaderLayout = rootView.findViewById(R.id.tesseract_fragment_header);
        mBottomLayout = rootView.findViewById(R.id.tesseract_fragment_bottom);
        mBody = rootView.findViewById(R.id.tesseract_fragment_body);
        playService = ServiceManager.getInstance().getService(IVideoPlayService.class.getName());
    }

    @Override
    public boolean needEventBus() {
        return true;
    }

    @Override
    public void initViews(View view) {
        initMonitorInfo();
        initHeaderView();
        initBottomView();
        initTesseract();
        initRecyclerView();
        initMultiReqUrl();
        loadCacheDataIfNeed();
        registerLoginReceive();
        initRefreshLayout();
    }


    private void initRefreshLayout() {
        toggleRefreshLayoutLoadMore(mEnableLoadMore);
        toggleRefreshLayoutPullRefresh(mEnablePullRefresh);
        mRefreshLayout.setEnableOverScrollDrag(mEnablePullRefresh && mEnableLoadMore);
        mRefreshHeader.setSpinnerStyle(SpinnerStyle.Scale);
        if (mEnableRefreshColor) {
            updateRefreshHeader();
        } else {
            mRefreshHeader.setPrimaryColor(Color.WHITE);
        }
        if (!TextUtils.isEmpty(mPageBgColor)) {
            ((SmartRefreshLayout)mRefreshLayout).setBackgroundColor(getSafeColor());
        }
    }

    private void updateRefreshHeader() {
        IDynamicResourceService resouceService = ServiceManager.getInstance().getService(IDynamicResourceService.class.getName());
        if (resouceService != null) {
            Coordinate coordinate = new Coordinate();
            coordinate.moduleId = "robot";
            coordinate.pageId = "epgov://newMainTab";
            JSONObject coObject = resouceService.getDynamicResource(coordinate);
            if (coObject != null) {
                JSONObject robotObj = coObject.getJSONObject("new_robot");
                if (robotObj != null) {
                    String pullRefreshBackgroundColor = robotObj.getString("pullRefreshBackgroundColor");
                    if (!TextUtils.isEmpty(pullRefreshBackgroundColor)) {
                        mRefreshHeader.setPrimaryColor(Color.parseColor(pullRefreshBackgroundColor));
                    }
                }
            }
        }
    }

    private void initMultiReqUrl() {
        mMultiPageRequestUrl = AppConfig.getString("baseHost") + MULTI_PAGE_REQUEST_API;
    }

    protected void loadCacheDataIfNeed() {
        if (mPageCache == null || mTesseractInstance == null) {
            return;
        }
        JSONObject cacheData = mPageCache.getCacheData(getContext(), pageName());
        if (cacheData == null || cacheData.isEmpty()) {
            if ("APP_HOME_NEW".equals(sceneCode)) {
                cacheData = JSON.parseObject(File2JsonUtil.convertAssertJsonFile2Json("PageCache_Page_Homepage.json"));
            } else if ("APP_HUDONG_NEW".equals(sceneCode)) {
                cacheData = JSON.parseObject(File2JsonUtil.convertAssertJsonFile2Json("PageCache_Page_Interactive.json"));
            }
            if (cacheData == null || cacheData.isEmpty()) {
                return;
            }
            cacheData.put("isCacheData", true);
            hideErrorView();
            mTesseractInstance.renderData(cacheData);
            return;
        }
        cacheData.put("isCacheData", true);
        hideErrorView();
        mTesseractInstance.renderData(cacheData);
    }

    public void registerLifecycle(ILifecycleCallback lifecycle) {
        this.mLifecycle = lifecycle;
    }

    private void registerLoginReceive() {
        mLoginBroadcast = new LoginStateChangeReceiver();
        mLoginService = ServiceManager.getInstance().getService(ILoginService.class.getName());
        if (mLoginService != null) {
            mLoginService.registerLoginReceiver(mLoginBroadcast);
            return;
        }
    }

    protected String pageName() {
        if (!TextUtils.isEmpty(mPageName)) {
            return mPageName;
        } else if (!TextUtils.isEmpty(mPageId)) {
            return "Page_Tesseract_" + mPageId;
        }
        return this.getClass().getSimpleName();
    }

    protected float stickTopVisibleHeight() {
        return 0;
    }

    protected TesseractInstanceConfig.StickTopVisibilityListener stickTopVisibilityListener() {
        return null;
    }

    private void initMonitorInfo() {
        mMonitorInfo = new HashMap<>();
        mMonitorInfo.put("title", mUrlTitle);
        mMonitorInfo.putAll(parseMonitorParamFromUrl(mSinglePageRequestUrl));

        IAppMonitorApi appMonitorApi = getAppMonitor();
        if (appMonitorApi != null) {
            appMonitorApi.commitSuccess(pageName(), "Page_Load", mMonitorInfo);
        }
    }


    /**
     * tesseract容器与服务端特定参数
     *
     * @param url
     */
    private void parseParamsFromUrl(String url) {
        if (TextUtils.isEmpty(url)) {
            return;
        }
        Uri uri = Uri.parse(url);
        mEnableLoginReceive = uri.getBooleanQueryParameter(Constants.LOGIN_RECEIVE, false);
        mEnableResumeRefresh = uri.getBooleanQueryParameter(Constants.RESUME_REFRESH, false);
        mEnableScrollVertical = uri.getBooleanQueryParameter(Constants.SCROLL_VERTICAL, true);
        mEnableRefreshColor = uri.getBooleanQueryParameter(Constants.REFRESH_COLOR, true);
        //如果通过方法禁用了，不再走url解析
        if (mEnableLoadMore) {
            mEnableLoadMore = uri.getBooleanQueryParameter(Constants.LOAD_MORE, true);
        }
        //如果通过方法禁用了，不再走url解析
        if (mEnablePullRefresh) {
            mEnablePullRefresh = uri.getBooleanQueryParameter(Constants.PULL_REFRESH, true);
        }
        //如果通过方法禁用了，不再走url解析
        if (!mHideHeaderBar) {
            mHideHeaderBar = uri.getBooleanQueryParameter(Constants.HIDE_HEADER_BAR, false);
        }
        mHideLoading = uri.getBooleanQueryParameter(Constants.HIDE_LOADING, false);
        mMgopRequest = uri.getBooleanQueryParameter(Constants.MGOP_REQUEST, false);
        mPageId = getQueryParamterOrDefault(uri, Constants.PAGE_ID, "");
        mUrlTitle = getQueryParamterOrDefault(uri, Constants.PAGE_TITLE, "");
        mDisableAllScroll = uri.getBooleanQueryParameter(Constants.FORBID_SCROLL, false);
        if (mDisableAllScroll) {
            mEnableScrollVertical = false;
            mEnablePullRefresh = false;
            mEnableLoadMore = false;
        }
        sceneCode = getQueryParamterOrDefault(uri, "sceneCode", "");
    }

    private String getQueryParamterOrDefault(Uri uri, String key, String defaultValue) {
        String result = uri.getQueryParameter(key);
        return result != null ? result : defaultValue;
    }

    protected Map<String, String> parseMonitorParamFromUrl(String url) {
        Map<String, String> map = new HashMap<>();
        if (!TextUtils.isEmpty(url)) {
            Uri uri = Uri.parse(url);
            Set set = uri.getQueryParameterNames();
            if (set == null) {
                return map;
            }
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                map.put(key, uri.getQueryParameter(key));
            }
        }
        return map;
    }

    private String parseAndSetSiteId(String url) {
        if (TextUtils.isEmpty(url)) {
            return "";
        }
        Uri uri = Uri.parse(url);
        mSiteId = uri.getQueryParameter("siteId");
        if (TextUtils.isEmpty(mSiteId)) {
            ISiteMidService siteService = ServiceManager.getInstance().getService(ISiteMidService.class.getName());
            if (siteService != null) {
                SiteModel siteModel = siteService.getGlobalSite();
                mSiteId = siteModel.code;
            }
        }
        if (url.contains("?")) {
            url += "&siteId=" + mSiteId;
        } else {
            url += "?siteId=" + mSiteId;
        }
        return url;
    }

    private String parseAndSetUserChannel(String url) {
        if (TextUtils.isEmpty(url)) {
            return "";
        }
        Uri uri = Uri.parse(url);
        mUserChannel = uri.getQueryParameter("userChannel");
        if (TextUtils.isEmpty(mUserChannel)) {
            ISwitchChannelService service = ServiceManager.getInstance().getService(ISwitchChannelService.class.getName());
            if (service != null) {
                mUserChannel = String.valueOf(service.getUserChannel());
            }
        }
        if (url.contains("?")) {
            url += "&userChannel=" + mUserChannel;
        } else {
            url += "?userChannel=" + mUserChannel;
        }
        return url;
    }

    private void initHeaderView() {
        if (mHideHeaderBar) {
            mHeaderLayout.setVisibility(View.GONE);
            return;
        }
        if (mHeaderView == null) {
            mHeaderView = initDefaultHeaderView();
        }
        mHeaderLayout.removeAllViews();
        mHeaderLayout.addView(mHeaderView);
        mHeaderLayout.setVisibility(View.VISIBLE);
    }

    private void initBottomView() {
        if (mBottomView == null) {
            mBottomLayout.setVisibility(View.GONE);
            return;
        }
        mBottomLayout.removeAllViews();
        mBottomLayout.addView(mBottomView);
        mBottomLayout.setVisibility(View.VISIBLE);
    }

    private View initDefaultHeaderView() {
        mNavBar = new UniversalNavigationBar(getContext());
        setTitle(mUrlTitle);
        showShareBtn(mUrlTitle);
        return mNavBar.getUniversalNavigationBarView();
    }

    public void setPageBackgroundColor(String bgColor) {
        this.mPageBgColor = bgColor;
    }

    public void setMultiPageRequestUrl(String requestUrl) {
        this.mMultiPageRequestUrl = requestUrl;
    }

    public void setRequestHeader(Map<String, String> requestHeader) {
        this.mRequestHeader = requestHeader;
    }

    public void setHeaderView(View headerView) {
        this.mHeaderView = headerView;
    }

    public void setBottomView(View bottomView) {
        this.mBottomView = bottomView;
    }

    private void initTesseract() {
        ITesseract tesseract = ServiceManager.getInstance().getService(ITesseract.class.getName());
        if (tesseract == null) {
            return;
        }
        mTesseractInstance = tesseract.createInstance(getContext(),
                new TesseractInstanceConfig()
                        .pageName(pageName())
                        .requestNeedLogin(mMgopRequestNeedLogin)
                        .backgroundColor(getSafeColor())
                        .setComponentDebugMark(1002)
                        .setStickTopVisibleHeight(stickTopVisibleHeight())
                        .setStickTopVisibilityListener(stickTopVisibilityListener()));
        BaseSubscribeUtil.initSubsriber(mTesseractInstance, mEventSubscriber);
        mBody.removeAllViews();
        mBody.addView(mTesseractInstance.getRootView());
        TesseractPageManager.getInstance().registerTesseractPage(this);
    }

    private int getSafeColor() {
        int color = 0;
        try {
            color = Color.parseColor(mPageBgColor);
        } catch (Throwable e){
            color = Color.parseColor("#ffffff");
        }
        return color;
    }

    private HashMap<String, String> makeHeaders() {
        HashMap<String, String> headers = new HashMap<>();
        if (mRequestHeader != null && !mRequestHeader.isEmpty()) {
            headers.putAll(mRequestHeader);
        }
        IUserManagerService userManagerService = ServiceManager.getInstance().getService(IUserManagerService.class.getName());
        if (userManagerService == null) {
            return headers;
        }
        UserInfo userInfo = userManagerService.getUserInfo();
        if (userInfo == null) {
            return headers;
        }
        String token = userInfo.getToken();
        if (!TextUtils.isEmpty(token)) {
            headers.put("token", token);
        }
        ILocationService locationService = ServiceManager.getInstance().getService(ILocationService.class.getName());
        String latitude = "0".equals(locationService.getLatLon().first) ? "30.228324" : locationService.getLatLon().first;
        String longitude = "0".equals(locationService.getLatLon().second) ? "120.040458" : locationService.getLatLon().second;
        headers.put("latitude", latitude);
        headers.put("longitude", longitude);
        if (!EnvUtil.isRelease()) {
            headers.put("isTestUrl", "true");
        }
        return headers;
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (isVisibleToUser && isVisible()) {
            onVisible();
        } else {
            onInvisible();
        }
        super.setUserVisibleHint(isVisibleToUser);
    }

    @Override
    public void onResume() {
        super.onResume();
        IUserOperationApi userMonitor = getUserMonitor();
        if (userMonitor != null) {
            userMonitor.pageIn(pageName(), null);
            userMonitor.updatePageName(pageName());
        }
        if (getUserVisibleHint() && !isHidden()) {
            onVisible();
        }
    }

    protected void onVisible() {
        if (forceRefreshFromEvent) {
            forceRefreshFromEvent = false;
            doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_FORCE);
        } else {
            if (mEnableResumeRefresh) {
                doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_RESUME);
            }
        }
        if (mLifecycle != null) {
            mLifecycle.onResume();
        }
        fragmentVisible = true;
        if (playService != null) {
            playService.onResume(getActivity());
        }
    }

    protected void onInvisible() {
        fragmentVisible = false;
        if (playService != null) {
            playService.onPause(getActivity());
        }
    }

    public JSONObject getDataIfVisible() {
        JSONObject data = null;
        if (fragmentVisible && mTesseractInstance != null) {
            data = mTesseractInstance.getRenderData();
        }
        return data;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        TesseractPageManager.getInstance().unRegisterTesseractPage(this);

        if (EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().unregister(this);
        }
        if (mTesseractInstance != null) {
            mTesseractInstance.destroy();
        }
        if (mLoginService != null && mLoginBroadcast != null) {
            mLoginService.unregisterLoginReceiver(mLoginBroadcast);
        }
        if (playService != null) {
            playService.releasePlayer(getActivity());
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        IUserOperationApi userMonitor = getUserMonitor();
        if (userMonitor != null) {
            userMonitor.pageOut(pageName(), null);
        }
        onInvisible();
    }

    protected void initRecyclerView() {
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext()) {
            @Override
            public boolean canScrollVertically() {
                return mEnableScrollVertical;
            }
        };
        final RecyclerView recyclerView = mTesseractInstance.getRecyclerView();
        recyclerView.setLayoutManager(layoutManager);

        //获取内容区高度
        ViewTreeObserver observer = recyclerView.getViewTreeObserver();
        observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener() {
            @Override
            public boolean onPreDraw() {
                recyclerView.getViewTreeObserver().removeOnPreDrawListener(this);
                RVHeightUtils.putRVHeight(pageName(), recyclerView.getHeight());
                return true;
            }
        });
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == RecyclerView.SCROLL_STATE_DRAGGING) {
                    postHiddenEvent();
                }
            }

            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
            }
        });
    }

    private void postHiddenEvent() {
        CommonEvent event = new CommonEvent("HiddenRobot", null);
        EventBus.getDefault().post(event);
    }

    private void setTitle(String title) {
        if (TextUtils.isEmpty(title)) {
            return;
        }
        if (mNavBar != null) {
            mNavBar.setTitle(title);
        }
    }

    private void showShareBtn(String title) {
        Activity activity = getActivity();
        if (activity == null) {
            return;
        }
        List<View> views = new ArrayList<>();
        String url = null;
        try {
            Bundle bundle = activity.getIntent().getExtras();
            if (bundle != null) {
                url = bundle.getString("url", "");
            } else {
                url = getActivity().getIntent().getData().toString();
            }
        } catch (Exception e) {

        }
        IJupiterRightBtnService service = ServiceManager.getInstance().getService(IJupiterRightBtnService.class.getName());
        if (service != null && !TextUtils.isEmpty(url)) {
            views.add(service.getRightBtn(activity, url, pageName()));
            if (mNavBar != null) {
                mNavBar.refreshMenuViews(views);
            }
        }
    }


    @Override
    public void onRefresh(RefreshLayout refreshLayout) {
        mRefreshLayout.finishRefresh(1000);
        if (refreshListener != null && this.refreshListener.onRefresh()) {
            return;
        }
        doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_PULL_FRESH);
    }

    @Override
    public void requestData() {
        if (!mEnableResumeRefresh) {
            doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_LOAD);
        }
    }

    public void refresh() {
        doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_NORMAL_REFRESH);
    }

    public void doRefresh(String requestUrl, final String reqType) {
        if (refreshListener != null) {
            refreshListener.onRefresh();
        }
        if (TextUtils.isEmpty(requestUrl)) {
            return;
        }
        if (!mHideLoading) {
            mTesseractInstance.showLoading("");
        }
        if (mMgopRequest) {
            doMgopRequest(requestUrl, reqType);
        } else {
            doNormalRequest(requestUrl, reqType);
        }
    }


    private void doNormalRequest(String requestUrl, final String requestType) {
        final long start = System.currentTimeMillis();
        mTesseractInstance.renderRemoteData(requestUrl, makeHeaders(), new IRequestCallback() {
            @Override
            public void onError(int errorCode, String message, Map<String, ?> map) {
                dealError(errorCode, message, start, requestType);
            }

            @Override
            public void onSuccess(JSONObject jsonObject, Map<String, ?> map) {
                dealSuccess(jsonObject, start, requestType);
            }
        });
    }

    private void doMgopRequest(String requestUrl, final String requestType) {
        final long start = System.currentTimeMillis();
        mTesseractInstance.renderRemoteData(getRequestParamters(requestUrl), makeHeaders(), new IRequestCallback() {
            @Override
            public void onError(int errorCode, String message, Map<String, ?> map) {
                dealError(errorCode, message, start, requestType);
            }

            @Override
            public void onSuccess(JSONObject jsonObject, Map<String, ?> map) {
                dealSuccess(jsonObject, start, requestType);
            }
        });
    }


    protected void dealSuccess(JSONObject jsonObject, long startTime, String requestType) {
        long diff = System.currentTimeMillis() - startTime;
        if (!mHideLoading) {
            mTesseractInstance.hideLoading();
        }
        if (!mHideHeaderBar) {
            String title = parseTitleFromGlobal(jsonObject);
            setTitle(title);
            //showShareBtn(title);
        }
        toggleRefreshLayoutLoadMore(mTesseractInstance.canLoadMore());
        toggleRefreshLayoutMoreData(!mTesseractInstance.canLoadMore());

        if (jsonObject == null) {
            return;
        }
        hideErrorView();
        if (jsonObject.getBooleanValue("success")) {
            if (mPageCache != null) {
                mPageCache.saveCache(getContext(), pageName(), jsonObject);
            }
        } /*else if ("3".equals(jsonObject.getString("resultCode"))) {
            if (mLifecycle != null) {
                mLifecycle.onLoginInvaliad();
            }
        } else {
            loadCacheDataIfNeed();
            if (mTesseractInstance.getRenderData() == null || !mTesseractInstance.getRenderData().getBooleanValue("success")) {
                //当前页面无数据，显示缺省页
                showErrorView(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_PULL_FRESH);
                    }
                });
            }
            String errorMsg = jsonObject.getString("errorMsg");
            if ("MainActivity".equalsIgnoreCase(getActivity().getClass().getSimpleName())) {
                if (REQUEST_TYPE_PULL_FRESH.equalsIgnoreCase(requestType)) {
                    if (!TextUtils.isEmpty(errorMsg)) {
                        ToastUtil.showToast(errorMsg);
                    }
                }
            } else {
                if (!TextUtils.isEmpty(errorMsg)) {
                    ToastUtil.showToast(errorMsg);
                }
            }
        }*/
        //resetPosition();
        //请求打点
        HashMap<String, String> args = new HashMap<>(mMonitorInfo);
        args.put("interval", diff + "");
        args.put("isLoadSuccess", "Y");
        IAppMonitorApi appMonitorApi = getAppMonitor();
        if (appMonitorApi != null) {
            appMonitorApi.commitSuccess(pageName(), "Page_Load_Complete", args);
        }
    }

    private void dealError(int errorCode, String message, long startTime, final String requestType) {
        long diff = System.currentTimeMillis() - startTime;
        if (!mHideLoading) {
            mTesseractInstance.hideLoading();
        }

        if (mTesseractInstance.getRenderData() == null || !mTesseractInstance.getRenderData().getBooleanValue("success")) {
            //当前页面无数据，显示缺省页
            showErrorView(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_PULL_FRESH);
                }
            });
        }
        if ("MainActivity".equalsIgnoreCase(getActivity().getClass().getSimpleName())) {
            //首页一级页面，下拉刷新才会提示
            if (REQUEST_TYPE_PULL_FRESH.equalsIgnoreCase(requestType)) {
                if (errorCode != 429) {
                    ToastUtil.showToast(TextUtils.isEmpty(message)? "服务繁忙，请稍后再试": message);
                } else {
                    ToastUtil.showToast("当前服务访问人数较多，请稍后再试");
                }
            }
        } else {
            //其他页面，正常提示
            if (errorCode != 429) {
                ToastUtil.showToast(TextUtils.isEmpty(message)? "服务繁忙，请稍后再试": message);
            }
        }
        //请求打点
        HashMap<String, String> args = buildErrorParams(mMonitorInfo, "NETWORK_LOAD_FAIL", message);
        IAppMonitorApi appMonitorApi = getAppMonitor();
        if (appMonitorApi != null) {
            appMonitorApi.commitFail(pageName(), "Page_Load_Error", "Page_Load_Error", message, args);
            args.put("interval", diff + "");
            args.put("isLoadSuccess", "N");
            appMonitorApi.commitSuccess(pageName(), "Page_Load_Complete", args);
        }
    }

    private void resetPosition() {
        final RecyclerView recyclerView = mTesseractInstance.getRecyclerView();
        if (recyclerView == null) return;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager == null) return;
        layoutManager.scrollToPosition(0);
    }

    private String parseTitleFromGlobal(JSONObject jsonObject) {
        String title = "";
        if (jsonObject == null) {
            return title;
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (data == null) {
            return title;
        }
        mLastGlobal = data.getJSONObject("global");
        if (mLastGlobal == null) {
            return title;
        }
        return mLastGlobal.getString("title");
    }

    @Subscribe
    public void modifyFieldsData(ModifyDataEvent event) {
        if (mTesseractInstance == null || !TextUtils.equals(pageName(), event.getTag())) {
            return;
        }
        String fieldId = event.getFieldId();
        if (TextUtils.isEmpty(fieldId)) {
            return;
        }
        IDMComponent component = mTesseractInstance.getDataContext().getComponentByName(fieldId);
        if (component == null) {
            return;
        }
        JSONObject componentFields = component.getFields();
        if (componentFields == null) {
            return;
        }
        JSONObject value = event.getValue();
        if (value == null) {
            return;
        }
        componentFields.putAll(value);
        if (event.isRefreshAfterModity()) {
            mTesseractInstance.refresh(2);
        }
    }

    @Subscribe
    public void dealRefreshEvent(CommonEvent event) {
        if (mTesseractInstance == null) return;
        if (SwitchChannelConst.SWITCH_CHANNEL_EVENT.equals(event.getType())) {
            ISwitchChannelService service = ServiceManager.getInstance().getService(ISwitchChannelService.class.getName());
            if (service != null) {
                String changeChannel = String.valueOf(service.getUserChannel());
                if (changeChannel.equalsIgnoreCase(mUserChannel)) {
                    return;
                }
                mUserChannel = changeChannel;
            }
            mSinglePageRequestUrl = replaceUriParameter(mSinglePageRequestUrl, "userChannel", mUserChannel);
            if (fragmentVisible) {
                doRefresh(mSinglePageRequestUrl, SwitchChannelConst.SWITCH_CHANNEL_EVENT);
            } else {
                forceRefreshFromEvent = true;
            }
        } else if (ISiteMidService.SITE_SWITCH_EVENT.equals(event.getType())) {
            forceRefreshFromEvent = true;
            ISiteMidService siteService = ServiceManager.getInstance().getService(ISiteMidService.class.getName());
            if (siteService != null) {
                SiteModel siteModel = siteService.getGlobalSite();
                mSiteId = siteModel.code;
            }
            mSinglePageRequestUrl = replaceUriParameter(mSinglePageRequestUrl, "siteId", mSiteId);
            if (fragmentVisible) {
                doRefresh(mSinglePageRequestUrl, ISiteMidService.SITE_SWITCH_EVENT);
            } else {
                forceRefreshFromEvent = true;
            }
        }
    }

    @Subscribe
    public void dealRefreshEvent(RefreshPageEvent event) {
        if (mTesseractInstance == null || !TextUtils.equals(pageName(), event.tag)) {
            return;
        }
        /*if (ISiteMidService.SITE_SWITCH_EVENT.equals(event.refreshType)) {
            refreshBySiteSwitch(event.params);
        } else */if (REQUEST_TYPE_NORMAL_REFRESH.equals(event.refreshType)) {
            String request = mSinglePageRequestUrl;
            if (event.params != null && !TextUtils.isEmpty(event.params.getString("url"))) {
                request = event.params.getString("url");
            }
            //刷新当前页面，pageId不能变化
            String pageId = mPageId;
            parseParamsFromUrl(request);
            mPageId = pageId;
            if (request.contains("?")) {
                request += "&siteId=" + mSiteId;
            } else {
                request += "?siteId=" + mSiteId;
            }
            doRefresh(request, REQUEST_TYPE_NORMAL_REFRESH);
        }
    }

    /*private void refreshBySiteSwitch(JSONObject params) {
        if (params == null) {
            return;
        }

        String siteId = params.getString("siteId");
        if (TextUtils.isEmpty(siteId)) {
            return;
        }
        mSiteId = siteId;
        mSinglePageRequestUrl = replaceUriParameter(mSinglePageRequestUrl, "siteId", siteId);
        doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_SITE_CHANGE);
    }*/

    protected String replaceUriParameter(String url, String key, String newValue) {
        if (TextUtils.isEmpty(url)) {
            return url;
        }
        Uri uri = Uri.parse(url);
        final Set<String> params = uri.getQueryParameterNames();
        final Uri.Builder newUri = uri.buildUpon().clearQuery();
        for (String param : params) {
            newUri.appendQueryParameter(param,
                    param.equals(key) ? newValue : uri.getQueryParameter(param));
        }

        return newUri.build().toString();
    }

    public void refresh(JSONObject renderData) {
        if (renderData != null) {
            hideErrorView();
            mTesseractInstance.renderData(renderData, new IRequestCallback() {
                @Override
                public void onError(int errorCode, String s, Map<String, ?> map) {}

                @Override
                public void onSuccess(JSONObject jsonObject, Map<String, ?> map) {
                    toggleRefreshLayoutMoreData(!mTesseractInstance.canLoadMore());
                }
            });
        }
    }

    @Override
    public void onLoadMore(RefreshLayout refreshLayout) {
        if (loadMoreListener != null && loadMoreListener.onLoadMore()) {
            return;
        }
        loadMore();
    }

    private void loadMore() {
        if (mEnableLoadMore && mTesseractInstance != null && mTesseractInstance.canLoadMore()) {
            RequestBuilder requestBuilder = new RequestBuilder(mMultiPageRequestUrl);
            requestBuilder.setHeaders(makeHeaders());
            if (mLastGlobal != null) {
                requestBuilder.setBody(new ZWJSONObjectRequestBody(getLoadmoreParams(mSinglePageRequestUrl, mLastGlobal)));
            }
            new Request().execute(requestBuilder.requestPost(), new IRequestCallback() {
                @Override
                public void onError(int errorCode, String s, Map<String, ?> map) {
                    afterLoadMore(mTesseractInstance.canLoadMore());
                }

                @Override
                public void onSuccess(JSONObject jsonObject, Map<String, ?> map) {
                    if (jsonObject != null) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        if (data != null) {
                            mLastGlobal = data.getJSONObject("global");
                        }
                    }
                    mTesseractInstance.loadMore(jsonObject);
                    afterLoadMore(mTesseractInstance.canLoadMore());
                }
            });
        } else {
            afterLoadMore(false);
        }
    }

    private String getLoadmoreParams(String rawUrl, JSONObject globalParams) {
        if (TextUtils.isEmpty(rawUrl) && (globalParams == null || globalParams.isEmpty())) {
            return "";
        }
        JSONObject paramsObj = (JSONObject) JSON.toJSON(getRequestParamters(rawUrl));
        if (paramsObj == null) {
            paramsObj = new JSONObject();
        }
        if (globalParams != null && !globalParams.isEmpty()) {
            paramsObj.put("global", globalParams);
        }
        return paramsObj.toString();
    }

    public void loadMore(JSONObject renderData) {
        if (mEnableLoadMore && mTesseractInstance != null && mTesseractInstance.canLoadMore()) {
            mTesseractInstance.loadMore(renderData);
            afterLoadMore(mTesseractInstance.canLoadMore());
        } else {
            afterLoadMore(false);
        }
    }

    public void setEnableLoadMore(boolean enableLoadMore) {
        mEnableLoadMore = enableLoadMore;
        toggleRefreshLayoutLoadMore(enableLoadMore);
    }

    private void toggleRefreshLayoutPullRefresh(boolean flag) {
        if (mRefreshLayout == null) {
            return;
        }
        if (flag) {
            mRefreshLayout.setOnRefreshListener(this);
            mRefreshLayout.setEnableRefresh(true);
        } else {
            mRefreshLayout.setEnableRefresh(false);
        }
    }

    private void toggleRefreshLayoutLoadMore(boolean canLoadMore) {
        if (mRefreshLayout == null) {
            return;
        }
        if (canLoadMore) {
            mRefreshLayout.setOnLoadMoreListener(this);
            mRefreshLayout.setEnableLoadMore(true);
        } else {
            mRefreshLayout.setEnableLoadMore(false);
        }
    }

    private void toggleRefreshLayoutMoreData(boolean noMoreData) {
        if (mRefreshLayout != null) {
            mRefreshLayout.setNoMoreData(noMoreData);
        }
    }

    public void mgopRequestNeedLogin(boolean flag) {
        this.mMgopRequestNeedLogin = flag;
    }

    public void hideHeaderView(boolean flag) {
        this.mHideHeaderBar = flag;
        if (mHeaderLayout != null) {
            mHeaderLayout.setVisibility(flag ? View.GONE : View.VISIBLE);
        }
    }

    public void setEnablePullRefresh(boolean flag) {
        mEnablePullRefresh = flag;
        toggleRefreshLayoutPullRefresh(flag);
    }

    private void afterLoadMore(boolean canLoadMore) {
        if (mRefreshLayout != null) {
            mRefreshLayout.finishLoadMore();
            toggleRefreshLayoutMoreData(!canLoadMore);
        }
    }

    public void setRefreshListener(IRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }


    public void setLoadMoreListener(ILoadMoreListener loadMoreListener) {
        this.loadMoreListener = loadMoreListener;
    }

    public void setEventSubscriberMap(Map<String, ISubscriber> mEventSubscriber) {
        this.mEventSubscriber = mEventSubscriber;
    }

    public void setPageName(String pageName) {
        this.mPageName = pageName;
    }

    public void setRequestUrl(String requestUrl) {
        parseParamsFromUrl(requestUrl);
        this.mSinglePageRequestUrl = replaceRequestUrlIfNeed(parseAndSetUserChannel(parseAndSetSiteId(requestUrl)));
    }

    private String replaceRequestUrlIfNeed(String rawUrl) {
        if (TextUtils.isEmpty(rawUrl)) {
            return "";
        }
        Uri uri = Uri.parse(rawUrl);
        String replaceUrl = getQueryParamterOrDefault(uri, Constants.REPLACE_REQUEST_URL, "");
        if (TextUtils.isEmpty(replaceUrl)) {
            return rawUrl;
        }
        List<String> keys = new ArrayList<>();
        keys.add("_tesseract_url_");
        return UrlParserUtils.copyParameters(rawUrl, replaceUrl, keys);
    }

    public void enableCache() {
        this.mPageCache = new PageCache();
    }

    public class LoginStateChangeReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            switch (action) {
                case ILoginService.GOV_LOGIN_BROADCAST_ACTION:
                    if (mEnableLoginReceive) {
                        if (fragmentVisible) {
                            doRefresh(mSinglePageRequestUrl, REQUEST_TYPE_LOGIN);
                        } else {
                            forceRefreshFromEvent = true;
                        }
                    }
                    break;
                case ILoginService.GOV_LOGOUT_BROADCAST_ACTION:
                    if (mPageCache != null) {
                        mPageCache.cleanCache(getContext(), pageName());
                    }
                    refreshByLogout();
                    break;
            }
        }

    }

    private HashMap<String, String> buildErrorParams(@NonNull Map<String, String> commonParams, @NonNull String errorCode, String errorMessage) {
        HashMap<String, String> map = new HashMap<>(commonParams);
        map.put("ErrorCode", errorCode);
        if (!TextUtils.isEmpty(errorMessage)) {
            map.put("ErrorMessage", errorMessage);
        }
        return map;
    }

    private IUserOperationApi getUserMonitor() {
        IZWMonitor monitor = ServiceManager.getInstance().getService(IZWMonitor.class.getName());
        if (monitor == null) {
            return null;
        }
        return monitor.getUserOperationApi();
    }

    private IAppMonitorApi getAppMonitor() {
        IZWMonitor monitor = ServiceManager.getInstance().getService(IZWMonitor.class.getName());
        if (monitor == null) {
            return null;
        }
        return monitor.getAppMonitorApi();
    }

//    private boolean canDealTokenInvaliad() {
//        return SharedPreferencesUtil.getBoolean("tesseract_deal_token_invaliad", false);
//    }

//    private void toggleDealTokenInvaliad(boolean flag) {
//        SharedPreferencesUtil.putBoolean("tesseract_deal_token_invaliad", flag);
//    }

    private Map<String, String> getRequestParamters(String rawUrl) {
        Map<String, String> map = new HashMap<>();
        Uri rawUri = Uri.parse(rawUrl);
        if (rawUri == null) {
            return map;
        }
        Set<String> paramKeys = rawUri.getQueryParameterNames();
        if (paramKeys == null || paramKeys.isEmpty()) {
            return map;
        }
        Iterator<String> iterator = paramKeys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (TextUtils.equals(key, "")) {
                continue;
            }
            map.put(key, rawUri.getQueryParameter(key));
        }
        return map;
    }

    protected void refreshByLogout() {}

}
