package com.alibaba.tesseract.page.activity;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;

import com.alibaba.gov.android.api.location.ILocationService;
import com.alibaba.gov.android.common.config.AppConfig;
import com.alibaba.gov.android.foundation.base.activity.BaseActivity;
import com.alibaba.gov.android.foundation.utils.SharedPreferencesUtil;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;
import com.alibaba.gov.android.tesseract.page.R;
import com.alibaba.tesseract.page.inter.ITesseractFragment;
import com.alibaba.tesseract.page.inter.ITesseractPage;
import com.alibaba.tesseract.page.utils.UrlParserUtils;

import java.util.ArrayList;
import java.util.List;

import static com.alibaba.tesseract.page.activity.Constants.SINGLE_PAGE_REQUEST_API;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

/**
 * Created by yiwei on 2020-04-09.
 */
public class TesseractActivity extends BaseActivity {
    private Fragment mFragment;
    private String mRequestUrl;
    private String mUserChannel = null;
    private String mBgColor;

    @Override
    public void initViews() {
        hideTitleBar();
        instanceFragment();
    }

    @Override
    protected int getLayoutResId() {
        return R.layout.common_tesseract_page_layout;
    }

    @Override
    protected void findViews() {
    }

    @Override
    protected void initData(Intent intent) {
        if (intent == null) {
            return;
        }
        Uri rawUrl = intent.getData();
        if (rawUrl == null) {
            return;
        }
        mUserChannel = rawUrl.getQueryParameter("userChannel");
        mBgColor = rawUrl.getQueryParameter("background");
        mRequestUrl = copyParameterToTargetUrl(rawUrl.toString(), AppConfig.getString("baseHost") + SINGLE_PAGE_REQUEST_API);
        //todo 经纬度,需要@寒潇提供经纬度获取接口
        ILocationService locationService = ServiceManager.getInstance().getService(ILocationService.class.getName());
        String latitude = "0".equals(locationService.getLatLon().first) ? "30.228324" : locationService.getLatLon().first;
        String longitude = "0".equals(locationService.getLatLon().second) ? "120.040458" : locationService.getLatLon().second;
        mRequestUrl += "&longitude=" + longitude + "&latitude=" + latitude + "&" + Constants.REFRESH_COLOR + "=false";
    }

    protected void instanceFragment() {
        FragmentManager manager = this.getSupportFragmentManager();
        FragmentTransaction transaction = manager.beginTransaction();
        if (mFragment == null) {
            ITesseractPage iTesseractPage = ServiceManager.getInstance().getService(ITesseractPage.class.getName());
            if (iTesseractPage == null) {
                return;
            }
            ITesseractFragment iTesseractFragment = iTesseractPage.getFragmentManager();
            if (iTesseractFragment == null) {
                return;
            }
            if (!TextUtils.isEmpty(mBgColor)) {
                if (mBgColor.startsWith("#")) {
                    iTesseractFragment.setPageBackgroundCorlor(mBgColor);
                } else {
                    iTesseractFragment.setPageBackgroundCorlor("#" + mBgColor);
                }
            }
            mFragment = iTesseractFragment.createFragment("", mRequestUrl);
            //api切换mgop开关
//            if (TextUtils.isEmpty(mReplaceRequestUrl)) {
//                mRequestUrl += "&" + MGOP_REQUEST + "=true";
//            }
        }
        transaction.add(R.id.common_tesseract_body, mFragment);
        transaction.commitAllowingStateLoss();
    }

    private String copyParameterToTargetUrl(String rawUrl, String targetUrl) {
        List<String> keys = new ArrayList<>();
        keys.add("_tesseract_");
        return UrlParserUtils.copyParameters(rawUrl, targetUrl, keys);
    }

}
