package com.alibaba.tesseract.page.events;

import android.text.TextUtils;
import android.view.View;

import com.alibaba.android.tesseract.core.event.TesseractBaseSubscriber;
import com.alibaba.android.tesseract.core.event.base.TesseractEvent;
import com.alibaba.android.tesseract.core.event.base.TesseractEventHandler;
import com.alibaba.android.tesseract.sdk.common.model.IDMComponent;
import com.alibaba.android.tesseract.sdk.common.model.IDMEvent;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.foundation.event.CommonEvent;
import com.alibaba.gov.android.foundation.utils.SharedPreferencesUtil;
import com.alibaba.tesseract.page.events.site.SiteSwitchHelper;

import org.greenrobot.eventbus.EventBus;


public class ClickCloseEventSubscriber extends TesseractBaseSubscriber {
    public static final String EVENT_TAG = "close_auth_tip_event";//dx里配置clickClose

    @Override
    protected void onHandleEvent(final TesseractEvent tesseractEvent) {
        if (tesseractEvent == null || tesseractEvent.getContext() == null) {
            return;
        }
        IDMComponent component = tesseractEvent.getComponent();
        if (component == null) return;
        JSONObject data = component.getData();
        if (data == null) return;
        String pageModuleId = data.getString("pageModuleId");
        if (TextUtils.isEmpty(pageModuleId)) return;
        SharedPreferencesUtil.putBoolean("CheckVisible_" + pageModuleId, false);
        mInstance.refreshCurrentContainer();
    }

}
