package com.alibaba.tesseract.page.events;

import android.util.Log;

import com.alibaba.android.tesseract.core.utils.MonitorUtils;
import com.alibaba.fastjson.JSONObject;
import com.taobao.android.dinamicx.DXAbsEventHandler;
import com.taobao.android.dinamicx.DXRuntimeContext;
import com.taobao.android.dinamicx.expression.event.DXEvent;

import org.greenrobot.eventbus.EventBus;

import java.util.Map;

public class DXPropsEventHandler extends DXAbsEventHandler {
    public static final long DX_EVENT_PROPS = 19050261079641L;

    /**
     * 提供绑定事件前对View进行特殊操作的时机 (需要时实现)
     *
     * @param args           方法传入的参数列表，如果参数解析为空，传入null占位
     * @param runtimeContext 运行时上下文，包括组件信息，数据等。
     *                       如果解析时发生错误, error属性包含该错误信息
     */
    @Override
    public void prepareBindEventWithArgs(Object[] args, DXRuntimeContext runtimeContext) {
        super.prepareBindEventWithArgs(args, runtimeContext);
    }

    /**
     * @param args           方法传入的参数列表，如果没有则为null
     * @param runtimeContext 整个运行过程中的上下文
     */
    @Override
    public void handleEvent(DXEvent event, Object[] args, DXRuntimeContext runtimeContext) {
        if (event == null
                || runtimeContext == null) {
            return;
        }
        JSONObject dataFields = runtimeContext.getData();
        if (dataFields == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            String fieldId;
            if (args != null && args.length == 2) {
                fieldId = dataFields.getString("id");
                JSONObject innerObject = new JSONObject();
                innerObject.put(String.valueOf(args[0]), args[1]);
                jsonObject.put("value", innerObject);
                if (runtimeContext.getSubData() != null && runtimeContext.getSubData() instanceof JSONObject) {
                    //index切换埋点
                    JSONObject data = runtimeContext.getData();
                    if (data != null) {
                        String arg1 = data.getString("type") + "_" + data.getString("id") + "_dxProps";
                        JSONObject traceArgs = new JSONObject();
                        JSONObject subdata = (JSONObject) runtimeContext.getSubData();
                        for (Map.Entry<String, Object> entry : subdata.entrySet()) {
                            if (entry.getKey().equals("_ext_") && entry.getValue() instanceof JSONObject) {
                                JSONObject ext = (JSONObject) entry.getValue();
                                for (Map.Entry<String, Object> extEntry : ext.entrySet()) {
                                    traceArgs.put(extEntry.getKey(), String.valueOf(extEntry.getValue()));
                                }
                            } else {
                                traceArgs.put(entry.getKey(), String.valueOf(entry.getValue()));
                            }
                        }
                        String cardId = data.getString("pageModuleId") + ":" + data.getString("componentId") + ":" + traceArgs.getString("_resourceId_");
                        String cardName = data.getString("pageModuleName");
                        traceArgs.put("cardId", cardId);
                        traceArgs.put("cardName", cardName);
                        traceArgs.put("index", runtimeContext.getSubdataIndex());
                        ZWOpenUrlEventHandler.parseArgs(traceArgs);
                        MonitorUtils.traceClickEvent(runtimeContext.getBizType(), arg1, traceArgs);
                    }
                }
            } else {
                JSONObject fieldJSON = dataFields.getJSONObject("fields");
                fieldId = fieldJSON.getString("fieldId");
                if (fieldJSON.getBooleanValue("readonly")) {
                    return;
                }
                jsonObject.put("value", ((DXOnFinishEvent) event).getValue());
            }
            ModifyDataEvent modifyDataEvent = new ModifyDataEvent(runtimeContext.getBizType(), fieldId, jsonObject);
            modifyDataEvent.setRefreshAfterModity(true);
            EventBus.getDefault().post(modifyDataEvent);
        } catch (Exception e) {
            Log.e("DXPropsEventHandler", e.getMessage());
        }
    }
}
