package com.alibaba.tesseract.page.events;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesseract.page.utils.RVHeightUtils;
import com.taobao.android.dinamicx.DXAbsEventHandler;
import com.taobao.android.dinamicx.DXRuntimeContext;
import com.taobao.android.dinamicx.expression.event.DXEvent;
import com.taobao.android.dinamicx.expression.event.DXScrollEvent;

import org.greenrobot.eventbus.EventBus;

public class DXZwScrollEndEventHandler extends DXAbsEventHandler {
    public static final long DX_EVENT_ZWSCROLLEND = -5375628462722740094L;

    /**
     * 提供绑定事件前对View进行特殊操作的时机 (需要时实现)
     *
     * @param args           方法传入的参数列表，如果参数解析为空，传入null占位
     * @param runtimeContext 运行时上下文，包括组件信息，数据等。
     *                       如果解析时发生错误, error属性包含该错误信息
     */
    @Override
    public void prepareBindEventWithArgs(Object[] args, DXRuntimeContext runtimeContext) {
        super.prepareBindEventWithArgs(args, runtimeContext);
    }

    /**
     * @param args           方法传入的参数列表，如果没有则为null
     * @param runtimeContext 整个运行过程中的上下文
     */
    @Override
    public void handleEvent(DXEvent event, Object[] args, DXRuntimeContext runtimeContext) {
        if (event instanceof DXScrollEvent) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("offset", RVHeightUtils.px2dip(runtimeContext.getContext(), ((DXScrollEvent) event).getOffsetY()) + "np");
            ModifyDataEvent modifyDataEvent = new ModifyDataEvent(runtimeContext.getBizType(), runtimeContext.getData().getString("id"), jsonObject);
            modifyDataEvent.setRefreshAfterModity(false);
            EventBus.getDefault().post(modifyDataEvent);
        }
    }
}
