package com.alibaba.tesseract.page.events;

import android.text.TextUtils;

import com.alibaba.android.tesseract.core.event.TesseractBaseSubscriber;
import com.alibaba.android.tesseract.core.event.base.TesseractEvent;
import com.alibaba.android.tesseract.sdk.common.model.IDMComponent;
import com.alibaba.android.tesseract.sdk.datamodel.imp.DMEvent;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.messagecenter.IEGMessageCenterService;
import com.alibaba.gov.android.api.router.IRouterService;
import com.alibaba.gov.android.foundation.env.EnvUtil;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;


public class MsgOpenAndReadEventSubscriber extends TesseractBaseSubscriber {
    public static final String EVENT_TAG = "click_msg_read_event";//dx里配置clickClose

    @Override
    protected void onHandleEvent(final TesseractEvent tesseractEvent) {
        if (tesseractEvent == null || tesseractEvent.getContext() == null || tesseractEvent.getEventParams() == null) {
            return;
        }
        DMEvent event = tesseractEvent.getEventParams();
        JSONObject eventFields = event.getFields();
        if (eventFields == null) {
            return;
        }
        String url = eventFields.getString("url");
        String msgId = eventFields.getString("msgId");
        IRouterService routerService = ServiceManager.getInstance().getService(IRouterService.class.getName());
        if (null != routerService) {
            if (!TextUtils.isEmpty(url)) {
                routerService.goToUri(tesseractEvent.getContext(), url);
            } else {
                //有些消息没有独立页面，跳通用落地页
                String msgUrl;
                if (EnvUtil.isRelease()) {
                    msgUrl = "https://portal.zjzwfw.gov.cn/h5/portal/usercenter/newsDetail?messageId=" + msgId;
                } else {
                    msgUrl = "https://pre-portal.zjzwfw.gov.cn/h5/portal/usercenter/newsDetail?messageId=" + msgId;
                }
                routerService.goToUri(tesseractEvent.getContext(), msgUrl);
            }
        }
        IEGMessageCenterService msgService = ServiceManager.getInstance().getService(IEGMessageCenterService.class.getName());
        if (!TextUtils.isEmpty(msgId)) {
            //消息置为已读
            msgService.setMsgRead(msgId);
        }
    }

}
