package com.alibaba.tesseract.page.events;


import com.alibaba.android.tesseract.container.vfw.core.ViewEngine;
import com.alibaba.android.tesseract.container.vfw.event.OnDynamicEventListener;
import com.alibaba.android.tesseract.core.event.base.TesseractEvent;
import com.alibaba.android.tesseract.core.event.base.TesseractEventHandler;
import com.alibaba.android.tesseract.sdk.datamodel.imp.DMEvent;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.router.IRouterService;
import com.alibaba.gov.android.foundation.event.CommonEvent;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;
import com.taobao.android.dinamicx.DXRuntimeContext;
import com.taobao.android.dinamicx.IDXEventHandler;
import com.taobao.android.dinamicx.expression.event.DXEvent;
import com.taobao.android.dinamicx.template.utils.DXHashUtil;

import java.util.Iterator;
import java.util.Map;

import static com.alibaba.android.tesseract.core.event.base.BaseEventType.EVENT_TYPE_USER_TRACK;

import android.os.Bundle;

import org.greenrobot.eventbus.EventBus;


/**
 * Created by yiwei on 2019-12-17.
 */
public class ZWOpenUrlEventHandler implements IDXEventHandler {
    public static final long TAG_ID = DXHashUtil.hash("dxZWOpenUrl");

    @Override
    public void handleEvent(DXEvent event, Object[] args, DXRuntimeContext runtimeContext) {
        if (args == null
                || args.length == 0
                || runtimeContext == null
                || runtimeContext.getContext() == null) {
            return;
        }
        postHiddenEvent();
        postTrackEvent(runtimeContext, args);
        IRouterService routerService = ServiceManager.getInstance().getService(IRouterService.class.getName());
        if (null != routerService) {
            Bundle bundle = new Bundle();
            bundle.putString("iconApp", getAppIcon(runtimeContext));
            Object subData = runtimeContext.getSubData();
            if (subData != null && subData instanceof JSONObject) {
                bundle.putString("data", ((JSONObject)subData).toJSONString());
            }
            routerService.goToUri(runtimeContext.getContext(), args[0].toString(), bundle);
        }
    }

    private String getAppIcon(DXRuntimeContext context) {
        String icon = "";
        try {
            JSONObject subData = (JSONObject) context.getSubData();
            icon = subData.getString("icon");
        } catch (Throwable e) {}
        return icon;
    }

    private void postHiddenEvent() {
        CommonEvent event = new CommonEvent("HiddenRobot", null);
        EventBus.getDefault().post(event);
    }

    private void postTrackEvent(DXRuntimeContext runtimeContext, Object[] args) {
        Object dinamicContext = runtimeContext.getDxUserContext();
        if (!(dinamicContext instanceof Map)) {
            return;
        }
        ViewEngine engine = (ViewEngine) ((Map) dinamicContext).get(ViewEngine.KEY_VIEW_ENGINE);
        if (engine == null) {
            return;
        }
        OnDynamicEventListener eventHandler = engine.getService(OnDynamicEventListener.class);
        if (eventHandler == null || !(eventHandler instanceof TesseractEventHandler)) {
            return;
        }
        TesseractEvent tesseractEvent = ((TesseractEventHandler) eventHandler).buildTesseractEvent()
                .setEventType(EVENT_TYPE_USER_TRACK);
        DMEvent event = makeUserTrackEvent(runtimeContext, args);
        if (event == null) {
            return;
        }
        tesseractEvent.setEventParams(event);
        ((TesseractEventHandler) eventHandler).dispatchEvent(tesseractEvent);
    }

    private DMEvent makeUserTrackEvent(DXRuntimeContext runtimeContext, Object[] eventArgs) {
        String area = "dxZWOpenUrl", index = "0";
        index = Integer.toString(runtimeContext.getSubdataIndex());
        if (eventArgs.length == 3) {
            if (eventArgs[1] != null) {
                area = eventArgs[1].toString();
            }
            if (eventArgs[2] != null) {
                index = eventArgs[2].toString();
            }
        }
        JSONObject data = runtimeContext.getData();
        if (data == null || data.isEmpty()) {
            return null;
        }
        String arg1 = data.getString("type") + "_" + data.getString("id") + "_" + area;
        JSONObject eventFields = new JSONObject();
        eventFields.put("eventId", "2101");
        eventFields.put("arg1", arg1);
        JSONObject args = new JSONObject();
        if (runtimeContext.getSubData() == null) {
            //说明是非列表
            if (data != null && data.getJSONObject("fields") != null) {
                JSONObject fields = data.getJSONObject("fields");
                for (Map.Entry<String, Object> entry : fields.entrySet()) {
                    if (entry.getKey().equals("_ext_") && entry.getValue() instanceof JSONObject) {
                        JSONObject ext = (JSONObject) entry.getValue();
                        for (Map.Entry<String, Object> extEntry : ext.entrySet()) {
                            args.put(extEntry.getKey(), String.valueOf(extEntry.getValue()));
                        }
                    } else {
                        args.put(entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                //args = (JSONObject) data.getJSONObject("fields").clone();
            }
        } else if (runtimeContext.getSubData() instanceof JSONObject){
            //说明是列表里的item数据
            JSONObject subdata = (JSONObject) runtimeContext.getSubData();
            for (Map.Entry<String, Object> entry : subdata.entrySet()) {
                if (entry.getKey().equals("_ext_") && entry.getValue() instanceof JSONObject) {
                    JSONObject ext = (JSONObject) entry.getValue();
                    for (Map.Entry<String, Object> extEntry : ext.entrySet()) {
                        args.put(extEntry.getKey(), String.valueOf(extEntry.getValue()));
                    }
                } else {
                    args.put(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
        }
        //cardId cardName index itemId itemTitle
        String cardId = data.getString("pageModuleId") + ":" + data.getString("componentId") + ":" + args.getString("_resourceId_");
        String cardName = data.getString("pageModuleName");
        args.put("cardId", cardId);
        args.put("cardName", cardName);
        parseArgs(args);

        args.put("index", index);
        eventFields.put("args", args);
        return new DMEvent(EVENT_TYPE_USER_TRACK, eventFields, null);
    }

    @Override
    public void prepareBindEventWithArgs(Object[] args, DXRuntimeContext runtimeContext) {

    }

    public static void parseArgs(JSONObject args) {
        if (args != null) {
            if (args.getString("serviceId") != null && args.getString("itemId") == null) {
                args.put("itemId", args.getString("serviceId"));
            }
            if (args.getString("name") != null) {
                args.put("itemTitle", args.getString("name"));
            }
            if (args.getString("content") != null) {
                args.put("itemTitle", args.getString("content"));
            }
            if (args.getString("text") != null) {
                args.put("itemTitle", args.getString("text"));
            }
            if (args.getString("title") != null) {
                args.put("itemTitle", args.getString("title"));
            }
            if (args.getString("link") != null) {
                args.put("visiturl", args.getString("link"));
            }
            if (args.getString("url") != null) {
                args.put("visiturl", args.getString("url"));
            }
        }
    }
}
