package com.alibaba.tesseract.page.events.site;

import android.text.TextUtils;

import com.alibaba.android.tesseract.core.event.TesseractBaseSubscriber;
import com.alibaba.android.tesseract.core.event.base.TesseractEvent;
import com.alibaba.android.tesseract.core.event.base.TesseractEventHandler;
import com.alibaba.android.tesseract.sdk.common.model.IDMEvent;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.site.ISiteMidService;
import com.alibaba.gov.android.api.site.SiteModel;
import com.alibaba.gov.android.api.site.SiteSelectionCallback;
import com.alibaba.gov.android.foundation.event.CommonEvent;

import org.greenrobot.eventbus.EventBus;

/**
 * Created by yiwei on 2020-07-10.
 */
public class SiteSwitchEventSubscriber extends TesseractBaseSubscriber {
    public static final String EVENT_TAG = "switchSite";

    @Override
    protected void onHandleEvent(final TesseractEvent tesseractEvent) {
        if (tesseractEvent == null || tesseractEvent.getContext() == null) {
            return;
        }
        IDMEvent idmEvent = this.getIDMEvent();
        if (idmEvent == null) {
            return;
        }
        JSONObject fields = idmEvent.getFields();
        if (fields == null) {
            return;
        }
        postHiddenEvent();
        boolean hideProvince = false;
        String siteAdCode = fields.getString("siteId");
        try {
            Object data = tesseractEvent.getExtraData(TesseractEventHandler.KEY_EXTRA_PARAMS);
            if (data != null && data instanceof Object[] && ((Object[]) data).length > 0) {
                hideProvince = Boolean.parseBoolean(((Object[]) data)[1].toString());
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }

        new SiteSwitchHelper(mContext, siteAdCode, 0, hideProvince).startSiteMidBySearchResult(null);
    }

    private void postHiddenEvent() {
        CommonEvent event = new CommonEvent("HiddenRobot", null);
        EventBus.getDefault().post(event);
    }
}
