package com.alibaba.tesseract.page.events.site;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;

import com.alibaba.android.tesseract.core.utils.LogUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.network.IZWHttpService;
import com.alibaba.gov.android.api.network.ZWBaseApi;
import com.alibaba.gov.android.api.network.request.ZWRequest;
import com.alibaba.gov.android.api.network.response.ZWResponse;
import com.alibaba.gov.android.api.site.ISiteMidService;
import com.alibaba.gov.android.api.site.SiteAPI;
import com.alibaba.gov.android.api.site.SiteModel;
import com.alibaba.gov.android.api.site.SiteSelectionCallback;
import com.alibaba.gov.android.foundation.utils.ToastUtil;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;

/**
 * Created by yiwei on 2021/4/1.
 */
public class SiteSwitchHelper {
    private Context mContext;
    private ISiteMidService siteMidService;
    private String selectCode;
    private int flag;
    private boolean hideProvince;

    public SiteSwitchHelper(Context context, String selectCode, int flag, boolean hideProvince) {
        this.mContext = context;
        this.siteMidService = ServiceManager.getInstance().getService(ISiteMidService.class.getName());
        if (TextUtils.isEmpty(selectCode)) {
            this.selectCode = siteMidService.getGlobalSite().adCode;
        } else {
            this.selectCode = selectCode;
        }
        this.flag = flag;
        this.hideProvince = hideProvince;
    }

    public void startSiteMidBySearchResult(SiteSelectionCallback callback) {
        Map traceArgs = new HashMap();
        traceArgs.put("from", "Page_Tesseract");
        JSONObject params = new JSONObject();
        params.put("initial_city_code", selectCode);
        params.put("hide_province", this.hideProvince);
        if (hideProvince) {
            params.put("flag", ISiteMidService.FLAG_DISABLE_HISTORY_VIEW);
            params.put("from", "city");
        }
        this.siteMidService.show(mContext, null, params, callback);
    }

}
