package com.alibaba.tesseract.page.events.switchchannel;

import android.view.View;

import com.alibaba.android.tesseract.core.event.TesseractBaseSubscriber;
import com.alibaba.android.tesseract.core.event.base.TesseractEvent;
import com.alibaba.android.tesseract.sdk.common.model.IDMEvent;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.switchchannel.ISwitchChannelService;
import com.alibaba.gov.android.foundation.event.CommonEvent;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;

import org.greenrobot.eventbus.EventBus;

public class ChannelSwitchEventSubscriber extends TesseractBaseSubscriber {
    public static final String EVENT_TAG = "switchChannel";

    @Override
    protected void onHandleEvent(final TesseractEvent tesseractEvent) {
        if (tesseractEvent == null || tesseractEvent.getContext() == null) {
            return;
        }
        IDMEvent idmEvent = this.getIDMEvent();
        if (idmEvent == null) {
            return;
        }
        View selectedView = tesseractEvent.getExtraData("triggerView");
        if (selectedView == null) return;
        JSONObject fields = idmEvent.getFields();
        if (fields == null) {
            return;
        }
        postHiddenEvent();
        ISwitchChannelService service = ServiceManager.getInstance().getService(ISwitchChannelService.class.getName());
        if (service != null) {
            service.start(tesseractEvent.getContext(), selectedView);
        }
    }

    private void postHiddenEvent() {
        CommonEvent event = new CommonEvent("HiddenRobot", null);
        EventBus.getDefault().post(event);
    }

}
