package com.alibaba.tesseract.page.inter;


import androidx.annotation.NonNull;

import com.alibaba.android.tesseract.core.event.base.ISubscriber;
import com.taobao.android.dinamicx.IDXEventHandler;
import com.taobao.android.dinamicx.expression.parser.IDXDataParser;
import com.taobao.android.dinamicx.widget.IDXBuilderWidgetNode;

/**
 * Created by yiwei on 2021/6/10.
 *
 */
public interface ITesseractExpand {

    /**
     * app所有tesseract页面共享
     * @param id
     * @param widgetNode
     */
    void registerGlobalDXView(long id, @NonNull IDXBuilderWidgetNode widgetNode);

    /**
     * app所有tesseract页面共享
     * @param id
     * @param eventHandler
     */
    void registerGlobalDXEventHandler(long id, @NonNull IDXEventHandler eventHandler);


    void registerGlobalDXEventSubscriber(@NonNull String name, @NonNull ISubscriber event);
    /**
     * app所有tesseract页面共享
     * @param id
     * @param parser
     */
    void registerGlobalDXParser(long id, @NonNull IDXDataParser parser);

}
