package com.alibaba.tesseract.page.inter;

import android.view.View;

import androidx.fragment.app.Fragment;

import com.alibaba.android.tesseract.core.event.base.ISubscriber;
import com.alibaba.fastjson.JSONObject;
import com.taobao.android.dinamicx.widget.IDXBuilderWidgetNode;

import java.util.Map;

/**
 * Created by yiwei on 2020-10-02.
 */
public interface ITesseractFragment {

    /**
     * 创建 tesseract fragment实例
     *
     * @param pageName   页面名称
     * @param requestUrl 数据请求接口
     * @return
     */
    Fragment createFragment(String pageName, String requestUrl);

    /**
     * 创建 tesseract fragment实例
     *
     * @param pageName   页面名称
     * @param requestUrl 数据请求接口
     * @param headerView 页头View
     * @return
     */
    Fragment createFragment(String pageName, String requestUrl, View headerView);

    /**
     * 创建 tesseract fragment实例
     *
     * @param pageName   页面名称
     * @param requestUrl 数据请求接口
     * @param headerView 页头View，传NUL即隐藏页头
     * @param bottomView 底部悬浮View
     * @return
     */
    Fragment createFragment(String pageName, String requestUrl, View headerView, View bottomView);


    void refresh();

    void refresh(JSONObject data);

    void loadMore(JSONObject data);

    void registerLoadMoreListener(ILoadMoreListener ILoadMoreListener);

    void registerRefreshListener(IRefreshListener refreshListener);

    void setEnablePullRefresh(boolean flag);

    void setEnableLoadMore(boolean flag);

    void setRequestHeader(Map<String, String> requestHeader);

    void setEventSubscriberMap(Map<String, ISubscriber> mEventSubscriber);

    void hideHeaderView(boolean flag);

    void registerLifecycle(ILifecycleCallback lifecycle);

    void enablePageCache();

    void mgopRequestNeedLogin(boolean flag);

    void setMultiPageRequestApi(String requestUrl);

    void setPageBackgroundCorlor(String color);
}
