package com.alibaba.tesseract.page.manager;


import android.util.Pair;

import com.alibaba.android.tesseract.core.event.base.ISubscriber;
import com.alibaba.android.tesseract.core.event.base.TesseractEventHandler;
import com.alibaba.android.tesseract.core.instance.ITesseractInstance;
import com.alibaba.gov.android.api.dxmap.IDxMapViewService;
import com.alibaba.gov.android.api.video.IVideoPlayService;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;
import com.alibaba.tesseract.page.events.ClickCloseEventSubscriber;
import com.alibaba.tesseract.page.events.DXDxZWCountDownFinishEventHandler;
import com.alibaba.tesseract.page.events.DXPropsEventHandler;
import com.alibaba.tesseract.page.events.DXRefreshEventHandler;
import com.alibaba.tesseract.page.events.DXZWInputOnChangeEventHandler;
import com.alibaba.tesseract.page.events.DXZwScrollEndEventHandler;
import com.alibaba.tesseract.page.events.MsgOpenAndReadEventSubscriber;
import com.alibaba.tesseract.page.events.site.SiteSwitchEventSubscriber;
import com.alibaba.tesseract.page.events.ZWOpenUrlEventHandler;
import com.alibaba.tesseract.page.events.switchchannel.ChannelSwitchEventSubscriber;
import com.alibaba.tesseract.page.parsers.DXDataParserZwCheckVisible;
import com.alibaba.tesseract.page.parsers.DXDataParserZwContainerHeight;
import com.alibaba.tesseract.page.view.DXMarqueeTextViewWidgetNode;
import com.alibaba.tesseract.page.view.DXZWCountDownViewWidgetNode;
import com.alibaba.tesseract.page.view.DXZWLottieViewWidgetNode;
import com.alibaba.tesseract.page.view.DXZWSlideScaleViewWidgetNode;
import com.alibaba.tesseract.page.view.DXZWTextViewWidgetNode;
import com.taobao.android.dinamicx.IDXEventHandler;
import com.taobao.android.dinamicx.expression.parser.IDXDataParser;
import com.taobao.android.dinamicx.widget.IDXBuilderWidgetNode;
import java.util.Map;
import java.util.Set;


/**
 * Created by yiwei on 2020-10-02.
 */
public class BaseSubscribeUtil {

    /**
     * 注册默认机制，优先级为，页面实例注册的 > 全局注册的 > 容器默认的
     * @param tesseractInstance
     * @param eventSubscriber
     */
    public static void initSubsriber(ITesseractInstance tesseractInstance, Map<String, ISubscriber> eventSubscriber) {
        if (tesseractInstance == null) {
            return;
        }
        IVideoPlayService playService = ServiceManager.getInstance().getService(IVideoPlayService.class.getName());
        //默认parser
        tesseractInstance.registDXDataParser(DXDataParserZwContainerHeight.DX_PARSER_ZWCONTAINERHEIGHT, new DXDataParserZwContainerHeight());
        tesseractInstance.registDXDataParser(DXDataParserZwCheckVisible.DX_PARSER_ZWCHECKVISIBLE, new DXDataParserZwCheckVisible());
        //默认event handler
        tesseractInstance.registDXEventHanlder(DXZwScrollEndEventHandler.DX_EVENT_ZWSCROLLEND, new DXZwScrollEndEventHandler());
        tesseractInstance.registDXEventHanlder(DXPropsEventHandler.DX_EVENT_PROPS, new DXPropsEventHandler());
        tesseractInstance.registDXEventHanlder(ZWOpenUrlEventHandler.TAG_ID, new ZWOpenUrlEventHandler());
        tesseractInstance.registDXEventHanlder(DXZWInputOnChangeEventHandler.DX_EVENT_ZWINPUTONCHANGE, new DXZWInputOnChangeEventHandler());
        tesseractInstance.registDXEventHanlder(DXDxZWCountDownFinishEventHandler.DX_EVENT_DXZWCOUNTDOWNFINISH, new DXDxZWCountDownFinishEventHandler());
        tesseractInstance.registDXEventHanlder(DXRefreshEventHandler.DX_EVENT_REFRESH, new DXRefreshEventHandler());
        //默认view
        tesseractInstance.registDXView(DXZWCountDownViewWidgetNode.DXZWCOUNTDOWNVIEW_ZWCOUNTDOWNVIEW, new DXZWCountDownViewWidgetNode());
        tesseractInstance.registDXView(DXZWSlideScaleViewWidgetNode.DXZWSLIDESCALEVIEW_ZWSLIDESCALEVIEW, new DXZWSlideScaleViewWidgetNode());
        tesseractInstance.registDXView(DXZWLottieViewWidgetNode.DXZWLOTTIEVIEW_ZWLOTTIEVIEW, new DXZWLottieViewWidgetNode());
        tesseractInstance.registDXView(DXZWTextViewWidgetNode.DXZWTEXTVIEW_ZWTEXTVIEW, new DXZWTextViewWidgetNode.Builder());
        tesseractInstance.registDXView(DXMarqueeTextViewWidgetNode.DXMARQUEETEXTVIEW_MARQUEETEXTVIEW, new DXMarqueeTextViewWidgetNode.Builder());
        if (playService != null) {
            Pair<Long, IDXBuilderWidgetNode> zwVideoWidgetNode = playService.getZWVideoWidgetNode();
            tesseractInstance.registDXView(zwVideoWidgetNode.first, zwVideoWidgetNode.second);
            Pair<Long, IDXBuilderWidgetNode> hVideoWidgetNode = playService.getHVideoWidgetNode();
            tesseractInstance.registDXView(hVideoWidgetNode.first, hVideoWidgetNode.second);
        }
        IDxMapViewService mapService = ServiceManager.getInstance().getService(IDxMapViewService.class.getName());
        if (mapService != null) {
            Pair<Long, IDXBuilderWidgetNode> mapWidgetNode = mapService.getDxMapWidgetNode();
            tesseractInstance.registDXView(mapWidgetNode.first, mapWidgetNode.second);
        }
        //默认Subscriber
        TesseractEventHandler tesseractEventHandler = tesseractInstance.getEventHandler();
        if (tesseractEventHandler != null) {
            tesseractEventHandler.addSubscriber(SiteSwitchEventSubscriber.EVENT_TAG, new SiteSwitchEventSubscriber());
            tesseractEventHandler.addSubscriber(ChannelSwitchEventSubscriber.EVENT_TAG, new ChannelSwitchEventSubscriber());
            tesseractEventHandler.addSubscriber(ClickCloseEventSubscriber.EVENT_TAG, new ClickCloseEventSubscriber());
            tesseractEventHandler.addSubscriber(MsgOpenAndReadEventSubscriber.EVENT_TAG, new MsgOpenAndReadEventSubscriber());
        }
        //全局注册的
        loadGlobal(tesseractInstance, tesseractEventHandler);

        //页面实例注册的Subscriber
        if (tesseractEventHandler != null && eventSubscriber != null && eventSubscriber.size() > 0) {
            tesseractEventHandler.addSubscribers(eventSubscriber);
        }
    }

    private static void loadGlobal(ITesseractInstance tesseractInstance, TesseractEventHandler tesseractEventHandler) {
        if (TesseractExpandManager.getInstance().mGlobalEventHandler != null && !TesseractExpandManager.getInstance().mGlobalEventHandler.isEmpty()) {
            Set<Long> idSet = TesseractExpandManager.getInstance().mGlobalEventHandler.keySet();
            for (Long eventHandlerId : idSet) {
                IDXEventHandler idxEventHandler = TesseractExpandManager.getInstance().mGlobalEventHandler.get(eventHandlerId);
                if (idxEventHandler != null) {
                    tesseractInstance.registDXEventHanlder(eventHandlerId, idxEventHandler);
                }
            }
        }

        if (TesseractExpandManager.getInstance().mGlobalDXView != null && !TesseractExpandManager.getInstance().mGlobalDXView.isEmpty()) {
            Set<Long> idSet = TesseractExpandManager.getInstance().mGlobalDXView.keySet();
            for (Long dxViewId : idSet) {
                IDXBuilderWidgetNode widgetNode = TesseractExpandManager.getInstance().mGlobalDXView.get(dxViewId);
                if (widgetNode != null) {
                    tesseractInstance.registDXView(dxViewId, widgetNode);
                }
            }
        }

        if (TesseractExpandManager.getInstance().mGlobalParser != null && !TesseractExpandManager.getInstance().mGlobalParser.isEmpty()) {
            Set<Long> idSet = TesseractExpandManager.getInstance().mGlobalParser.keySet();
            for (Long parserId : idSet) {
                IDXDataParser parser = TesseractExpandManager.getInstance().mGlobalParser.get(parserId);
                if (parser != null) {
                    tesseractInstance.registDXDataParser(parserId, parser);
                }
            }
        }

        if (tesseractEventHandler != null) {
            tesseractEventHandler.addSubscribers(TesseractExpandManager.getInstance().mGlobalEventSubscriber);
        }

    }
}
