package com.alibaba.tesseract.page.manager;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;

import com.alibaba.gov.android.api.tesseractpage.ITesseractActivity;
import com.alibaba.tesseract.page.activity.TesseractActivity;

/**
 * Created by yiwei on 2020-10-02.
 */
public class TesseractActivityManager implements ITesseractActivity {

    @Override
    public void startTesseractActivity(Context context, String rawUrl) {
        doStart(context, null, rawUrl);
    }

    @Override
    public void startTesseractActivity(Context context, Bundle bundle, String url) {
        doStart(context, bundle, url);
    }

    private void doStart(Context context, Bundle bundle, String url) {
        if (context == null || TextUtils.isEmpty(url)) {
            return;
        }
        Intent intent = new Intent(context, TesseractActivity.class);
        intent.setData(Uri.parse(url));
        if (bundle != null) {
            String rawUrl = bundle.getString("url");
            if (TextUtils.isEmpty(rawUrl)) {
                bundle.putString("url", url);
            }
            intent.putExtras(bundle);
        }
        if (!(context instanceof Activity)) {
            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }
}
