package com.alibaba.tesseract.page.manager;


import androidx.annotation.NonNull;

import com.alibaba.android.tesseract.core.event.base.ISubscriber;
import com.alibaba.tesseract.page.inter.ITesseractExpand;
import com.taobao.android.dinamicx.IDXEventHandler;
import com.taobao.android.dinamicx.expression.parser.IDXDataParser;
import com.taobao.android.dinamicx.widget.IDXBuilderWidgetNode;

import java.util.HashMap;

/**
 * Created by yiwei on 2021/6/10.
 */
class TesseractExpandManager implements ITesseractExpand {
    private static TesseractExpandManager mServiceInstance = null;
    HashMap<Long, IDXBuilderWidgetNode> mGlobalDXView;
    HashMap<Long, IDXEventHandler> mGlobalEventHandler;
    HashMap<Long, IDXDataParser> mGlobalParser;
    HashMap<String, ISubscriber> mGlobalEventSubscriber;

    private TesseractExpandManager() {
        mGlobalDXView = new HashMap<>();
        mGlobalEventHandler = new HashMap<>();
        mGlobalParser = new HashMap<>();
        mGlobalEventSubscriber = new HashMap<>();
    }

    public static TesseractExpandManager getInstance() {
        if (mServiceInstance == null) {
            mServiceInstance = new TesseractExpandManager();
        }
        return mServiceInstance;
    }


    @Override
    public void registerGlobalDXView(long id, @NonNull IDXBuilderWidgetNode widgetNode) {
        if (mGlobalDXView != null) {
            mGlobalDXView.put(id, widgetNode);
        }
    }

    @Override
    public void registerGlobalDXEventHandler(long id, @NonNull IDXEventHandler eventHandler) {
        if (mGlobalEventHandler != null) {
            mGlobalEventHandler.put(id, eventHandler);
        }
    }

    @Override
    public void registerGlobalDXEventSubscriber(@NonNull String name, @NonNull ISubscriber subscriber) {
        if (mGlobalEventSubscriber != null) {
            mGlobalEventSubscriber.put(name, subscriber);
        }
    }

    @Override
    public void registerGlobalDXParser(long id, @NonNull IDXDataParser parser) {
        if (mGlobalParser != null) {
            mGlobalParser.put(id, parser);
        }
    }
}
