package com.alibaba.tesseract.page.manager;


import android.view.View;

import androidx.fragment.app.Fragment;

import com.alibaba.android.tesseract.core.event.base.ISubscriber;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesseract.page.activity.BaseTesseractFragment;
import com.alibaba.tesseract.page.inter.ILifecycleCallback;
import com.alibaba.tesseract.page.inter.ILoadMoreListener;
import com.alibaba.tesseract.page.inter.IRefreshListener;
import com.alibaba.tesseract.page.inter.ITesseractFragment;
import com.taobao.android.dinamicx.widget.IDXBuilderWidgetNode;

import java.util.Map;

/**
 * Created by yiwei on 2020-09-30.
 */
public final class TesseractFragmentManager implements ITesseractFragment {
    private BaseTesseractFragment mFragment;

    public TesseractFragmentManager() {
        mFragment = new BaseTesseractFragment();
    }

    @Override
    public void refresh() {
        if (mFragment != null) {
            mFragment.refresh();
        }
    }

    @Override
    public void refresh(JSONObject jsonObject) {
        if (mFragment != null) {
            mFragment.refresh(jsonObject);
        }
    }

    @Override
    public void loadMore(JSONObject jsonObject) {
        if (mFragment != null) {
            mFragment.loadMore(jsonObject);
        }
    }

    @Override
    public void registerLoadMoreListener(ILoadMoreListener loadMoreListener) {
        if (mFragment != null) {
            mFragment.setLoadMoreListener(loadMoreListener);
        }
    }

    @Override
    public void registerRefreshListener(IRefreshListener refreshListener) {
        if (mFragment != null) {
            mFragment.setRefreshListener(refreshListener);
        }
    }

    @Override
    public void setEnablePullRefresh(boolean flag) {
        if (mFragment != null) {
            mFragment.setEnablePullRefresh(flag);
        }
    }

    @Override
    public void setEnableLoadMore(boolean flag) {
        if (mFragment != null) {
            mFragment.setEnableLoadMore(flag);
        }
    }

    @Override
    public void setEventSubscriberMap(Map<String, ISubscriber> eventSubscriber) {
        if (mFragment != null) {
            mFragment.setEventSubscriberMap(eventSubscriber);
        }
    }

    @Override
    public void setRequestHeader(Map<String, String> requestHeader) {
        if (mFragment != null) {
            mFragment.setRequestHeader(requestHeader);
        }
    }

    @Override
    public void registerLifecycle(ILifecycleCallback lifecycle) {
        if (mFragment != null) {
            mFragment.registerLifecycle(lifecycle);
        }
    }

    @Override
    public void hideHeaderView(boolean flag) {
        if (mFragment != null) {
            mFragment.hideHeaderView(flag);
        }
    }

    @Override
    public Fragment createFragment(String pageName, String requestUrl) {
        return createFragment(pageName, requestUrl, null, null);
    }

    @Override
    public Fragment createFragment(String pageName, String requestUrl, View headerView) {
        return createFragment(pageName, requestUrl, headerView, null);
    }

    @Override
    public Fragment createFragment(String pageName, String requestUrl, View headerView, View bottomView) {
        mFragment.setPageName(pageName);
        mFragment.setRequestUrl(requestUrl);
        mFragment.setHeaderView(headerView);
        mFragment.setBottomView(bottomView);
        return mFragment;
    }

    @Override
    public void enablePageCache() {
        if (mFragment != null) {
            mFragment.enableCache();
        }
    }

    @Override
    public void mgopRequestNeedLogin(boolean flag) {
        if (mFragment != null) {
            mFragment.mgopRequestNeedLogin(flag);
        }
    }

    @Override
    public void setMultiPageRequestApi(String requestUrl) {
        if (mFragment != null) {
            mFragment.setMultiPageRequestUrl(requestUrl);
        }
    }

    @Override
    public void setPageBackgroundCorlor(String color) {
        if (mFragment != null) {
            mFragment.setPageBackgroundColor(color);
        }
    }
}

