package com.alibaba.tesseract.page.manager;


import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.tesseractpage.ITesseractActivity;
import com.alibaba.gov.android.api.tesseractpage.ITesseractRouter;
import com.alibaba.tesseract.page.activity.BaseTesseractFragment;
import com.alibaba.tesseract.page.inter.ITesseractFragment;
import com.alibaba.tesseract.page.inter.ITesseractPage;
import com.alibaba.tesseract.page.inter.ITesseractPageManager;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by yiwei on 2020-10-03.
 */
public class TesseractPageManager implements ITesseractPage, ITesseractPageManager {
    private static TesseractPageManager mServiceInstance = null;

    private List<BaseTesseractFragment> fragmentList;


    @Override
    public void registerTesseractPage(BaseTesseractFragment iTesseractFragment) {
        if (iTesseractFragment == null) {
            return;
        }
        if (fragmentList == null) {
            fragmentList = new ArrayList<>();
        }
        fragmentList.add(iTesseractFragment);
    }

    @Override
    public void unRegisterTesseractPage(BaseTesseractFragment iTesseractFragment) {
        if (iTesseractFragment == null) {
            return;
        }
        if (fragmentList != null) {
            fragmentList.remove(iTesseractFragment);
        }
    }

    private TesseractPageManager() {
        fragmentList = new ArrayList<>();
    }

    public static TesseractPageManager getInstance() {
        if (mServiceInstance == null) {
            mServiceInstance = new TesseractPageManager();
        }
        return mServiceInstance;
    }

    @Override
    public ITesseractFragment getFragmentManager() {
        return new TesseractFragmentManager();
    }

    @Override
    public ITesseractActivity getActivityManager() {
        return new TesseractActivityManager();
    }

    @Override
    public ITesseractRouter getTesseractRouter() {
        return new TesseractRouter();
    }

    @Override
    public JSONObject getTopPageData() {
        JSONObject result = null;
        if (fragmentList == null) {
            return result;
        }
        for (BaseTesseractFragment tesseractFragment : fragmentList) {
            JSONObject data = tesseractFragment.getDataIfVisible();
            if (data != null) {
                result = data;
                break;
            }
        }
        return result;
    }
}
