package com.alibaba.tesseract.page.manager;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;

import com.alibaba.android.tesseract.core.request.IRequestCallback;
import com.alibaba.android.tesseract.core.request.LoadingDialog;
import com.alibaba.android.tesseract.core.request.Request;
import com.alibaba.android.tesseract.core.request.RequestBuilder;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.api.router.IRouterService;
import com.alibaba.gov.android.api.tesseractpage.ITesseractRouter;
import com.alibaba.gov.android.common.config.AppConfig;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by yiwei on 2020-11-13.
 */
public class TesseractRouter implements ITesseractRouter {
    @Override
    public void gotoApaasPage(final Context context, final String url) {
        final LoadingDialog loadingDialog = new LoadingDialog(context);
        loadingDialog.show();

        List<String> filterKeys = new ArrayList<>();
        filterKeys.add("_apaas_");
        (new Request()).execute(
                new RequestBuilder(copyParameters(url, getBaseHost() + "/portal/app/redirect", filterKeys))
                        .requestGet(),
                new IRequestCallback() {
                    @Override
                    public void onError(int errorCode, String message, Map<String, ?> map) {
                        loadingDialog.dismiss();
                        //降级
                        IRouterService routerService = ServiceManager.getInstance().getService(IRouterService.class.getName());
                        if (null != routerService) {
                            routerService.goToUri(context, url.replace("_apaas_=true", ""));
                        }
                    }

                    @Override
                    public void onSuccess(JSONObject jsonObject, Map<String, ?> map) {
                        loadingDialog.dismiss();
                        String newUrl;
                        if (jsonObject != null && jsonObject.getBooleanValue("success")) {
                            newUrl = jsonObject.getString("data");
                        } else {
                            //降级
                            newUrl = url.replace("_apaas_=true", "");
                        }
                        IRouterService routerService = ServiceManager.getInstance().getService(IRouterService.class.getName());
                        if (null != routerService) {
                            routerService.goToUri(context, newUrl);
                        }
                    }
                });
    }

    public String getBaseHost() {
        Object config = AppConfig.getConfig("baseHost", AppConfig.MODULE_CONFIG);
        if (config instanceof String) {
            return (String) config;
        } else {
            return "";
        }
    }

    public String copyParameters(String rawUrl, String targetUrl, List<String> filterKey) {
        if (TextUtils.isEmpty(rawUrl) || TextUtils.isEmpty(targetUrl)) {
            return "";
        }
        Uri rawUri = Uri.parse(rawUrl);
        Uri targetUri = Uri.parse(targetUrl);
        Set<String> paramKeys = rawUri.getQueryParameterNames();
        if (paramKeys == null || paramKeys.isEmpty()) {
            return null;
        }
        if (filterKey == null) {
            filterKey = new ArrayList<>();
        }
        Iterator<String> iterator = paramKeys.iterator();
        Uri.Builder targetBuilder = targetUri.buildUpon();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (filterKey.contains(key)) {
                continue;
            }
            if (TextUtils.equals(key, "")
                    || TextUtils.equals(key, "")) {
                continue;
            }
            targetBuilder.appendQueryParameter(key, rawUri.getQueryParameter(key));
        }
        return targetBuilder.build().toString();
    }
}
