package com.alibaba.tesseract.page.parsers;

import android.text.TextUtils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.gov.android.foundation.utils.SharedPreferencesUtil;
import com.taobao.android.dinamicx.DXRuntimeContext;
import com.taobao.android.dinamicx.expression.parser.DXAbsDinamicDataParser;

public class DXDataParserZwCheckVisible extends DXAbsDinamicDataParser {
    public static final long DX_PARSER_ZWCHECKVISIBLE = 8741429661496711851L;

    @Override
    public Object evalWithArgs(Object[] operationList, DXRuntimeContext runtimeContext) {
        JSONObject data = runtimeContext.getData();
        if (data == null || data.isEmpty()) {
            return true;
        }
        String pageModuleId = data.getString("pageModuleId");
        if (TextUtils.isEmpty(pageModuleId)) return true;
        boolean visible = SharedPreferencesUtil.getBoolean("CheckVisible_" + pageModuleId, true);
        return visible;
    }

}
