package com.alibaba.tesseract.page.utils;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;

import androidx.annotation.NonNull;

import com.alibaba.gov.android.foundation.utils.SharedPreferencesUtil;


/**
 * Created by yiwei on 2020-07-22.
 * 刘海屏幕适配
 */
public class RVHeightUtils {


    public static void putRVHeight(String pageName, int height) {
        SharedPreferencesUtil.putInt(pageName, height);
    }

    public static int getRVHeight(Context context, String pageName) {
        return SharedPreferencesUtil.getInt(pageName, getScreenHeight(context));
    }

    public static int getScreenHeight(@NonNull Context context) {
        if (!isAllScreenDevice(context)) {
            return getNormalScreenHeight(context);
        } else {
            return getScreenRealHeight(context);
        }
    }

    private static int getScreenRealHeight(Context context) {
        int orientation = context != null
                ? context.getResources().getConfiguration().orientation
                : context.getResources().getConfiguration().orientation;
        orientation = orientation == Configuration.ORIENTATION_PORTRAIT ? 0 : 1;

        Point[] mRealSizes = new Point[2];

        if (mRealSizes[orientation] == null) {
            WindowManager windowManager = context != null
                    ? (WindowManager) context.getSystemService(Context.WINDOW_SERVICE)
                    : (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            if (windowManager == null) {
                return getNormalScreenHeight(context);
            }
            Display display = windowManager.getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            mRealSizes[orientation] = point;
        }
        return mRealSizes[orientation].y;
    }

    private static int getNormalScreenHeight(@NonNull Context context) {
        if (context != null) {
            return context.getResources().getDisplayMetrics().heightPixels;
        }
        return 0;
    }

    private static boolean isAllScreenDevice(@NonNull Context context) {
        // 低于 API 21的，都不会是全面屏。。。
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            return false;
        }
        boolean isAllScreenDevice = false;
        if (getScreenScale(context) >= 1.97f) {
            isAllScreenDevice = true;
        }
        return isAllScreenDevice;
    }

    private static float getScreenScale(Context context) {
        float scale = 1f;
        WindowManager windowManager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
        if (windowManager != null) {
            Display display = windowManager.getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            float width, height;
            if (point.x < point.y) {
                width = point.x;
                height = point.y;
            } else {
                width = point.y;
                height = point.x;
            }
            scale = height / width;
        }
        return scale;
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5F);
    }
}
