package com.alibaba.tesseract.page.utils;

public class RefreshCheck {

    private static long lastRefreshTime = 0;
    private static long REFRESH_GAP = 1000;
    private static String lastRefreshUrl;

    public static boolean isSecondRefresh(String url) {
        return isSecondRefresh(url, REFRESH_GAP);
    }

    public static boolean isSecondRefresh(String url, long refresh_gap) {
        long currTime = System.currentTimeMillis();
        long currGap = currTime - lastRefreshTime;
        if (url.equalsIgnoreCase(lastRefreshUrl) && lastRefreshTime > 0 && currGap < refresh_gap) {
            return true;
        }
        lastRefreshTime = currTime;
        lastRefreshUrl = url;
        return false;
    }    
 
}