package com.alibaba.tesseract.page.utils;

import android.net.Uri;
import android.text.TextUtils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Created by yiwei on 2021/3/8.
 */
public class UrlParserUtils {
    public static String copyParameters(String rawUrl, String targetUrl, List<String> filterKey) {
        if (TextUtils.isEmpty(rawUrl) || TextUtils.isEmpty(targetUrl)) {
            return "";
        }
        Uri rawUri = Uri.parse(rawUrl);
        Uri targetUri = Uri.parse(targetUrl);
        Set<String> paramKeys = rawUri.getQueryParameterNames();
        if (paramKeys == null || paramKeys.isEmpty()) {
            return null;
        }
        if (filterKey == null) {
            filterKey = new ArrayList<>();
        }
        Iterator<String> iterator = paramKeys.iterator();
        Uri.Builder targetBuilder = targetUri.buildUpon();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (filterKey.contains(key)) {
                continue;
            }
            if (TextUtils.equals(key, "")) {
                continue;
            }
            targetBuilder.appendQueryParameter(key, rawUri.getQueryParameter(key));
        }
        return targetBuilder.build().toString();
    }
}
