//
//  Generated by CodeGenV2 on 2019/11/01.
//  Copyright © 2019年 alibaba-inc. All rights reserved.
//
package com.alibaba.tesseract.page.view;

import static android.view.View.SCROLLBARS_INSIDE_INSET;

import android.app.Activity;
import android.content.Context;
import android.text.InputType;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesseract.page.events.ModifyDataEvent;
import com.taobao.android.dinamicx.DXDarkModeCenter;
import com.taobao.android.dinamicx.DinamicXEngine;
import com.taobao.android.dinamicx.widget.DXWidgetNode;
import com.taobao.android.dinamicx.widget.IDXBuilderWidgetNode;
import com.taobao.android.dinamicx.widget.utils.DXScreenTool;

import org.greenrobot.eventbus.EventBus;


public class DXZWTextViewWidgetNode extends DXWidgetNode {
    public static final String TAG = "DXZWTextViewWidgetNode";

    // ==================== 控件的hash值 ====================
    public static final long DXZWTEXTVIEW_ZWTEXTVIEW = 6469741772476334331L;

    // ==================== 属性的hash值 ====================

    public static final long DXZWTEXTVIEW_PLACEHOLDER = 5980555813819279758L;
    public static final long DXZWTEXTVIEW_PLACEHOLDERCOLOR = 1205272363096125842L;
    public static final long DXZWTEXTVIEW_READONLY = 6161941923299274598L;
    public static final long DXZWTEXTVIEW_TEXT = 38178040921L;
    public static final long DXZWTEXTVIEW_TEXTCOLOR = 5737767606580872653L;
    public static final long DXZWTEXTVIEW_TEXTSIZE = 6751005219504497256L;

    // ==================== 属性声明 ====================

    // 占位符
    private String placeholder;
    // 占位符字体颜色
    private int placeholderColor = 0x999999;
    // 只读
    private int readonly = DXScreenTool.ap2px(DinamicXEngine.getApplicationContext(), 0);
    // 输入的值
    private String text;
    // 字体颜色
    private int textColor = 0x000000;
    // 字体大小
    private int textSize = DXScreenTool.ap2px(DinamicXEngine.getApplicationContext(), 12);

    /**
     * <p>
     * 需要提供一个Builder，用与在构造原型树的时候生成相应的对象
     */
    public static class Builder implements IDXBuilderWidgetNode {
        @Override
        public DXWidgetNode build(Object object) {
            return new DXZWTextViewWidgetNode();
        }
    }

    /**
     * <p>
     * 子类必须重写返回相应的子类
     */
    @Override
    public DXWidgetNode build(Object object) {
        return new DXZWTextViewWidgetNode();
    }

    /**
     * 如果有自定义的属性时必须重写
     * <p>
     * 该方法必须进行重写，将当前widget中的特有属性进行一个copy
     * 必须要调用一遍super
     *
     * @param widgetNode
     */
    @Override
    public void onClone(DXWidgetNode widgetNode, boolean deepClone) {
        if (widgetNode == null || !(widgetNode instanceof DXZWTextViewWidgetNode)) {
            return;
        }

        super.onClone(widgetNode, deepClone);
        DXZWTextViewWidgetNode oNode = (DXZWTextViewWidgetNode) widgetNode;

        placeholder = oNode.placeholder;
        placeholderColor = oNode.placeholderColor;
        readonly = oNode.readonly;
        text = oNode.text;
        textColor = oNode.textColor;
        textSize = oNode.textSize;
    }

    /**
     * 如果需要创建自定义View时必须重写此方法
     * <p>
     * 返回该WidgetNode对应的native的View
     * 如果调用super则返回的只是一个基础的View
     *
     * @param context
     * @return
     */
    @Override
    protected View onCreateView(Context context) {
        EditText editText = new EditText(context);
        editText.setWidth(ViewGroup.LayoutParams.MATCH_PARENT);
        editText.setHeight(ViewGroup.LayoutParams.WRAP_CONTENT);
        editText.setBackground(null);
        editText.setScrollBarStyle(SCROLLBARS_INSIDE_INSET);
        editText.setGravity(Gravity.TOP | Gravity.LEFT);
        editText.setInputType(InputType.TYPE_TEXT_FLAG_MULTI_LINE);
        editText.setSingleLine(false);
        editText.setHorizontallyScrolling(false);
        editText.setCursorVisible(false);

        editText.setPadding(13, 13, 0, 0);
        return editText;
    }

    /**
     * 如果需要创建自定义View时必须重写此方法
     * <p>
     * 给当前widgetNode对应的nativeView设置特有的属性，
     * 通用属性已经在renderView中设置完成
     *
     * @param context
     * @param weakView widgetNode上面绑定的view，使用时需要进行判空，因为是弱引用
     */
    @Override
    protected void onRenderView(Context context, View weakView) {
        if (weakView != null && weakView instanceof EditText) {
            final EditText editText = (EditText) weakView;
            editText.setHint(this.placeholder);
            int placeHolderColor = this.tryFetchDarkModeColor("placeholderColor", DXDarkModeCenter.DRAW_TYPE_TEXT, this.placeholderColor);
            editText.setHintTextColor(placeHolderColor);
            editText.setText(this.text);
            editText.setTextSize(TypedValue.COMPLEX_UNIT_SP, this.textSize);
            int textColor = this.tryFetchDarkModeColor("textColor", DXDarkModeCenter.DRAW_TYPE_TEXT, this.textColor);
            editText.setTextColor(textColor);
            if (readonly == 1) {
                editText.setFocusable(false);
                editText.setFocusableInTouchMode(false);
            } else if (readonly == 0) {
                ZWTextWatcher textWatcher = new ZWTextWatcher(this);
                editText.setOnTouchListener(textWatcher);
                editText.setOnFocusChangeListener(textWatcher);
                if (context instanceof Activity) {
                    new SoftKeyBoardListener((Activity) context).setOnSoftKeyBoardChangeListener(editText, textWatcher);
                }
            }
        }
    }

    /**
     * 可根据情况选择重写
     * <p>
     * 给当前view绑定特有的一些事件，默认已经绑定了 onTap 和 onLongTap
     * 如果需要支持上述两个默认事件，必须要调用super
     *
     * @param context
     * @param weakView widgetNode上面绑定的view，使用时需要进行判空，因为是弱引用
     * @param eventId
     */
    @Override
    protected void onBindEvent(Context context, View weakView, long eventId) {
        super.onBindEvent(context, weakView, eventId);

    }

    /**
     * 如果需要支持宽高的match_content,则必须重写此方法计算自适应宽高
     * <p>
     * 如果子类使用了match_content但没有重写此方法, 则会根据父View的约束生成一个默认的大小
     * 可调用super方法,让父类处理定宽定高的场景
     * 如果子widgetNode都是定值的话，则不需要重写该方法
     */
    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    // ==================== 属性设置 ====================

    @Override
    protected void onSetStringAttribute(long key, String attr) {
        if (key == DXZWTEXTVIEW_PLACEHOLDER) {
            placeholder = attr;
        } else if (key == DXZWTEXTVIEW_TEXT) {
            text = attr;
        } else {
            super.onSetStringAttribute(key, attr);
        }
    }

    @Override
    protected void onSetIntAttribute(long key, int attr) {
        if (key == DXZWTEXTVIEW_PLACEHOLDERCOLOR) {
            placeholderColor = attr;
        } else if (key == DXZWTEXTVIEW_READONLY) {
            readonly = attr;
        } else if (key == DXZWTEXTVIEW_TEXTCOLOR) {
            textColor = attr;
        } else if (key == DXZWTEXTVIEW_TEXTSIZE) {
            textSize = attr;
        } else {
            super.onSetIntAttribute(key, attr);
        }
    }

    // ==================== 属性默认值设置 ====================

    @Override
    public int getDefaultValueForIntAttr(long key) {
        if (key == DXZWTEXTVIEW_PLACEHOLDERCOLOR) {
            return 0x999999;
        } else if (key == DXZWTEXTVIEW_READONLY) {
            return DXScreenTool.ap2px(DinamicXEngine.getApplicationContext(), 0);
        } else if (key == DXZWTEXTVIEW_TEXTCOLOR) {
            return 0x000000;
        } else if (key == DXZWTEXTVIEW_TEXTSIZE) {
            return DXScreenTool.ap2px(DinamicXEngine.getApplicationContext(), 12);
        }
        return super.getDefaultValueForIntAttr(key);
    }

    public static class ZWTextWatcher implements View.OnTouchListener, View.OnFocusChangeListener, SoftKeyBoardListener.OnSoftKeyBoardChangeListener {
        private DXZWTextViewWidgetNode textWidgetNode;
        private long lastPostTime = 0;

        public ZWTextWatcher(DXZWTextViewWidgetNode textWidgetNode) {
            this.textWidgetNode = textWidgetNode;
        }

        @Override
        public void onFocusChange(View v, boolean hasFocus) {
            if (!hasFocus) {
                changeValueAfterInputFinish(((EditText) v).getText().toString());
            }
        }

        @Override
        public void onKeyBoardShow(EditText editText) {
        }

        @Override
        public void onKeyBoardHide(EditText editText) {
            if (editText.hasFocus()) {
                changeValueAfterInputFinish((editText.getText().toString()));
            }
        }

        @Override
        public boolean onTouch(View view, MotionEvent event) {
            EditText editText = (EditText) view;
            if (event.getActionMasked() == 1) {
                editText.setCursorVisible(true);
            }
            if (editText.getLineCount() < 6) {
                return false;
            }
            if (event.getAction() == MotionEvent.ACTION_DOWN) {
                editText.getParent().requestDisallowInterceptTouchEvent(true);
            }
            if (event.getAction() == MotionEvent.ACTION_MOVE) {
                editText.getParent().requestDisallowInterceptTouchEvent(true);
            }
            if (event.getAction() == MotionEvent.ACTION_UP) {
                editText.getParent().requestDisallowInterceptTouchEvent(false);
            }
            return false;
        }

        private void changeValueAfterInputFinish(String content) {
            long cur = System.currentTimeMillis();
            if (cur - lastPostTime < 100) {
                return;
            }
            lastPostTime = cur;
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("value", content);
                String fieldId = textWidgetNode.getDXRuntimeContext().getData().getJSONObject("fields").getString("fieldId");
                ModifyDataEvent modifyDataEvent = new ModifyDataEvent(textWidgetNode.getDXRuntimeContext().getBizType(), fieldId, jsonObject);
                modifyDataEvent.setRefreshAfterModity(false);
                EventBus.getDefault().post(modifyDataEvent);
            } catch (Exception e) {
                Log.e(TAG, e.getMessage());
            }

        }
    }
}
