package com.alibaba.tesseract.page.view;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;

import com.airbnb.lottie.LottieAnimationView;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieCompositionFactory;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieListener;
import com.alibaba.gov.android.api.picLoader.IPictureLoaderService;
import com.alibaba.gov.android.api.picLoader.OnPictureLoaderCallback;
import com.alibaba.gov.android.foundation.event.CommonEvent;
import com.alibaba.gov.android.servicebus.manager.ServiceManager;
import com.alibaba.tesseract.page.activity.Constants;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;


public class SlideLottieView extends LottieAnimationView {

    private static boolean isColdStart = true;
    private LottieComposition cachedComposition;

    public SlideLottieView(Context context) {
        super(context);
        init(context);
    }

    public SlideLottieView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public SlideLottieView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        this.setImageAssetsFolder("home/");
        this.setRepeatCount(-1);
        this.setScaleType(ImageView.ScaleType.FIT_XY);
    }

    private void refreshCover(String cover) {
        if (TextUtils.isEmpty(cover)) {
            setBackgroundDrawable(null);
            setDefaultPlaceHolder(null);
            return;
        }
        try {
            IPictureLoaderService loaderService = ServiceManager.getInstance().getService(IPictureLoaderService.class.getName());
            if (loaderService != null) {
                loaderService.load(getContext(), cover).onLoadCallback(new OnPictureLoaderCallback() {
                    @Override
                    public void onSuccess(Drawable drawable) {
                        if (drawable != null) {
                            setBackgroundDrawable(drawable);
                            if (drawable instanceof BitmapDrawable) {
                                BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
                                setDefaultPlaceHolder(bitmapDrawable.getBitmap());
                            }
                        }
                    }

                    @Override
                    public void onFail(Exception e) {}
                }).into(new ImageView(getContext()));
            }
        } catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void refreshLottie(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            Drawable drawable = this.getDrawable();
            if (drawable != null && drawable instanceof LottieDrawable) {
                ((LottieDrawable) drawable).clearComposition();
            }
            cachedComposition = null;
            return;
        }
        try {
            LottieCompositionFactory.fromUrl(this.getContext(), filePath).addListener(new LottieListener<LottieComposition>() {
                @Override
                public void onResult(LottieComposition composition) {
                    if (composition == null) return;
                    if (composition == cachedComposition) return;
                    cachedComposition = composition;
                    setComposition(composition);
                    if (!isColdStart) {
                        playAnimation();
                    }
                }
            });
        } catch (Throwable e) {
            cachedComposition = null;
            LottieCompositionFactory.clearCache(getContext());
        }
    }

    public void refresh(String filePath, String bgImage) {
        refreshCover(bgImage);
        refreshLottie(filePath);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (isColdStart) {
            uiHandler.removeMessages(101);
            Message message = Message.obtain();
            message.what = 101;
            uiHandler.sendMessageDelayed(message, 2000);
        }
    }

    Handler uiHandler = new Handler(Looper.getMainLooper()) {
        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 101) {
                if (!isAnimating()) {
                    playAnimation();
                }
                isColdStart = false;
            }
        }
    };

}