		/* window.addEventListener('load', () => {
			(function initHeight() {
				let preview_box = document.querySelector('.preview_box')
				let barHeight = getParams('barHeight')
				let pageHeight = document.body.style.height
				preview_box.style.height = `height:calc(100% - ${barHeight/16}rem)`

			}())
		}) */



		// video的Dom对象
		var _video = document.getElementById('videoMain');
		// 采集时长（毫秒）
		// var _recordTime = 5500; //正常时长
		var _recordTime = 9999000; //调试
		// 视频流
		var _stream;
		// MediaRecorder实例
		var _recorder;
		// Blob缓存
		var _blobs;
		// 是否正在进行检测
		var _isRunning = false;
		// 动作类型
		var _actions = "";

		var scW = getParams('scW')
		var scH = getParams('scH')


		/**
		 * 初始化并开始采集
		 */
		(function initAndStart() {
			// 防止重复点击
			if (_isRunning) {
				return;
			}

			// 隐藏按钮
			hideButtons();
			// 设置为正在检测
			_isRunning = true;



			// 开始
			start();
		}())

		/**
		 * 开始
		 */
		function start() {
			console.log(scH, scW, 9999)
			// 清空引导信息
			clearGuide();
			// 清空提示信息
			clearTips();
			// 外侧圆圈开始旋转
			// document.getElementById('divOutsideCircle').className = 'outside-circle rotating';

			// 获取用户媒体设备
			getUserMedia({
				video: {
					// 权限
					permissions: {
						"video-capture": {
							"description": "Required to capture video using getUserMedia()"
						}
					},
					// 优先使用前置摄像头
					facingMode: 'user',
					width: scH < 640 ? scH : 640,
					height: scW < 480 ? scW : 480,
					frameRate: {
						// 最小帧率
						min: 20,
						// 理想帧率
						ideal: 30,
						// 最大帧率
						max: 30
					}
				},
				// 静音
				audio: false
			}, function(err, stream) {
				if (err) {
					showTips('获取用户媒体设备失败');
					showGuide('获取用户媒体设备失败，请在控制台查看错误详情');
					// 弹出错误提示
					alert(err);
					return;
				}
				// 视频流
				_stream = stream;
				// 显示取景框
				_video.style.display = '';
				_video.srcObject = _stream;
				_video.play();

				// 通过MediaRecorder记录获取到的媒体流
				_recorder = new MediaRecorder(_stream);
				_recorder.ondataavailable = function(e) {
					_blobs.push(e.data);
				};
				// 绑定回调
				_recorder.onstop = onStopCallback;

				// 开始录制
				record();

				// sendMessage()

			});
		}

		/**
		 * 录制
		 */
		function record() {
			// 显示引导信息
			showGuide('正在采集视频数据...');
			// showGuide(getGuideByAction(Math.floor(Math.random() * 4) + 1));
			/* showGuide(getGuideByAction(Math.floor((Math.random() * 2) +
				3
			))); */

			//只显示一个
			showGuideLineTwo('请调整位置，让您的脸完整出现在圈内');
			showGuide(getGuideByAction(3, '请正视屏幕并上下点头'));

			// 延迟0.5秒，给予用户足够的反应时间
			setTimeout(() => {
				// 清空缓存
				_blobs = [];
				// 开始录制
				_recorder.start();
				setTimeout(() => {
					// 录制
					_recorder.stop();

				}, _recordTime);

			}, 500);
		}

		/**
		 * 录制结束回调
		 */
		function onStopCallback() {
			// 录像数据
			var totalBlob = new Blob(_blobs, {
				'type': _recorder.mimeType
			});

			// 转换为Base64
			blobToBase64(totalBlob, function(base64Data) {
				// 结束
				stop();

				showTips('视频采集成功', true);
				// showGuide('视频采集成功，请在控制台查看结果');
				// 显示按钮
				showButtons();
				// 弹出下载框
				// download('视频base64数据.txt', base64Data);
				// base64Data = base64Data.replace(/^data:video\/\w+;base64,/, "")
				var newBase64Data = base64Data.replace(/data:video\/.*;base64,/, "")
				// console.log(newBase64Data, 787878)
				uni.postMessage({
					data: {
						withActions: _actions,
						withVideoBase64: newBase64Data
					}
				});
			})


		}

		/**
		 * 结束
		 */
		function stop() {
			// 外侧圆圈停止旋转
			// document.getElementById('divOutsideCircle').className = 'outside-circle';
			// 隐藏取景框
			_video.style.display = 'none';

			// 关闭媒体流
			if (typeof _stream.stop === 'function') {
				_stream.stop();
			} else {
				let trackList = [_stream.getAudioTracks(), _stream.getVideoTracks()];
				for (let i = 0; i < trackList.length; i++) {
					let tracks = trackList[i];
					if (tracks && tracks.length > 0) {
						for (let j = 0; j < tracks.length; j++) {
							let track = tracks[j];
							if (typeof track.stop === 'function') {
								track.stop();
							}
						}
					}
				}
			}

			// 重置检测状态
			_isRunning = false;
		}

		/**
		 * 显示引导信息
		 * @param {string} message - 引导信息
		 */
		function showGuide(message) {
			document.getElementById('lblGuide').innerText = message;
		}

		function showGuideLineTwo(message) {
			document.getElementById('lblGuide-line-two').innerText = message;
		}

		/**
		 * 清空引导信息
		 */
		function clearGuide() {
			document.getElementById('lblGuide').innerText = '';
			document.getElementById('lblGuide-line-two').innerText = '';
		}

		/**
		 * 显示提示信息
		 * @param {string} tips - 提示信息
		 * @param {boolean} bgBlue - 是否蓝色背景
		 */
		function showTips(tips, bgBlue) {
			document.getElementById('lblGuide').innerText = tips;
			document.getElementById('lblGuide-line-two').innerText = '';
			// document.getElementById('lblTips').innerText = tips;
			// document.getElementById('divTips').className = 'tips' + (bgBlue ? ' blue' : '');
			// document.getElementById('divTips').style.display = '';
		}

		/**
		 * 清空提示信息
		 */
		function clearTips() {
			// document.getElementById('lblTips').innerText = '';
			// document.getElementById('divTips').style.display = 'none';
		}

		/**
		 * 显示按钮
		 */
		function showButtons() {
			// document.getElementById('divButtons').style.display = 'flex';
		}

		/**
		 * 隐藏按钮
		 */
		function hideButtons() {
			// document.getElementById('divButtons').style.display = 'none';
		}

		/**
		 * 根据动作码返回引导信息
		 * @param {number} action - 动作码
		 * @returns 
		 */
		function getGuideByAction(action, word) {
			_actions = action
			if (word) {
				return word
			}
			switch (action) {
				/* case 1:
					return '请向左摇头';
				case 2:
					return '请向右摇头';
				case 3:
					return '请缓慢点头';
				case 4:
					return '请缓慢张嘴'; */
				case 3:
					return '请缓慢点头';
				case 4:
					return '请缓慢张嘴';
				default:
					return '';
			}
		}

		/**
		 * 在父页面中关闭当前页面窗口
		 */
		function closeWindowInParent() {
			if (window.parent != null) {
				window.parent.postMessage({
					operation: 'closeIfrRecord'
				}, '*');
			}
		}


		/* 发送消息到uniapp */
		/* function sendMessage() {
			document.addEventListener('UniAppJSBridgeReady', function() {
				// 向应用发送消息
				uni.postMessage({
					data: {
						withActions: _actions,
						withVideoBase64: totalBlob
					}
				});
			});
		} */