import cons from '@/config/constant.js'
import base from '@/config/baseUrl';
export default {
	data() {
		return {
			// 全局变量
			constant: cons,
			base: base
		}
	},
	methods: {
		// 获取服务端图片地址
		networkImage(name = '') {
			// #ifdef APP-PLUS
			return '/static/appimage/' + name;
			// #endif
			// #ifdef MP
			// return base.imageUrl + "/" + base.appIdent + "/" + name;
			return base.imageUrl + "/GZJDB/" + name; // 所有马甲包用的都是接单宝项目，图片资源也是，所以此处直接写死APP标识，否则打马甲包切换appIdent会导致项目图片无法访问
			// #endif
		}
	}
}