#extension GL_OES_EGL_image_external : require
precision mediump float;

uniform sampler2D originTexture;
uniform sampler2D flyTexture;
uniform sampler2D flyTextureFlash;
uniform sampler2D flyTextureWin;
uniform sampler2D flyTextureFail;

uniform sampler2D itemTexture;
uniform sampler2D itemBottomTexture;
uniform sampler2D scoreTexture;

varying vec2 TextureCoordsVarying;

void main (void) {
    vec4 flyFlash = texture2D(flyTextureFlash, TextureCoordsVarying);
    vec4 flyWin = texture2D(flyTextureWin, TextureCoordsVarying);
    vec4 flyFail = texture2D(flyTextureFail, TextureCoordsVarying);
    vec4 flyNormal = texture2D(flyTexture, TextureCoordsVarying);

    vec4 flyMerge1 = mix(flyFlash,flyWin,flyWin.a);
    vec4 flyMerge2 = mix(flyFail,flyNormal,flyNormal.a);

    vec4 fly = mix(flyMerge1,flyMerge2,flyMerge2.a);

    vec4 media = texture2D(originTexture, TextureCoordsVarying);
    vec4 itemTop = texture2D(itemTexture, TextureCoordsVarying);
    vec4 mediaWithItemTop = mix(media,itemTop,itemTop.a);
    vec4 itemBottom = texture2D(itemBottomTexture, TextureCoordsVarying);
    vec4 mediaWithItemTopBottom = mix(mediaWithItemTop,itemBottom,itemBottom.a);

    vec4 mediaWithFlyWithItemTopBottom = mix(mediaWithItemTopBottom,fly,fly.a);

    vec4 itemScore = texture2D(scoreTexture, TextureCoordsVarying);
    vec4 result = mix(mediaWithFlyWithItemTopBottom,itemScore,itemScore.a);
    gl_FragColor = result;
}

