(function() {
    if(window.WebViewJavascriptBridge){return;}
    window.b_debug = AndroidJsJava.isDebug();
    var registerHandlers = {};
    var responseHandlers = {};
    var responseFallHandlers = {};
    var uniqueId = 1;

    function registerHandler(handlerName, handler) {
        registerHandlers[handlerName] = handler;
    }

    // h5 调用 安卓:  handlerName, data, callbackId?
    function callHandler() {
        var handlerName = arguments[0]; var data = arguments[1]; var callback = arguments[2]; var fallback = arguments[3];
        if (handlerName == undefined || handlerName == null) {console.error('handlerName 非法!!!'); return;}
        if (handlerName == 'command') {
            if (data && data.command) {handlerName = 'command_' + data.command.toLowerCase();} else {console.error('command 参数有误!!!'); return;}
        }
        if (typeof data == 'function') {fallback = callback; callback = data; data = null;}
        var message = {handlerName: handlerName, data: data};
        if (callback || fallback) {
            var callbackId = 'cb_' + (uniqueId++) + '_' + new Date().getTime();
            message.callbackId = callbackId;
            if (callback) {
                callback._handler_name_ = handlerName;
                responseHandlers[callbackId] = callback;
            }
            if (fallback) {
                fallback._handler_name_ = handlerName;
                responseFallHandlers[callbackId] = fallback;
            }
        }
        var messageJSON = JSON.stringify(message);
        AndroidJsJava.postMessage(messageJSON);
        if(window.b_debug){console.log("【jsBridge】callHandler \'" + handlerName + "\' with params -> " + messageJSON);}
    }

    function _handleMessageFromNative(messageJSON) {
        setTimeout(function() {
            var message = JSON.parse(messageJSON);
            var responseCallback;
            // 安卓给h5返回值: responseData, responseId = callbackId
            if (message.responseId) {
                if (message.fallback) {
                    // fallback
                    responseCallback = responseFallHandlers[message.responseId];
                    if (responseCallback) {
                        responseCallback(responseCallback._handler_name_);
                        delete responseFallHandlers[message.responseId];
                        if(window.b_debug){console.error("【jsBridge】callHandler \'"+responseCallback._handler_name_+"\' failed on WeiMai App");}
                    }
                } else {
                    // callback
                    responseCallback = responseHandlers[message.responseId];
                    if (responseCallback) {
                        responseCallback(message.responseData);
                        delete responseHandlers[message.responseId];
                        if(window.b_debug){console.log("【jsBridge】callHandler \'"+responseCallback._handler_name_+"\' with result -> "+message.responseData);}
                    }
                }
            } else if (message.handlerName) {
                // 安卓调用h5: handlerName, data, callbackId?
                var hm = message.handlerName;
                if (message.callbackId) {
                    var callbackResponseId = message.callbackId;
                    responseCallback = function(responseData) {
                        // h5给安卓返回值: responseData, responseId = callbackId
                        AndroidJsJava.postMessage(JSON.stringify({responseId: callbackResponseId, responseData: responseData}));
                        if(window.b_debug){console.log("【jsBridge】WeiMai App call \'"+hm+"\' with result -> " + responseData);}
                    };
                }
                var handler = registerHandlers[hm];
                try {
                    handler(message.data, responseCallback);
                    if(window.b_debug){console.log("【jsBridge】WeiMai App call \'" + hm + "\' with params -> " + message.data);}
                } catch (exception) {
                    if(window.b_debug){console.log("【jsBridge】WeiMai App call \'" + hm + "\' failed");}
                }
            }
        });
    }

    var WebViewJavascriptBridge = window.WebViewJavascriptBridge = {
        init: function(){}, send: function(){}, registerHandler: registerHandler, callHandler: callHandler, _handleMessageFromNative: _handleMessageFromNative
    };

    var doc = document;
    var readyEvent = doc.createEvent('Events');
    readyEvent.initEvent('WebViewJavascriptBridgeReady');
    readyEvent.bridge = WebViewJavascriptBridge;
    doc.dispatchEvent(readyEvent);
})();