package com.vip.sdk.utils_lib.thread;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

import java.util.concurrent.TimeUnit;

/**
 * Author: rongjinsong(jason01.rong@vipshop.com)
 * Date: 2015-04-10
 * Time: 17:14
 * FIXME
 */
public class ThreadPoolUtil {

    private final static int CORE_POOL_SIZE = 1;
    private final static int MAX_POOL_SIZE = 6;
    private final static int KEEP_ALIVE_TIME = 60;
    private static int sCorePoolSize = CORE_POOL_SIZE;

    private static AbstractThreadExecutor sExecutor;
    private static Handler sUiHandler = new Handler(Looper.getMainLooper());
    private static HandlerThread sHandlerThread = new HandlerThread("single-task-thread");
    private static Handler sWorkThreadHandle;

    static {
        sCorePoolSize = Runtime.getRuntime().availableProcessors() - 1;
        if (sCorePoolSize < CORE_POOL_SIZE) {
            sCorePoolSize = CORE_POOL_SIZE;
        }
        if (sCorePoolSize > MAX_POOL_SIZE) {
            sCorePoolSize = MAX_POOL_SIZE;
        }
        sHandlerThread.start();
        sWorkThreadHandle = new Handler(sHandlerThread.getLooper());
        sExecutor = new ThreadExecutor();
    }


    /**
     * post到线程池
     *
     * @param task
     */
    public static void execute(ProvityRunnable task) {
        sExecutor.execut(task);
    }

    /**
     * UI线程
     *
     * @param task
     */
    public static void runOnUiThread(Runnable task) {
        sUiHandler.post(task);
    }

    public static void runOnUiThread(Runnable task, long delayMillis) {
        sUiHandler.postDelayed(task, delayMillis);
    }
    /**
     * 单个队列线程
     *
     * @param task
     */
    public static void runOnSequenceThread(ProvityRunnable task) {
        sWorkThreadHandle.post(task);
    }

    public static void cancle(Runnable task) {
        sUiHandler.removeCallbacks(task);
        sExecutor.cancle(task);
        sWorkThreadHandle.removeCallbacks(task);
    }

    private static class ThreadExecutor extends AbstractThreadExecutor {
        @Override
        public ThreadPool initThreadManager() {
            return ThreadPool.build("sdk-thread-pool", sCorePoolSize, MAX_POOL_SIZE, KEEP_ALIVE_TIME, TimeUnit.SECONDS, true);
        }
    }
}
