var app = angular.module('app', []);
app.config(function ($compileProvider) {
    $compileProvider.debugInfoEnabled(false);
});

angular.module("app").factory("_", function () {
    return _;
});
angular.module("app").directive("contenteditable", ["_", function (dash) {
    return {
        restrict: "A",
        require: "?ngModel",
        link: function (t, n, i, a) {
            function o() {
                var t = dash.trim(n.text());
                a.$setViewValue(t)
            }

            a && (a.$render = function () {
                    n.text(dash.trim(a.$viewValue) || "");
                    o()
                },

                    n.on("blur keyup change", function () {
                        t.$evalAsync(o)
                    })
            )
        }
    }
}
]);
angular.module("app").component("etVblank", {
    template: ["$element", "_", function (element, dash) {

        var spanHtml = '<span ng-class="{correct:blank.isCorrect, checked: blank.isChecked}" class="wrapper"><et-statistic ng-if="blank.statistic" statistic="blank.statistic"></et-statistic><span contenteditable ng-class="{overflow: blank.isOverflowed}" class="blank" ng-model="blank.value"></span><span class="key" ng-if="blank.hasKey" ng-class="{visible: blank.isKeyVisible}" class="key" ng-bind-html="blank.keyString[0]"></span></span>';
        dash.trim(element.text()).length === 0 ? element.data("key", []) : (element.data("key", dash.trim(element.text())));
        //console.log('>>>template.etblank id=' + element.context.id + ', value=' + element.data('key'));
        return spanHtml;
    }],

    controllerAs: "blank",
    bindings: {
        value: "=?",
        statusChange: "&?"
    },
    controller: ["$element", "$scope", "_", "$timeout", "$compile", function (element, scope, dash, timeout, compile) {
        function fixcss() {
            var isOverflowed = false;
            isOverflowed = blank[0].scrollWidth > lineWidth || Math.round(blank[0].getBoundingClientRect().width) > lineWidth;
            m.isOverflowed = isOverflowed;
        }

        function statusChange() {
            angular.isFunction(m.statusChange) && m.statusChange({
                status: A
            })
        }

        var m = this, valueLength, lineWidth, eId, blank;
        eId = element.attr("id");
        blank = element.find(".blank").eq(0);
        m.key = element.data("key");
        m.key = m.key+"     ";
        m.value = "";
        m.isOverflowed = false;
        m.maxLen = 100;
        m.minWidth = 80;
        m.hasKey = m.key.length > 0;
        timeout(function () {
            m.value = m.key;
            timeout(fixcss, 0);
        });

        //console.log('>>>controller.etblank Id=' + eId + ',value=' + m.key);

        if (m.hasKey) {
            valueLength = dash.clone(m.key).length;
            lineWidth = 13 * (valueLength + 3);
            lineWidth = lineWidth > m.minWidth ? m.minWidth : lineWidth;
            blank.css("width", lineWidth);
        }
        // m.hasKey ? (valueLength = dash.clone(m.key).length, lineWidth = 13 * (valueLength + 3), lineWidth = lineWidth > m.minWidth ? m.minWidth : lineWidth, blank.css("width", lineWidth)) : lineWidth = blank.width();
        blank.on("keyup", function () {
            timeout(fixcss, 0);
        });
        blank.on("keydown", function (event) {
            13 === event.which && event.preventDefault();
            var allowkey = [32, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105];
            var inkey = allowkey.indexOf(event.which) >= 0;
            if (blank.text().length >= m.maxLen && inkey) {
                //console.log("out of maxlen "+mobj.maxLen);
                event.preventDefault();
            }
        });
        blank.on("drop", function (e) {
            try {
                blank.text(dash.trim(e.originalEvent.dataTransfer.getData("text").replace(/\n/g, " ").replace(/\s+/g, " ")));
                timeout(fixcss, 0);
            } catch (e) {
            }
            e.preventDefault()
        });
        blank.on("dragover", function (e) {
            e.preventDefault()
        });
        blank.on("paste", function (e) {
            e.preventDefault();
            var tmp, tt, n;
            var t = "", a = e.originalEvent;
            a.clipboardData && a.clipboardData.getData ? t = a.clipboardData.getData("text/plain") : window.clipboardData && window.clipboardData.getData && (t = window.clipboardData.getData("Text"));
            t = dash.trim(t.replace(/\n/g, " ").replace(/\s+/g, " "));
            tmp = blank.text() + t;
            if (tmp.length > m.maxLen) {
                tt = t.substr(0, tmp.length - m.maxLen);
                //console.log("out of maxlen "+mobj.maxLen+" fixed");
                n = blank.text() + tt;
            } else {
                n = blank.text() + t;
            }
            blank.text(n);
            timeout(fixcss, 0);
        });
        scope.$on("fontSizeChanged", function (e, t) {
            console.log('fontSizeChanged');
            lineWidth = (valueLength + 3) * t * .6;
            lineWidth = lineWidth > m.minWidth ? m.minWidth : lineWidth;
            blank.css("width", lineWidth);
            fixcss()
        });

        scope.$watch("blank.value", function (e, t) {
            statusChange();
        });

    }]


});

