DOCUMENT_FILE = "pdf,doc,docx,ppt,pptx,xls,xlsx";
ZIP_FILE= "zip,rar,7z";
APK_FILE= "apk";
var app = {
    debug: true,
    templates: {},
    mainContainer: null,
    mainContainerToolbar:null,
    imageIds: null,
    imageFolders: null,
    selectionNum: 0,
    selectionArr: [],
    collectionView: null,
    uploadFiles: [],
    uploadingInfo: {},
    timerHandle: 0,
    timerCount: 0,
    mode: "image", // 模式 'image','video','music','download','files', 'document'
    submode: "images",
    folderIndex: 0,
    paths:[],
    folderStack:[],
    currentFolder: null,
    scrollTopStack: [],
    clipboardDatas: [],
    appPath: "/sdcard/FFT",
    preScrollTop:[],
    sortByTabBar: null,
    fileType: DOCUMENT_FILE,
    searchContent:"",
    searchResult: null,
    lastPath: null,
    initTemplate: function() {
        $('script[type="text/x-handlebars-template"]').each(function() {
            html = $(this).html();
            name = $(this).attr("id");
            app.templates[name] = Handlebars.compile(html);
        });

    },
    getTemplate: function(path, callback) {
        if (app.templates[path]) {
            callback(app.templates[path]);
        } else {
            $.get(path, function(html) {
                console.log(html);
                var template = Handlebars.compile(html);
                app.templates[path] = template;
                callback(template);
            });
        }
    },
    generateShortId: function() {
        return ("0000" + (Math.random()*Math.pow(36,4) << 0).toString(36)).slice(-4);
    },
    loadNavbar: function(){
        $.ajax({
            url: '/static/html/inc/navbar.html',
            success: function(res) {
                var template = Handlebars.compile(res);
                var html = template();
                $('.right-container').prepend(html);
            }
        })
    },
    render:function(ele, source, data) {
        template = Handlebars.compile(source);
        $(ele).html(template(data));
    },
    handleError: function(res) {
        if (res.code == -2) {
            app.getTemplate('/static/template/manager_all_file_alert.html', function(template) {
                app.mainContainer.html(template(res.message));
            });
        }  else if (res.code == -4 || res.code == -5) {
            app.getTemplate('/static/template/no_external_storage_permission_alert.html', function(template) {
                app.mainContainer.html(template(res.message));
            });
        } else {
            app.mainContainer.html("<h1>" + res.message + "</h1>");
        }
    },
    loadImages: function() {
        if (app.imageIds) {
            var html = app.templates['template-images']({imageIds: app.imageIds});
            app.mainContainer.html(html);
        }
        app.mainContainerToolbar.html('');
        app.mainContainer.removeClass('has-breadcrumb');
        app.mainContainer.html('');
        $.getJSON('/images/list', function(res){
            console.log("res code " + res["code"]);
            console.log(res);
            if (app.mode != 'image') {
                return;
            }
            if (res["code"] == 0) {
                if (res.imageIds.length > 0) {
                    app.imageIds = res.imageIds;
                    app.layoutImages(app.imageIds);
                } else {
                    app.mainContainer.html("<h1>没有照片</h1>")
                }
            } else {
                app.handleError(res);
            }
        });
        
    },
    layoutImages: function(imageIds) {
        console.log("render images");
        var collection = new CollectionView();
        collection.datasource = {
            count: function() {
                return imageIds.length;
            },
            cellForIndex: function(index) {
                var html = app.templates["template-thumbnail"](imageIds[index]);
                html = $(html);
                if (app.isSelectImageId(imageIds[index])) {
                    html.addClass('selection');
                }
                return html[0];
            },
            cellSize: function() {
                var oneCell = app.templates["template-thumbnail"](imageIds[0]);
                oneCell = $(oneCell);
                oneCell.removeAttr('id');
                $(".collection-view-one-cell").html(oneCell);
                return {
                    width: oneCell.width() + 5,
                    height: oneCell.height() + 5
                }
            },
            alignItems: function() {
                return 'left'
            }
        }
        app.collectionView = collection;
        app.mainContainer.html(collection.html());
        app.lazyloadImages();
    },
    onscroll : function() {
        if (app.mode == 'image') {
            app.lazyloadImages();
        }
    },
    pageY: function(El) {
          var top = 0;
          do {
            top += El.offsetTop;
          } while(El.offsetParent && (El = El.offsetParent).nodeName.toUpperCase() != 'BODY');
          return top;
    },
    lazyloadImages: function() {
        app.collectionView.reloadData();
    },
    /// 加载照片文件夹
    loadImageFolders: function() {
        app.paths = [];
        app.paths.push('全部相册');
        if (app.imageFolders) {
            var html = app.templates['template-image-folders']({folders: app.imageFolders});
            app.mainContainer.html(html);
            app.mainContainer.addClass('has-breadcrumb');
            var breadcrumb = app.templates['template-breadcrumb'](app.paths);
            app.mainContainerToolbar.html(breadcrumb);
        }
        $.getJSON('/images/folders', function(res){
            console.log("res code " + res["code"]);
            console.log(res);
            if (res["code"] == 0) {
                if (app.mode != 'image') {
                    return;
                }
                app.imageFolders = res.folders;
                console.log("render folders");
                var html = app.templates['template-image-folders'](res);
                app.mainContainer.html(html);
                app.mainContainer.addClass('has-breadcrumb');
                console.log(app.paths);
                var breadcrumb = app.templates['template-breadcrumb'](app.paths);
                app.mainContainerToolbar.html(breadcrumb);
            } else {
                app.handleError(res);
            }
        });
    },
    loadFiles: function(path) {
        console.log("path: " + path);
        var sortBy = localStorage.getItem("sortBy") || '0';
        var sortOrder = localStorage.getItem("sortOrder" + sortBy) || '1';
        var layoutStyle = localStorage.getItem("layoutStyle") || "list";
        var showHiddenFiles = localStorage.getItem("showHiddenFiles") == 'true'
        console.log('loadFiles showHiddenFiles2 ' + showHiddenFiles);
        
        for (var k = 0; k < 3; k++) {
            var value = k;
            var order = localStorage.getItem("sortOrder" + value);
            console.log("sortOrder" + value + " value=" + order);
            var tabItem = app.sortByTabBar.getTabItem(value);
            var i = $("i", tabItem);
            console.log(i);
            if (order == '0') {
                i.removeClass('icondown');
                i.addClass('iconup')
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
            }
        }
        app.sortByTabBar.select(sortBy);1
        $.getJSON('/path', {
            path: path,
            sortBy: sortBy,
            sortOrder: sortOrder,
            showHiddenFiles: showHiddenFiles
        },function(res){
            console.log("res code " + res["code"]);
            console.log(res);
            if (res["code"] == 0) {
                app.currentFolder = res;
                app.lastPath = path;
                var paths = res.path.split('/');
                if (!paths) {
                    app.paths = "首页";
                } else {
                    app.paths = paths;
                    if (!app.paths[0]) {
                        app.paths[0] = "首页";
                    }
                }
                var html;
                if (layoutStyle == 'list') {
                    html = app.templates['template-folders-list-new'](res);
                } else {
                    html = app.templates['template-folders'](res);
                }
                var breadcrumb = app.templates['template-breadcrumb'](app.paths);
                app.mainContainer.addClass('has-breadcrumb');
                app.mainContainer.html(html);
                // app.mainContainer.prepend(breadcrumb);
                app.mainContainerToolbar.html(breadcrumb);
                $("#new-folder-icon").show();
                var icon = $('.layout-style-btn i');
                if (layoutStyle == 'grid') {
                    icon.removeClass("fa-th");
                    icon.addClass('fa-th-list');
                } else {
                    icon.addClass("fa-th");
                    icon.removeClass('fa-th-list');
                }

                var showHideFileIcon = $('.show-hidden-files i');
                console.log('showHiddenFiles == true ' + (showHiddenFiles == true));
                if (showHiddenFiles) {
                    showHideFileIcon.addClass("fa-eye");
                    showHideFileIcon.removeClass('fa-eye-slash');
                } else {
                    showHideFileIcon.removeClass("fa-eye");
                    showHideFileIcon.addClass('fa-eye-slash');
                }

                $('#breadcrumb-wrapper .right-icon').css('visibility', 'visible');

                // $('#show-hidden-files').prop('checked', showHiddenFiles)
                var preScroll = app.preScrollTop[path];
                console.log("path=" + path + " pre scorll=" + preScroll);
                if (preScroll) {
                    document.getElementById('main-container-content').scrollTop = app.preScrollTop[path];
                } else {
                    document.getElementById('main-container-content').scrollTop = 0;
                }
                
            } else {
                app.handleError(res);
            }
        });
    },
    loadVideos: function(path) {
        app.mainContainer.removeClass('has-breadcrumb');
        app.mainContainer.html('');
        app.mainContainerToolbar.html('');
        var data = {};
        if (path) {
            data.path = path;
            app.paths = ["首页", app.currentFolder.name];
            console.log('app paths');
            console.log(app.currentFolder);
            console.log(app.paths);
        }
        $.getJSON('/videos',data, function(res) {
            console.log(res);
            if (res["code"] == 0) {
                if (app.mode != 'video') {
                    return;
                }
                if (res.videoList.length > 0) {
                    app.currentFolder = res;
                    var html = app.templates['template-video'](res);
                    app.mainContainer.html(html);
                    if (path) {
                        app.mainContainer.addClass('has-breadcrumb');
                        var breadcrumb = app.templates['template-breadcrumb'](app.paths);
                        app.mainContainerToolbar.html(breadcrumb);
                    }
                } else {
                    app.mainContainer.html("<h1>没有视频</h1>");
                }
            } else {
                app.handleError(res);
            }
        });
    },
    loadVideoFolders: function() {
        $.getJSON('/video/folders', function(res) {
            console.log(res);
            if (res["code"] == 0) {
                app.currentFolder = res;
                var html = app.templates['template-video-folders'](res);
                app.mainContainer.html(html);
                app.mainContainerToolbar.html('');
            } else {
                app.handleError(res);
            }
        });
    },
    loadMusicList: function(path) {
        var sortBy = localStorage.getItem("music-sortBy") || '0';
        var sortOrder = localStorage.getItem("music-sortOrder" + sortBy) || '1';
        for (var k = 0; k < 4; k++) {
            var value = k;
            var order = localStorage.getItem("music-sortOrder" + value);
            console.log("music-sortOrder" + value + " value=" + order);
            var tabItem = app.musicTabBar.getTabItem(value);
            var i = $("i", tabItem);
            console.log(i);
            if (order == '0') {
                i.removeClass('icondown');
                i.addClass('iconup')
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
            }
        }
        var data = {
            sortBy: sortBy,
            sortOrder: sortOrder,
        };
        $.getJSON('/musics',data, function(res) {
            console.log(res);
            if (res["code"] == 0) {
                if (app.mode != 'music') {
                    return;
                }
                if (res.children.length > 0) {
                    app.currentFolder = res;
                    var html = app.templates['template-music-list-table'](res);
                    app.mainContainer.html(html);
                    app.mainContainerToolbar.html("");
                    if (path) {
                        app.mainContainer.addClass('has-breadcrumb');
                        var breadcrumb = app.templates['template-breadcrumb'](app.paths);
                        app.mainContainerToolbar.html(breadcrumb);
                    }
                } else {
                    app.mainContainer.html("<h1>没有音乐</h1>");
                }
            } else {
                app.handleError(res);
            }
        });
    },
    loadClipboard: function() {
        console.log("loadClipboard");
        var html = app.templates['template-clipboard']();
        app.mainContainer.html(html);
        app.mainContainerToolbar.html('');

        for (var i = 0; i < app.clipboardDatas.length; i++) {
            var data = app.clipboardDatas[i];
            if (data.from == 'phone') {
                var itemData = app.templates['template-clipboard-item-from-phone'](data);
                $(".timeline").append(itemData);
            } else {
                var itemData = app.templates['template-clipboard-item-from-pc'](data);
                $(".timeline").append(itemData);
            }
        }
        document.body.scrollTop = document.body.scrollHeight;
    },
    loadDocuments: function(fileType) {
        console.log('loadDocuments fileType=' + fileType);
        var sortBy = localStorage.getItem("document-sortBy") || '0';
        var sortOrder = localStorage.getItem("document-sortOrder" + sortBy) || '1';

        for (var k = 0; k < 3; k++) {
            var value = k;
            var order = localStorage.getItem("document-sortOrder" + value);
            console.log("sortOrder" + value + " value=" + order);
            var tabItem = app.documentTabBar.getTabItem(value);
            var i = $("i", tabItem);
            console.log(i);
            if (order == '0') {
                i.removeClass('icondown');
                i.addClass('iconup')
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
            }
        }
        console.log('sortBy=' + sortBy)
        app.documentTabBar.select(sortBy);

        app.mainContainerToolbar.html('');
        app.mainContainer.removeClass('has-breadcrumb');
        app.mainContainer.html('');

        $.getJSON('/documents', {
            sortBy: sortBy,
            sortOrder: sortOrder,
            fileType: fileType
        },function(res){
            console.log("res code " + res["code"]);
            console.log(res);
            if (res["code"] == 0) {
                app.currentFolder = res;
                var html = app.templates['template-folders-list-new'](res);
                app.mainContainer.html(html);
            } else {
                app.handleError(res);
            }
        });
    },
    search: function(filename) {
        app.searchContent = filename;
        console.log("search: " + filename);
        var sortBy = localStorage.getItem("sortBy") || '0';
        var sortOrder = localStorage.getItem("sortOrder" + sortBy) || '1';
        
        for (var k = 0; k < 3; k++) {
            var value = k;
            var order = localStorage.getItem("sortOrder" + value);
            console.log("sortOrder" + value + " value=" + order);
            var tabItem = app.sortByTabBar.getTabItem(value);
            var i = $("i", tabItem);
            console.log(i);
            if (order == '0') {
                i.removeClass('icondown');
                i.addClass('iconup')
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
            }
        }
        app.sortByTabBar.select(sortBy);

        $.getJSON('/search', {
            filename: filename,
            sortBy: sortBy,
            sortOrder: sortOrder
        },function(res){
            console.log("res code " + res["code"]);
            console.log(res);
            if (res["code"] == 0) {
                app.currentFolder = res;
                app.searchResult = res;
                var html = app.templates['template-folders-list-new'](res);
                app.mainContainer.html(html);
            } else {
                app.handleError(res);
            }
        });
    },
    isSelectImageId: function(imageId) {
        for (var i = 0; i < app.selectionArr.length; i++) {
            if (app.selectionArr[i] == imageId) {
                return true;
            }
        }
        return false;
    },
    imageCellClick: function(imageId) {
        console.log("click " + imageId);
        if ($('body').hasClass('selection-mod')) {
            app.checkCell(imageId);
            return;
        }
        var html = app.templates["template-preview"](imageId);
        $('body').append(html);
        app.imagePreview = new ImagePreview($('.image-preview-container'), app.imageIds);
        app.imagePreview.loadImage(imageId);
    },
    closePreview: function() {
        $('.image-preview-container').remove();
        app.imagePreview = null;
    },
    checkCell: function(id) {
        if (app.mode == 'image') {
            var imageId = id;
            console.log('checkCell ' + imageId);
            var cell = $("#cell-id-"+imageId);
            // $("i", cell).toggleClass('checked');
            cell.toggleClass('selection');
            if (cell.hasClass('selection')) {
                app.selectionNum += 1;
                app.selectionArr.push(imageId);
            } else {
                app.selectionNum -= 1;
                for (var i = 0; i < app.selectionArr.length; i++) {
                    if (app.selectionArr[i] == imageId) {
                        app.selectionArr.splice(i, 1);
                        break;
                    }
                }
            }
        } else if (app.mode == 'files' || app.mode =='download' || app.mode == 'fft' || app.mode == 'music' || app.mode == 'document' || app.mode == 'search') {
            console.log('checkCell ' + id);
            var cell = $("#folder-id-" + id);
            cell.toggleClass('selection');
            cell.parent().toggleClass('selection');
            cell.prop('checked', cell.hasClass('selection'));
            if ( $('.file-list input').length > 0) {
                cell.parent().parent().toggleClass('selection');
            }
            if (cell.hasClass('selection')) {
                app.selectionNum += 1;
                app.selectionArr.push(id);
            } else {
                app.selectionNum -= 1;
                for (var i = 0; i < app.selectionArr.length; i++) {
                    if (app.selectionArr[i] == id) {
                        app.selectionArr.splice(i, 1);
                        break;
                    }
                }
            }
        } else if (app.mode == 'video') {
            var cell = $("#cell-id-" + id);
            cell.toggleClass('selection');
            if (cell.hasClass('selection')) {
                app.selectionNum += 1;
                app.selectionArr.push(id);
            } else {
                app.selectionNum -= 1;
                for (var i = 0; i < app.selectionArr.length; i++) {
                    if (app.selectionArr[i] == id) {
                        app.selectionArr.splice(i, 1);
                        break;
                    }
                }
            }
        }
        $('.action-bar-title span').text("" + app.selectionNum);
        // $('.nav-download').text("下载(" + app.selectionNum + ")");
        // $('.nav-delete-file').text("删除(" + app.selectionNum + ")");
        if (app.selectionNum >0 ) {
            if (!$('body').hasClass('selection-mod')) {
                $('body').addClass('selection-mod');
            }
        } else {
            $('body').removeClass('selection-mod');
        }
    },
    selectAll: function() {
        app.selectionArr = [];
        if (app.mode == 'image') {
            if (app.submode == 'images') {
                for (var i = 0; i < app.imageIds.length; i++) {
                    app.selectionArr.push(app.imageIds[i]);
                }
            } else {
                var arr = app.imageFolders[app.folderIndex].imageIds;
                for (var i = 0; i < arr.length; i++) {
                    app.selectionArr.push(arr[i]);
                }
            }
        } else if (app.mode == 'video') {
            if ($('.image-folder-cell').length == 0) {
                console.log('videos');
                // app.selectionArr.push(1);
                // app.selectionArr.push(2);
                for (var i = 0; i < app.currentFolder.videoList.length; i++) {
                    app.selectionArr.push(i);
                }
            } else {
                console.log('video folder');
                for (var i = 0; i < app.currentFolder.children.length; i++) {
                    app.selectionArr.push(i);
                }
            }
        } else if (app.mode == 'music') {
            $('.music-list input').prop('checked', true);
            $('.music-list input').addClass('selection');
            for (var i = 0; i < app.currentFolder.children.length; i++) {
                app.selectionArr.push(i);
            }
        } else if (app.mode == 'files' || app.mode == 'download' || app.mode == 'fft' || app.mode == 'document' || app.mode == 'search') {
            for (var i = 0; i < app.currentFolder.children.length; i++) {
                app.selectionArr.push(i);
            }
        }
        
        app.selectionNum = app.selectionArr.length;
        $('.image-cell').addClass('selection');
        // $('.image-cell').parent().addClass('selection');
        $('body').addClass('selection-mod');
        $('.action-bar-title span').text("" + app.selectionNum);
        // $('.nav-download').text("下载(" + app.selectionNum + ")");
        if ( $('.file-list input')) {
            $('.file-list input').prop('checked', true);
            $('.file-list input').addClass('selection');
            $('.file-list input').parent().parent().addClass('selection');
        }
    },
    cancelSelection: function() {
        app.selectionArr = [];
        app.selectionNum = app.selectionArr.length;
        $('.folder-cell').removeClass('selection');
        $('.image-cell').removeClass('selection');
        $('.image-cell').parent().removeClass('selection');
        $('body').removeClass('selection-mod');
        $('.file-list input').prop('checked', false);
        $('.file-list input').removeClass('selection');
        $('.file-list input').parent().parent().removeClass('selection');
        if (app.mode == 'music') {
            $('.music-list input').prop('checked', false);
            $('.music-list input').removeClass('selection');
        }
    },
    downloadSelected: function() {
        if (app.mode == 'image') {
            var folderCells = $('.image-folder-cell');
            if (folderCells.length == 0) {
                console.log('downloadSelectedImage');
                console.log(app.selectionArr);
                var data = {
                    "imageIds": app.selectionArr
                };
                var dataStr = JSON.stringify(data);
                $.ajax({
                    url: '/images/download',
                    type: 'POST',
                    dataType: 'json',
                    contentType: 'application/json',
                    data: dataStr,
                    success: function(res) {
                        console.log('download return');
                        console.log(res);
                        if (res.code == 0) {
                            window.location.href = "/images/download?id="+res.id;
                        }
                    }
                });
            } else { // 下载文件夹压缩包
                var downloadFolder = [];
                for (var i = 0; i < app.selectionArr.length; i++) {
                    downloadFolder.push(app.imageFolders[app.selectionArr[i]].folderName);
                }
                var dataStr = JSON.stringify(downloadFolder);
                console.log(dataStr);
                $.ajax({
                    url: '/images/folder/download',
                    type: 'POST',
                    dataType: 'json',
                    contentType: 'application/json',
                    data: dataStr,
                    success: function(res) {
                        console.log('download return');
                        console.log(res);
                        if (res.code == 0) {
                            window.location.href = "/images/folder/download?id="+res.id;
                        }
                    }
                });
            }
        } else if (app.mode == 'files' || app.mode == 'music' || app.mode == 'download' || app.mode == 'fft' || app.mode == 'document' || app.mode == 'search') {
            var paths = [];
            for (var i = 0; i < app.selectionArr.length; i++) {
                paths.push(app.currentFolder.children[app.selectionArr[i]].absoultePath);
            }
            var data = {
                paths: paths,
                basePath: app.currentFolder.absoultePath
            }
            var dataStr = JSON.stringify(data);
            $.ajax({
                'url': '/file/download',
                'type': 'POST',
                'dataType': 'json',
                'contentType': 'application/json',
                data: dataStr,
                success: function(res) {
                    console.log('download file return');
                    console.log(res);
                    if (res.code == 0) {
                        window.location.href = '/file/download?id=' + res.id;
                    }
                }
            });
        } else if (app.mode == 'video') {
            var paths = [];
            for (var i = 0; i < app.selectionArr.length; i++) {
                var index = app.selectionArr[i];
                if (app.submode == 'videos') {
                    paths.push(app.currentFolder.videoList[index].absoultePath);
                } else {
                    paths.push(app.currentFolder.videoList[index].absoultePath);
                }
            }
            var data = {
                paths: paths,
                type: "video"
            }
            var dataStr = JSON.stringify(data);
            $.ajax({
                'url': '/file/download',
                'type': 'POST',
                'dataType': 'json',
                'contentType': 'application/json',
                data: dataStr,
                success: function(res) {
                    console.log('download file return');
                    console.log(res);
                    if (res.code == 0) {
                        window.location.href = '/file/download?id=' + res.id;
                    }
                }
            });
        }
        
    },
    deleteFile: function() {
        var ret = confirm("确认删除吗？");
        if (!ret) {
            return;
        }
        if (app.mode == 'image') {
            var folderCells = $('.image-folder-cell');
            var data = null;
            if (folderCells.length > 0) {
                var deleteIds = [];
                for (var i = 0; i < app.selectionArr.length; i++) {
                    var folder = app.imageFolders[app.selectionArr[i]];
                    for (var j = 0; j < folder.imageIds.length; j++) {
                        deleteIds.push(folder.imageIds[j]);
                    }
                }
                console.log(deleteIds);
                data = {
                    type: "images",
                    imageIds: deleteIds
                };
            } else {
                console.log('downloadSelectedImage');
                console.log(app.selectionArr);
                data = {
                    type: "images",
                    imageIds: app.selectionArr
                };
            }

            var dataStr = JSON.stringify(data);
            $.ajax({
                url: '/deleteFile',
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json',
                data: dataStr,
                success: function(res) {
                    console.log(res);
                    alert(res.message);
                    setTimeout(function(){
                        app.reload();
                    }, 1000);
                    
                }
            });

        } else if (app.mode == 'files' || app.mode == 'music' || app.mode == 'download' || app.mode == 'fft' || app.mode == "document" || app.mode == 'search') {
            var paths = [];
            for (var i = 0; i < app.selectionArr.length; i++) {
                paths.push(app.currentFolder.children[app.selectionArr[i]].absoultePath);
            }
            var data = {
                type: "files",
                paths: paths
            }
            var dataStr = JSON.stringify(data);
            $.ajax({
                'url': '/deleteFile',
                'type': 'POST',
                'dataType': 'json',
                'contentType': 'application/json',
                data: dataStr,
                success: function(res) {
                    console.log(res);
                    alert(res.message);
                    setTimeout(function(){
                        app.reload();
                    }, 1000);
                }
            });
        } else if (app.mode == 'video') {
            var paths = [];
            for (var i = 0; i < app.selectionArr.length; i++) {
                var index = app.selectionArr[i];
                if (app.submode == 'videos') {
                    paths.push(app.currentFolder.videoList[index].absoultePath);
                } else {
                    var folderCells = $('.image-folder-cell');
                    if (folderCells.length > 0) {
                        for (var j = 0; j < app.currentFolder.children[index].children.length; j++) {
                            paths.push(app.currentFolder.children[index].children[j].absoultePath);
                        }
                    } else {
                        paths.push(app.currentFolder.videoList[index].absoultePath);
                    }
                }
            }
            console.log(paths);
            var data = {
                paths: paths,
                type: "files"
            }
            var dataStr = JSON.stringify(data);
            $.ajax({
                'url': '/deleteFile',
                'type': 'POST',
                'dataType': 'json',
                'contentType': 'application/json',
                data: dataStr,
                success: function(res) {
                    console.log(res);
                    alert(res.message);
                    setTimeout(function(){
                        app.reload();
                    }, 1000);
                }
            });
        }
        
    },
    filechanged: function() {
        var files = $('#files')[0].files;
        app.startUploadFiles(files);
    },
    showUploadDialog: function() {
        $('#upload-modal').modal({'backdrop': 'static', 'show': false});
        $('.uploading').show();
        $('.upload-finish').hide();
        $('#upload-cancel').show();
        $('#upload-finish').hide();
        $('#upload-modal').modal('show');
    },
    initUpload: function(multiFilesUpload, folderName) {
        app.uploadingInfo = {
            oneFileUploadedSize: 0, // 目前上传中的文件已上传的大小
            uploadedSize: 0,        // 全部文件已上传的大小
            totalSize: 0,           // 总共大小
            uploadingName: "",      // 名字
            uploadingSize: "",      // 上传文件的大小
            uploadingState: "inited",    // 上传状态, uploading, dealing, done
            fileNum: 0,             // 文件数量
            uploadedNum: 0,         // 已上传的数量
            speed: 0,                // 上传速度
            prevUploadedSize: 0,      // 上一次上传的大小，用来计算速度
            timeUsed: 0,             // 用时
            timeRemain: 0,           // 剩下时间
            folderName: folderName,   // 上传的文件夹
            multiFilesUpload: multiFilesUpload  // 是否是多文件上传
        };
    },
    startUploadFiles: function(files) {
        app.showUploadDialog();
        app.initUpload();
        
        app.uploadingInfo.fileNum = files.length;
        for (var i = 0; i < files.length; i++) {
            app.uploadFiles.push({
                file: files[i],
                path: app.currentFolder && app.currentFolder.absoultePath
            });
            app.uploadingInfo.totalSize += files[i].size;
        }
        console.log("files size " + app.uploadingInfo.totalSize);
        $('#files').val("");
        app.updateUploadDialog();
        app.nextFile();
    },
    addToUpload: function(file, path) {
        console.log("addToUpload filename:" + file.name + " path:" + path);
        var p = app.currentFolder && app.currentFolder.absoultePath;
        p = p || app.appPath;
        path = p + path;
        app.uploadFiles.push({
            file: file,
            path: path
        });
        app.uploadingInfo.totalSize += file.size;
        app.uploadingInfo.fileNum = app.uploadFiles.length;
        if (app.uploadingInfo.uploadingState == 'inited') {
            console.log("开始上传 ");
            app.uploadingInfo.uploadingState == 'started';
            app.updateUploadDialog();
            app.nextFile();
        }
    },
    nextFile: function() {
        if (app.uploadFiles.length > 0) {
            var fileInfo = app.uploadFiles[0];
            var file = fileInfo.file;
            app.uploadFiles.splice(0,1);
            if (file) {
                var size = file.size;
                if (size > 1024 * 1024 * 1024) {
                    size = (Math.round(file.size * 100 / (1024 * 1024 * 1024)) / 100).toString() + 'GB';
                } else if (size > 1024 * 1024) {
                    size = (Math.round(file.size * 100 / (1024 * 1024)) / 100).toString() + 'MB';
                } else {
                    size = (Math.round(file.size * 100 / 1024) / 100).toString() + 'KB';
                }
                app.uploadingInfo.uploadingSize = size;
                // app.uploadFile(file);
                app.upload(fileInfo);
            }
        }
    },
    updateUploadDialog: function() {
        console.log(app.uploadingInfo);
        if (app.uploadingInfo.uploadedNum == app.uploadingInfo.total) {
            $('#upload-modal').modal('hide');
        }
        var stateStr = "正在上传: ";
        if (app.uploadingInfo.uploadingState == "done") {
            stateStr = "已完成: ";
        }
        $(".uploading-name").text(stateStr + app.uploadingInfo.uploadingName + " (" + app.uploadingInfo.uploadingSize + ")");
        $(".upload-num").text('已上传: ' + app.uploadingInfo.uploadedNum + " 共: " + app.uploadingInfo.fileNum);
        var percent = Math.round((app.uploadingInfo.uploadedSize + app.uploadingInfo.oneFileUploadedSize) / app.uploadingInfo.totalSize * 100);
        console.log("percent " + percent);
        $(".progress-bar").css('width', percent + "%");
        $(".upload-speed").text("速度: " + app.uploadingInfo.speed + " 用时: " + app.uploadingInfo.timeUsed + " 剩余时间: " + app.uploadingInfo.timeRemain);
    },
    uploadFinish: function(msg) {
        clearInterval(app.timerHandle);
        app.timerHandle = 0;
        $('.uploading').hide();
        console.log($('.location'));
        var message = msg.message;
        // 多文件上传的话，只显示保存的目录名字
        if (app.uploadingInfo.multiFilesUpload) {
            var folder = ((app.currentFolder && app.currentFolder.absoultePath) || app.appPath);
            message = folder;            
        }
        $('.location').html(message + "</br>" + "用时: " + app.uploadingInfo.timeUsed);
        $('.upload-finish').show();
        $('#upload-cancel').hide();
        $('#upload-finish').show();

        console.log("app.mode=" + app.mode);
        setTimeout(function(){
            app.reload();
        }, 100);
    },
    startCheckSpeed: function() {
        // 定时器检查速度
        app.timerCount = 0;
        app.timerHandle = setInterval(app.checkSpeed, 1000);
    },
    stopCheckSpeed: function() {
        clearInterval(app.timerHandle);
        app.timerHandle = 0;
    },
    checkSpeed: function() {
        app.timerCount += 1;

        var speed = (app.uploadingInfo.uploadedSize + app.uploadingInfo.oneFileUploadedSize) - app.uploadingInfo.prevUploadedSize;
        var remainSize = app.uploadingInfo.totalSize - (app.uploadingInfo.uploadedSize + app.uploadingInfo.oneFileUploadedSize);
        // console.log("remainSize " + remainSize + " speed " + speed);
        var remainSecond = Math.round(remainSize / (speed + 1));
        app.uploadingInfo.timeRemain = app.formatSecond(remainSecond);
        app.uploadingInfo.prevUploadedSize = app.uploadingInfo.uploadedSize + app.uploadingInfo.oneFileUploadedSize;
        if (speed > 1024 * 1024) {
            speed = (Math.round(speed *100 / (1024 * 1024)) / 100).toString() + " MB/s";
        } else {
            speed = (Math.round(speed * 100 / 1024) / 100).toString() + " KB/s";
        }
        app.uploadingInfo.speed = speed;
        // 用时
        app.uploadingInfo.timeUsed = app.formatSecond(app.timerCount);
        app.updateUploadDialog();
    },
    formatSecond: function(seconds) {
        var minute = Math.floor(seconds / 60);
        var second = seconds - minute * 60;
        var hour = Math.floor(minute / 60);
        minute = Math.floor(minute - hour * 60);
        return (hour < 10 ? "0" + hour : hour) + ":" + (minute < 10 ? "0" + minute: minute) + ":" + (second < 10? "0" + second: second);
    },
    upload: function(fileInfo) {
        console.log(fileInfo);
        var file = fileInfo.file;
        app.uploadingInfo.uploadingName = file.name;
        app.uploadingInfo.uploadingState = "uploading";
        var reader = new FileReader();
        var CHUNK_SIZE = 50 * 1024 * 1024;   // 50M
        var start = 0;
        var part = 1;
        function seek() {
            var chunkSize = CHUNK_SIZE;
            if (start + chunkSize > file.size) {
                chunkSize = file.size - start;
            }
            var end = start + chunkSize;
            var slice = file.slice(start, end);
            console.log("slice size: " + slice.size);
            reader.readAsArrayBuffer(slice);
            start += chunkSize;
        }
        reader.onloadstart = function() {
            console.log("onloadstart");
            app.stopCheckSpeed();
        }
        reader.onprogress = function() {
            console.log("onprogress")
        }
        reader.onload = function() {
            app.startCheckSpeed();
            console.log("onload " + reader.result.length);
            var xhr = new XMLHttpRequest();
            var url = "/upload";
            xhr.open("POST", url);
            xhr.setRequestHeader("Content-Type", "application/octet-stream");
            xhr.setRequestHeader("fname", encodeURIComponent(file.name));
            xhr.setRequestHeader("part", part);
            if (fileInfo.path) {
                xhr.setRequestHeader("path", encodeURIComponent(fileInfo.path))
            }
            if (app.uploadingInfo.folderName) {
                xhr.setRequestHeader("folder", encodeURIComponent(app.uploadingInfo.folderName))
            }
            // 最后一个分片
            if (start >= file.size) {
                xhr.setRequestHeader('last', 'true')
            }
            xhr.onreadystatechange = function() {
                if (xhr.readyState == XMLHttpRequest.DONE) {
                    if (xhr.status == 200) {
                        var json = xhr.responseText;
                        var res = JSON.parse(json);
                        console.log(res);
                        if (res.code == 0) {
                            if (start < file.size) {
                                console.log("上传下一个分片 start: " + start + " size:" + file.size);
                                part += 1;
                                seek();
                            } else {
                                app.uploadingInfo.uploadingState = "done";
                                if (app.uploadFiles.length == 0) {
                                    app.uploadFinish(res);
                                } else {
                                    app.uploadingInfo.uploadedNum += 1;
                                    app.nextFile();
                                    app.updateUploadDialog();
                                }
                            }
                        } else {
                            app.stopCheckSpeed();
                            $('.uploading').hide();
                            $('.upload-finish').show();
                            $('#upload-cancel').hide();
                            $('#upload-finish').show();
                        }
                    }
                }
            }
            xhr.upload.addEventListener('progress', function(event) {
                if (event.lengthComputable) {
                    // console.log(event);
                    // console.log('uploaded: ' + event.loaded + ' total: ' + app.uploadingInfo.totalSize);
                    app.uploadingInfo.oneFileUploadedSize = event.loaded;
                    if (event.loaded === event.total) {
                        app.uploadingInfo.uploadedSize += app.uploadingInfo.oneFileUploadedSize;
                        app.uploadingInfo.oneFileUploadedSize = 0;
                        if (app.uploadingInfo.uploadedSize > app.uploadingInfo.totalSize) {
                            app.uploadingInfo.uploadedSize = app.uploadingInfo.totalSize
                        }
                    }
                    app.updateUploadDialog();
                }
            }, false);
            xhr.addEventListener('error', function(event) {
                console.log('upload error.');
                console.log(event);
                app.stopCheckSpeed();
                $('.uploading').hide();
                $('.location').html("连接失败或没有文件写入权限");
                $('.upload-error').show();
                $('#upload-cancel').hide();
                $('#upload-finish').show();
            });
            xhr.send(reader.result);
            $('#upload-modal').on('hide.bs.modal', function(event) {
                xhr.abort();
                app.uploadFiles = [];
                clearInterval(app.timerHandle);
            });
        }
        seek();
    },
    selectNavItem: function(ele,index) {
        $('#sidebar-page li').removeClass('active');
        $(ele).parent().addClass('active');
        if (index == 0) {
            app.setMode('image');
        } else if (index == 1) {
            app.setMode('video');
        } else if (index == 2) {
            app.setMode('music');
        } else if (index == 3) {
            app.setMode('download');
        } else if (index == 4) {
            app.setMode('files', null, '/');
        } else if (index == 5) {
            app.setMode('fft');
        } else if (index == 6) {
            app.setMode("clipboard");
        } else if (index == 7) {
            app.setMode("document", DOCUMENT_FILE);
        } else if (index == 8) {
            app.setMode("document", ZIP_FILE);
        } else if (index == 9) {
            app.setMode("document", APK_FILE);
        } else if (index == 10) {
            app.setMode("search");
        }
        if ($('.cover').css("display") == 'block') {
            $('.cover').click();
        }
    },
    /// 切换模式
    setMode:function(mode, submode, path) {
        console.log('setMode ' + mode);
        $('#toolbar').html('');
        $('#search-input').hide();
        app.sortByTabBar.hide();
        app.musicTabBar.hide();
        app.documentTabBar.hide();
        app.mode = mode;
        app.currentFolder = null;
        if (mode == 'image') {
            app.submode = 'images';
            app.loadImages();
            app.getTemplate('/static/template/photo-tab.html', function(template) {
                $('#toolbar').html(template());
            });
            // $('#toolbar').append(app.templates['template-image-tools']())
        } else if (mode == 'video') {
            app.submode = 'videos';
            app.loadVideos();
            app.getTemplate('/static/template/video-tab.html', function(template) {
                $('#toolbar').html(template());
            });
            // $('#toolbar').append(app.templates['template-video-tools']())
        } else if (mode == 'music') {
            app.musicTabBar.show();
            app.loadMusicList();
        } else if (mode == 'download') {
            app.sortByTabBar.show();
            app.loadFiles('/download');
        } else if (mode == 'files') {
            app.sortByTabBar.show();
            app.loadFiles(path || '/');
        } else if (mode == 'fft') {
            app.sortByTabBar.show();
            app.loadFiles('/FFT');
        } else if (mode == 'clipboard') {
            app.loadClipboard();
        } else if (mode == 'document') {
            console.log("submode=" + submode);
            this.fileType = submode;
            app.documentTabBar.show();
            app.loadDocuments(this.fileType);
        } else if (mode == 'search') {
            $('#search-input').show();
            app.sortByTabBar.show();
            app.mainContainer.html('');
            app.mainContainerToolbar.html('');
            var sortBy = localStorage.getItem("sortBy") || '0';
            app.sortByTabBar.select(sortBy);
            if (app.searchResult) {
                app.currentFolder = app.searchResult;
                var html = app.templates['template-folders-list-new'](app.searchResult);
                app.mainContainer.html(html);
            }
        }

        app.cancelSelection();
    },
    setSubmode: function(submode, ele) {
        app.submode = submode;
        if (app.mode == 'image') {
            if (submode == 'images') {
                app.loadImages();
            } else if (submode == 'folders') {
                app.loadImageFolders();
            }
        } else if (app.mode == 'video') {
            if (submode == 'videos') {
                app.loadVideos();
            } else if (submode == 'folders') {
                app.loadVideoFolders();
            }
        }
        if (ele) {
            $('.btn-group button').removeClass('active');
            $(ele).addClass('active');
        }
        app.cancelSelection();
    },
    clickImageFolder: function(index, ele) {
        console.log('clickImageFolder');
        console.log(app.imageFolders[index]);
        if ($('body').hasClass('selection-mod')) {
            app.checkCell(index);
            return;
        }

        app.folderStack.push(index);
        app.folderIndex = index;
        app.paths.push(app.imageFolders[index].folderName);
        app.currentFolder = app.imageFolders[index];
        var breadcrumb = app.templates['template-breadcrumb'](app.paths);
        app.mainContainerToolbar.html(breadcrumb);

        this.layoutImages(app.imageFolders[index].imageIds);
    },
    clickBreadcrumb: function(index) {
        console.log('clickBreadcrumb index ' + index);

        if (app.mode == 'image') {
            var pathLen = app.paths.length || 0;
            if (index == 0) {
                app.loadImageFolders();
            }
            else if (index < pathLen) {
                var i = app.folderStack[index-1];
                app.folderStack.splice(index, app.folderStack.length - (index-1));
                app.paths.splice(index+1, pathLen - (index-1));
                app.clickImageFolder(i);
            }
        } else if (app.mode == 'files' || app.mode == 'download' || app.mode == 'fft') {
            var rootPath = app.currentFolder.rootPath;
            if (rootPath[rootPath.length-1] != '/') {
                rootPath += '/';
            }
            var path = "";
            for (var i = 1; i <= index; i++) {
                path += app.paths[i];
                if (i < index) {
                    path += '/';
                }
            }
            app.loadFiles(rootPath + path);
        } else if (app.mode == 'video') {
            app.loadVideoFolders();
            app.mainContainer.removeClass('has-breadcrumb');
        }
    },
    clickFolder: function(index, ele) {
        if ($('body').hasClass('selection-mod')) {
            app.checkCell(index);
            return;
        }
        var child = app.currentFolder.children[index];
        console.log('path current=' + app.currentFolder.absoultePath)
        if (child && child.isFolder) {
            // 点击搜索出来的文件夹，模式切换到全部文件
            if (app.mode != 'files') {
                app.setMode('files', null, child.absoultePath);
                $('#sidebar-page li').removeClass('active');
                $('.tab-files').addClass('active');
                return;
            }
            var scrollTop = document.getElementById('main-container-content').scrollTop; // 滚动高度
            app.preScrollTop[app.currentFolder.absoultePath + "/"] = scrollTop;
            app.preScrollTop[app.currentFolder.absoultePath] = scrollTop;
            console.log("pre scroll=" + scrollTop);
            app.loadFiles(child.absoultePath);
        } else {
            var href = "/file?path=" + encodeURIComponent(child.absoultePath);
            var hideA = '<a id="filedownload" target="_blank" href="' + href +'" style="display:none;">文件下载</a>';
            $('body').append(hideA);

            setTimeout(function(){
                console.log('click filedownload');
                document.getElementById('filedownload').click();
                $('#filedownload').remove();
            }, 500);
        }
    },
    videoClick: function(index) {
        if ($('body').hasClass('selection-mod')) {
            app.checkCell(index);
            return;
        }
        var path = app.currentFolder.videoList[index].absoultePath;
        app.openInNewTab("/file?path=" + encodeURIComponent(path));
    },
    musicClick: function(index) {
        if ($('body').hasClass('selection-mod')) {
            app.checkCell(index);
            return;
        }
        var path = app.currentFolder.children[index].absoultePath;
        app.openInNewTab("/file?path=" + encodeURIComponent(path));
    },
    openInNewTab:function(href) {
        var hideA = '<a id="filedownload" target="_blank" href="' + href +'" style="display:none;">文件下载</a>';
        $('body').append(hideA);

        setTimeout(function(){
            console.log('click filedownload');
            document.getElementById('filedownload').click();
            $('#filedownload').remove();
        }, 500);
    },
    clickVideoFolder: function(index) {
        if ($('body').hasClass('selection-mod')) {
            app.checkCell(index);
            return;
        }
        var folder = app.currentFolder.children[index];
        app.currentFolder = folder;
        app.loadVideos(folder.absoultePath);
    },
    startHeartBeat: function() {
        app.heartBeartCheck = setInterval(function() {
            $.getJSON("/heartbeat", function(res) {

            }).error(function() {
                $("#message-modal").modal("show");
                clearInterval(app.heartBeartCheck);
            });
        }, 2000);
    },
    // 通过websocket发送消息
    sendWebSocketMessage: function(msg) {
        var data = {
            code: 0,
            message: "",
            text: msg
        };
        console.log("send message " + JSON.stringify(data));
        app.ws.send(JSON.stringify(data));
    },
    // 初始化websocket
    initWebSocket: function() {
        var ws = new WebSocket("ws://" + location.hostname + ":" + location.port);
        app.ws = ws;
        var sendMessage = app.sendWebSocketMessage;

        var keepAlive = function() {
            var timerID = setInterval(function() {
                if (ws.readyState == WebSocket.OPEN) {
                    console.log("发送心跳包");
                    ws.send('');
                } else {
                    clearInterval(timerID);
                }
            }, 1000);
        }

        ws.onopen = function() {
            console.log("ws onopen");
            keepAlive();
        };
        ws.onmessage = function(event) {
            var data = event.data;
            console.log("from server: " + data);
            if (data) {
                var msg = JSON.parse(data);
                app.clipboardDatas.push(msg);
                console.log("onmessage " + msg.text);
                if (app.mode == 'clipboard') {
                    var itemData = app.templates['template-clipboard-item-from-phone'](msg);
                    $(".timeline").append(itemData);
                    document.body.scrollTop = document.body.scrollHeight;
                }
            }
        };
    },
    sendMessage: function() {
        var text = $('#message-textarea').val();
        console.log("message " + text);
        $('#message-textarea').val('');
        if (text != '') {
            app.sendWebSocketMessage(text);
            var msg = {
                code: 0,
                from: 'pc',
                message: '',
                text: text
            };
            app.clipboardDatas.push(msg);
            if (app.mode == 'clipboard') {
                var itemData = app.templates['template-clipboard-item-from-pc'](msg);
                $(".timeline").append(itemData);
                console.log("append item");
                document.body.scrollTop = document.body.scrollHeight;
            }
        }
    },
    // 重新加载当前的模式
    reload: function() {
        if (app.mode == 'image') {
            if (app.submode == 'images') {
                app.loadImages();
            } else {
                app.loadImageFolders();
            }
        } else if (app.mode == 'files' || app.mode == 'fft') {
            console.log('reload files');
            app.loadFiles(app.currentFolder.absoultePath);
        } else if (app.mode == 'video') {
            console.log('reload video');
            if (app.submode == 'folders' &&app.currentFolder && app.currentFolder.absoultePath) {
                app.loadVideos(app.currentFolder.absoultePath);
            } else {
                app.loadVideos();
            }
        } else if (app.mode =='download') {
            app.loadFiles('/download')
        } else if (app.mode == 'music') {
            app.loadMusicList();
        } else if (app.mode == 'document') {
            app.loadDocuments(this.fileType);
        } else if (app.mode == 'search') {
            app.search(app.searchContent);
        }
        app.cancelSelection();
    },
    // 设置layout样式
    setLayoutStyle: function(ele) {
        var curStyle = localStorage.getItem('layoutStyle') || 'grid';
        console.log('layout style=' + curStyle);
        if (curStyle == 'grid') {
            console.log('setLayout list');
            localStorage.setItem('layoutStyle', 'list');
        } else {
            console.log('setLayout grid');
            localStorage.setItem('layoutStyle', 'grid');
        }
        
        // if (localStorage.getItem('layoutStyle') == style) {
        //     return;
        // }
        // localStorage.setItem('layoutStyle', style);
        app.reload();
    },
    // 设置是否显示隐藏文件
    setShowHiddenFiles: function(ele) {
        var isShow = localStorage.getItem('showHiddenFiles') || 'false';
        if (isShow == 'true') {
            localStorage.setItem('showHiddenFiles', 'false');
        } else {
            localStorage.setItem('showHiddenFiles', 'true');
        }

        // console.log('setShowHiddenFiles ' + checked + " " + localStorage.getItem('showHiddenFiles'));
        // if (localStorage.getItem('showHiddenFiles') == checked) {
        //     return;
        // }
        // localStorage.setItem('showHiddenFiles', checked);
        app.reload();
    },
    // 设置排序顺序
    setSortOrder: function(sortOrder, sortBy) {
        console.log('setSortOrder ' + sortBy + sortOrder);
        if (localStorage.getItem('sortOrder' + sortBy) == sortOrder) {
            return;
        }
        localStorage.setItem('sortOrder' + sortBy, sortOrder);
        app.reload();
    },
    // 设置按什么排序
    setSortBy: function(ele, sortBy) {
        console.log('setSortBy ' + sortBy);
        if (localStorage.getItem('sortBy') == sortBy) {
            var tabItem = app.sortByTabBar.getTabItem(sortBy);
            var i = $("i", tabItem);
            console.log(i);
            if (i.hasClass('icondown')) {
                i.removeClass('icondown');
                i.addClass('iconup')
                app.setSortOrder(0, sortBy);
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
                app.setSortOrder(1, sortBy);
            }
            return;
        }
        localStorage.setItem('sortBy', sortBy);
        app.reload();
    },
    // 设置按什么排序
    setMusicSortBy: function(ele, sortBy) {
        console.log('setMusicSortBy ' + sortBy);
        if (localStorage.getItem('music-sortBy') == sortBy) {
            var tabItem = app.musicTabBar.getTabItem(sortBy);
            var i = $("i", tabItem);
            console.log(i);
            if (i.hasClass('icondown')) {
                i.removeClass('icondown');
                i.addClass('iconup')
                app.setMusicSortOrder(0, sortBy);
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
                app.setMusicSortOrder(1, sortBy);
            }
            return;
        }
        localStorage.setItem('music-sortBy', sortBy);
        app.reload();
    },
    // 设置排序顺序
    setMusicSortOrder: function(sortOrder, sortBy) {
        console.log('setMusicSortOrder ' + sortBy + sortOrder);
        if (localStorage.getItem('music-sortOrder' + sortBy) == sortOrder) {
            return;
        }
        localStorage.setItem('music-sortOrder' + sortBy, sortOrder);
        app.reload();
    },
    // 设置文档按什么排序
    setDocumentSortBy: function(ele, sortBy) {
        console.log('setDocumentSortBy ' + sortBy);
        if (localStorage.getItem('document-sortBy') == sortBy) {
            var tabItem = app.documentTabBar.getTabItem(sortBy);
            var i = $("i", tabItem);
            console.log(i);
            if (i.hasClass('icondown')) {
                i.removeClass('icondown');
                i.addClass('iconup')
                app.setDocumentSortOrder(0, sortBy);
            } else {
                i.removeClass('iconup');
                i.addClass('icondown');
                app.setDocumentSortOrder(1, sortBy);
            }
            return;
        }
        localStorage.setItem('document-sortBy', sortBy);
        app.reload();
    },
    // 设置文档排序顺序
    setDocumentSortOrder: function(sortOrder, sortBy) {
        console.log('setDocumentSortOrder ' + sortBy + sortOrder);
        if (localStorage.getItem('document-sortOrder' + sortBy) == sortOrder) {
            return;
        }
        localStorage.setItem('document-sortOrder' + sortBy, sortOrder);
        app.reload();
    },
    onkeydown: function(event) {
        console.log("keydown: " + event.keyCode + " ctrlKey:" + event.ctrlKey + " shiftKey:" + event.shiftKey);
        if (event.keyCode == 13 && event.shiftKey) {
            event.preventDefault();
            app.sendMessage();
        }
    },
    clickNewFolder: function() {
        console.log("clickNewFolder");
        document.getElementById("new-folder-name").value = "";
        $('#new-folder-modal').modal({'backdrop': 'static', 'show': true});
        $("#new-folder-name-wrapper").removeClass('has-error');
    },
    newFolder: function() {
        console.log("newFolder");
        var folderName = document.getElementById("new-folder-name").value;
        console.log("folder name=" + folderName);
        var path = app.currentFolder.absoultePath;
        $("#new-folder-name-wrapper").removeClass('has-error');

        $.getJSON('/newFolder',{
            path: path,
            folderName: folderName
        }, function(res) {
            console.log(res);
            if (res["code"] == 0) {
                app.loadFiles(res.absoultePath);
                $('#new-folder-modal').modal('hide');
                app.toast.show("创建成功!");
            } else {
                $("#new-folder-name-wrapper").addClass('has-error');
                $('#new-folder-name-wrapper .help-block').text(res['message']);
            }
        });

    }
}

function registerHelper() {
    console.log('registerHelper');
    Handlebars.registerHelper('first', function(arr) {
        return arr[0];
    });
    Handlebars.registerHelper('isLastPath', function(index, options) {
        console.log('isLastPath')
        console.log(index);
        if (index == app.paths.length-1) {
            console.log('last');
            return options.fn(this);
        } else {
            return options.inverse(this);
            console.log('not last');
        }
    });
    // 把长的文件名缩短
    Handlebars.registerHelper('minFileName', function(name) {
        if (name.length > 20) {
            var first = name.substring(0, 8);
            var last = name.substring(name.length-8, name.length);
            return first + "..." + last;
        } else {
            return name;
        }
    });
    // 通过文件扩展名显示对应的图标
    Handlebars.registerHelper('iconForExtName', function(name) {
        var arr = name.split('.');
        if (arr.length > 0) {
            var extName = arr[arr.length-1].toLowerCase();
            console.log('extName ' + extName);
            if (extName == 'pdf') {
                return 'far fa-file-pdf';
            } else if (extName == 'doc' || extName == 'docx') {
                return 'far fa-file-word';
            } else if (extName == 'xls' || extName == 'xlsx') {
                return 'far fa-file-excel';
            } else if (extName == 'ppt' || extName == 'pptx') {
                return 'far fa-file-powerpoint';
            } else if (extName == 'zip' || extName == 'rar' || extName == '7z') {
                return 'far fa-file-archive';
            } else if (extName == 'apk') {
                return 'fab fa-android';
            } else if (extName == 'mp3' || extName == 'wav') {
                return 'far fa-file-audio';
            } else if (extName == 'mp4' || extName == 'avi' || extName == 'mkv') {
                return 'far fa-file-video'
            }
            else {
                return 'far fa-file';
            }
        } else {
            return 'far fa-file';
        }
    });
    // 编码
    Handlebars.registerHelper('encode', function(string) {
        return encodeURIComponent(string);
    });
    // 判断是否图片
    Handlebars.registerHelper('isImage', function(name, options) {
        var arr = name.split('.');
        if (arr.length > 0) {
            var extName = arr[arr.length-1].toLowerCase();
            if (extName == 'png' || extName == 'jpeg' || extName == 'jpg') {
                return options.fn(this);
            } else {
                return options.inverse(this);
            }
        } else {
            return options.inverse(this);
        }
    });
    // 把毫秒时间格式化
    Handlebars.registerHelper('formatTime', function(duration) {
        var s = duration / 1000;
        var hour = Math.floor(s / 3600);
        var minute = Math.floor((s % 3600) / 60);
        var second = Math.floor((s % 3600) % 60);
        if (hour < 10) {
            hour = "0" + hour;
        }
        if (minute < 10) {
            minute = "0" + minute;
        }
        if (second < 10) {
            second = "0" + second;
        }
        if (hour > 0) {
            return hour + ":" + minute + ":" + second;
        } else {
            return minute + ":" + second;
        }
        // return hour + ":" + minute + ":" + second;
    });
    // 大小转为字符串
    Handlebars.registerHelper('formatSize', function(size) {
        if (size > 1024) {
            if (size > 1024 * 1024) {
                if (size > 1024 * 1024 * 1024) {
                    return (size / 1024 / 1024 / 1024).toFixed(2) + 'GB';
                } else {
                    return (size / 1024 / 1024).toFixed(2) + 'MB';
                }

            } else {
                return (size / 1024).toFixed(2) + 'KB';
            }

        } else {
            return size + 'B';
        }
    });
    // 把换行符换成html标签
    Handlebars.registerHelper('formatMessage', function(text) {
        console.log("origin message:" + text);
        var reg = new RegExp("\n", "g");
        var formated = text.replace(reg, "<br/>");
        console.log("formated message:" + formated);
        return formated;
    });
}

$(document).ready(function(){
    var clipboard = new Clipboard('.clip');
    clipboard.on('success', function(e) {
        app.toast.show("已复制!");
    });
    // app.loadHeader();
    registerHelper();
    app.mainContainer = $("#main-container-content");
    app.mainContainerToolbar = $('#main-container-toolbar');
    app.initTemplate();
    // app.loadNavbar();
    app.startHeartBeat();
    app.initWebSocket();
    app.sortByTabBar = new TabBar($("#tab-bar-files"));
    app.musicTabBar = new TabBar($("#tab-bar-music"));
    app.documentTabBar = new TabBar($("#tab-bar-document"));
    app.sortByTabBar.onTabSelect = function(ele, sortBy) {
        app.setSortBy(ele, sortBy);
    }
    app.musicTabBar.onTabSelect = function(ele, sortBy) {
        app.setMusicSortBy(ele, sortBy);
    }
    app.documentTabBar.onTabSelect = function(ele, sortBy) {
        app.setDocumentSortBy(ele, sortBy);
    }
    app.toast = new Toast($('.toast span'));

    $.getJSON("/defaultTab", function(res) {
        $('#sidebar-page li').removeClass('active');
        var index = res.tab;
        if (index == 0) {
            app.setMode('image');
            $('.tab-photo').addClass('active');
        } else if (index == 1) {
            app.setMode('video');
            $('.tab-video').addClass('active');
        } else if (index == 2) {
            app.setMode('music');
            $('.tab-music').addClass('active');
        } else if (index == 3) {
            app.setMode('download');
            $('.tab-download').addClass('active');
        } else if (index == 4) {
            app.setMode('files');
            $('.tab-files').addClass('active');
        } else if (index == 5) {
            app.setMode('fft');
            $('.tab-fft').addClass('active');
        } else if (index == 6) {
            app.setMode("clipboard");
            $('.tab-clipboard').addClass('active');
        } else if (index == 7) {
            app.setMode("document", DOCUMENT_FILE);
            $('.tab-documents').addClass('active');
        } else if (index == 8) {
            app.setMode("document", ZIP_FILE);
            $('.tab-zip').addClass('active');
        } else if (index == 9) {
            app.setMode("document", APK_FILE);
            $('.tab-apk').addClass('active');
        }
    }).error(function() {

    });

    $.getJSON("/appFolder", function(res){
        app.appPath = res.absoultePath;
        console.log("appPath " + app.appPath);
    });

    
    $(window).resize(function() {
        console.log("resize");
        app.onscroll();
    });

    $(window).scroll(function() {
        console.log('scroll');
        app.onscroll();
    });
    $("#main-container-content").scroll(function() {
        console.log('scroll');
        app.onscroll();
    });

    // 拖拉上传
    if (window.File && window.FileReader && window.FileList && window.Blob) {
        // 阻止浏览器默认的拖拽操作
        // $(document).on({
        //     dragleave:function(e){      //拖离
        //         e.preventDefault();
        //     },
        //     drop:function(e){           //拖后放
        //         e.preventDefault();
        //     },
        //     dragenter:function(e){      //拖进
        //         e.preventDefault();
        //     },
        //     dragover:function(e){       //拖来拖去
        //         e.preventDefault();
        //     }
        // });


        var dropHandler = function(e) {
            console.log("dropHandler " + e.dataTransfer.items)
            $("#drag-layout").removeClass('over');
            // $(e.target).removeClass('over');
            e.preventDefault();//取消默认浏览器拖拽效果
            if (e.dataTransfer.files.length == 0) {
                return false;
            }

            // app.startUploadFiles(files);

            var iterateFilesAndDirs = function(parent, file) {
                if (typeof file.getFilesAndDirectories === 'function') {
                    file.getFilesAndDirectories().then(function(subFilesAndDirs) {
                        // iterate through files and directories in sub-directory
                        for (var i = 0; i < subFilesAndDirs.length; i++) {
                            iterateFilesAndDirs(file, subFilesAndDirs[i]);
                        }
                    });
                } else {
                    if (parent) {
                        app.addToUpload(file, parent.path);
                        console.log("add file " + file.name + " path=" + parent.path);
                    } else {
                        app.addToUpload(file, "/");
                        console.log("add file " + file.name + " path=/");
                    }
                }
            }

            // begin by traversing the chosen files and directories
            if ('getFilesAndDirectories' in e.dataTransfer) {
                console.log('getFilesAndDirectories');
                e.dataTransfer.getFilesAndDirectories().then(function(filesAndDirs) {
                    var folderName = (app.currentFolder && app.currentFolder.name) || app.appPath;
                    console.log("upload folder name:" + folderName);
                    app.showUploadDialog();
                    app.initUpload(filesAndDirs.length > 0);
                    for (var i = 0; i < filesAndDirs.length; i++) {
                        iterateFilesAndDirs(null, filesAndDirs[i]);
                    }
                    // iterateFilesAndDirs(filesAndDirs, '/');
                });
            } else if (e.dataTransfer.items) {
                // Use DataTransferItemList interface to access the file(s)
                var files = [];
                var hasFolder = false;
                for (var i = 0; i < e.dataTransfer.items.length; i++) {
                    // If dropped items aren't files, reject them
                    if (e.dataTransfer.items[i].kind === 'file') {
                        var file = e.dataTransfer.items[i].getAsFile();
                        if (file.size > 0) {
                            files.push(file);
                        }
                        if (file.size == 0) {
                            hasFolder = true;
                            break;
                        }
                        console.log('... file[' + i + '].name = ' + file.name + "size=" + file.size);
                        console.log(file);
                    }
                }
                if (hasFolder) {
                    alert("您的浏览器不支持拖拽上传文件夹，请只拖拽文件进行上传。")
                } else if (files.length > 0) {
                    var folderName = (app.currentFolder && app.currentFolder.name) || app.appPath;
                    console.log("upload folder name:" + folderName);
                    app.showUploadDialog();
                    app.initUpload(true);
                    for (var i = 0; i < files.length; i++) {
                        app.addToUpload(files[i], "/");
                    }
                }
            }
        }

        var dropLeaveHandler = function(ev) {
            ev.stopPropagation();
            ev.preventDefault();
        }
        var dropLeave2Handler = function(ev) {
            ev.stopPropagation();
            ev.preventDefault();
            $("#drag-layout").removeClass('over');
        }

        var dropOverHandler = function(ev) {
            ev.stopPropagation();
            ev.preventDefault();
        }

        var dropEnterHandler = function(ev) {
            ev.stopPropagation();
            ev.preventDefault();
            $("#drag-layout").addClass('over');
        }

        var mainContainer = document.getElementById("main-container-content");
        // mainContainer.addEventListener("drop", dropHandler);
        mainContainer.addEventListener("dragleave", dropLeaveHandler);
        mainContainer.addEventListener("dragover", dropOverHandler);
        mainContainer.addEventListener("dragenter", dropEnterHandler);
        var dragLayout = document.getElementById("drag-layout");
        dragLayout.addEventListener("drop", dropHandler);
        dragLayout.addEventListener("dragleave", dropLeave2Handler);
        dragLayout.addEventListener("dragover", dropOverHandler);
        dragLayout.addEventListener("dragenter", dropEnterHandler);
        // var filesTarget = document.getElementById("file-btn");
        // filesTarget.addEventListener("drop", dropHandler);
        // var body = document.getElementsByTagName("body");
        // window.addEventListener("drop", dropHandler);
        // var dragLayout = document.getElementById("drag-layout");
        // dragLayout.addEventListener("drop", dropHandler);
    }

    var body = $("body");

    $(".button-collapse").click(function() {
        console.log('click');
        body.addClass('slide-bar-visible');
    });
    $(".cover").click(function() {
        body.removeClass('slide-bar-visible');
    });

    document.addEventListener("keydown", function(e) {
        console.log("keyCode=" + e.keyCode);
        if (app.imagePreview != null) {
            if (e.keyCode == 37) {
                app.imagePreview.prev();
            } 
            if (e.keyCode == 39) {
                app.imagePreview.next();
            }
        }
    });

    // 搜索
    $('#search-input').keypress(function (e) {
        if (e.which == 13) {
            var content = $('#search-input').val();
            if (content) {
                app.search(content);
            }
          return false;    //<---- Add this line
        }
    });


});

// window.onscroll = function() {
//     console.log("onscroll");
//     app.onscroll();
// }

if (!app.debug) {
    console.log = function(){};
}
