var CollectionView = function() {
    this.container = $('<div class="collection-view"></div>');
    this.container.css("width", "100%");
    this.container.css("position", "relative");
    this.cellCache = [];
    var self = this;
    window.onscroll = function() {
        console.log("onscroll");
        self.reloadData();
    }
    $(window).resize(function() {
        console.log("resize");
        self.reloadData();
    })
}
// 代理
CollectionView.prototype.delegate = null;
// 数据源
CollectionView.prototype.datasource = null;

CollectionView.prototype.html = function() {
    return this.container;
}

// 加载数据
CollectionView.prototype.reloadData = function() {
    // this.container.empty();
    this.count = this.datasource.count();
    var size = this.size = this.datasource.cellSize();
    this.containerWidth = this.container.width();
    this.bodyHeight = this.container.parent().height();
    this.scrollTop = this.container.parent().scrollTop();
    console.log("size " + this.size.width, this.size.height);
    console.log("containerWidth " + this.containerWidth);
    console.log("bodyHeight " + this.bodyHeight);
    console.log("scrollTop " + this.scrollTop);

    // 一行多少个cell
    this.cellNumberInRow = Math.floor(this.containerWidth / size.width);
    console.log("cellNumbserInRow=" + this.cellNumberInRow);
    var containerHeight = (this.count / this.cellNumberInRow) * size.height;
    this.container.css("height", containerHeight);

    var indexs = this.getRenderCellIndexs();
    console.log("indexs length=" + indexs.length);

    // 移除屏幕外的cell
    var newCellCahce = [];
    for (var i = 0; i < indexs.length; i++) {
        var removeCell;
        for (var j = 0; j < this.cellCache.length; j++) {
            var cache = this.cellCache[j];
            if (cache.index == indexs[i].index) {
                newCellCahce.push(cache);
                this.cellCache.splice(j, 1);
                break;
            }
        }
    }
    for (var i = 0; i < this.cellCache.length; i++) {
        console.log("remove");
        console.log(this.cellCache[i].cell);
        this.cellCache[i].cell.remove();
    }
    console.log("new cellCache")
    console.log(newCellCahce);
    this.cellCache = newCellCahce;

    for (var i = 0; i < indexs.length; i++){
        var cached = null;
        for (var j = 0; j < this.cellCache.length; j++) {
            var cache = this.cellCache[j];
            if (cache.index == indexs[i].index) {
                cached = cache;
            }
        }
        var cell = null;
        if (cached) {
            console.log("cached ")
            cell = cached.cell;
        } else {
            cell = $(this.datasource.cellForIndex(indexs[i].index));
        }
        var pos = indexs[i].pos;
        cell.css("position", "absolute");
        cell.css("left", pos.left);
        cell.css("top", pos.top);
        if (!cached) {
            this.container.append(cell);
            this.cellCache.push({
                index: indexs[i].index,
                cell: cell
            });
        }
    }
}

/// 获取需要渲染的cell的indexs
CollectionView.prototype.getRenderCellIndexs = function() {
    var visualTop = this.scrollTop - this.bodyHeight;
    var visualBottom = visualTop + this.bodyHeight * 3;
    console.log("indexs visualTop=" + visualTop + " visualBottom=" + visualBottom);

    var indexs = [];
    var startIndex = 0;
    for (var i = 0; i < this.count; i++) {
        var pos = this.getPositionForCellIndex(i);
        
        if (pos.bottom >= visualTop && pos.top <= visualBottom) {
            console.log("indexs pos bottom=" + pos.bottom + " top=" + pos.top)
            indexs.push({
                index: i,
                pos: pos
            });
        }
        if (pos.top > visualBottom) {
            break;
        }
    }
    return indexs;
}

CollectionView.prototype.getPositionForCellIndex = function(index) {
    var left = 0;
    if (this.datasource.aliginItems == 'center') {
        left = (this.containerWidth - this.cellNumberInRow * this.size.width) / 2;
    } else if (this.datasource.aliginItems == 'left') {
        left = 0;
    }
    var row = Math.floor(index / this.cellNumberInRow);
    var col = index % this.cellNumberInRow;
    x = left + col * this.size.width;
    y = row * this.size.height;

    return {
        left: x, 
        top: y,
        right: x + this.size.width,
        bottom: y + this.size.height
    };
}