var ImagePreview = function($ele, ids) {
    this.container = $ele;
    this.imgEle = $(".image-preview img", this.container);
    this.ids = ids;
    console.log(this.ids);

    this.prevBtn = $('.image-prev', this.container);
    this.nextBtn = $('.image-next', this.container);
    this.downloadBtn = $('.image-preview-download', this.container);

    var self = this;
    this.prevBtn.click(function() {
        self.prev();
    });

    this.nextBtn.click(function() {
        self.next();
    });
}

ImagePreview.prototype.hasNext = function() {
    var index = this.ids.indexOf(this.currentId);
    return index != -1 && index < this.ids.length-1;
}

ImagePreview.prototype.hasPrev = function() {
    var index = this.ids.indexOf(this.currentId);
    console.log("hasPrev index=" + index);
    return index != -1 && index > 0;
}

ImagePreview.prototype.next = function() {
    var index = this.ids.indexOf(this.currentId);
    if (index == -1) {
        console.log("没有下一张了");
    } else {
        this.loadImage(this.ids[index+1]);
    }
}

ImagePreview.prototype.prev = function() {
    var index = this.ids.indexOf(this.currentId);
    if (index == -1) {
        console.log("没有上一张了");
    } else {
        this.loadImage(this.ids[index-1]);
    }
}

ImagePreview.prototype.loadImage = function(id) {
    this.currentId = "" + id;
    if (!this.hasNext()) {
        this.nextBtn.hide();
    } else {
        this.nextBtn.show();
    }

    if (!this.hasPrev()) {
        this.prevBtn.hide();
    } else {
        this.prevBtn.show();
    }
    var image = new Image();
    var self = this;
    self.imgEle.hide();
    image.onload = function() {
        self.imgEle.attr("src",this.src);

        var screenWidth = window.innerWidth;
        var screenHeight = window.innerHeight;
        
        if (this.width < screenWidth && this.height < screenHeight) {
            self.imgEle.css('width', this.width);
            self.imgEle.css('height', this.height);
        } else {
            var ratio = this.width / this.height;
            var screenRatio = screenWidth / screenHeight;
            if (ratio > screenRatio) {
                self.imgEle.css('width', screenWidth);
                self.imgEle.css('height', screenWidth / ratio);
            } else {
                self.imgEle.css('height', screenHeight);
                self.imgEle.css('width', screenHeight * ratio);
            }
        }

        self.imgEle.show();

        console.log("width=" + this.width + " height=" + this.height);
        console.log("document width=" + $(document).width() + " height=" + $(document).height());
    }
    image.src = "/images/fullimage?id=" + id;
    this.downloadBtn.attr('href', "/images/fullimage?id=" + id + "&download=true");
}