var TabBar = function($element) {
    this.element = $element;
    var self = this;
    $(".tab-bar-content .tab-item", this.element).click(function() {
        console.log("click tab item");
        console.log(this);
        self.moveToItem($(this, self.element));
        console.log("data-value=" + $(this).attr('data-value'));
        self.onTabSelect(this, $(this).attr('data-value'))
    });
}

TabBar.prototype.select = function(value) {
    this.moveToItem($('[data-value="' +  value + '"]', this.element));
}

TabBar.prototype.getTabItem = function(value) {
    return $('[data-value="' +  value + '"]');
}

TabBar.prototype.moveToItem = function($ele) {
    var left =  $ele.position().left;
    console.log('left=' + left);
    var movementItem = $(".tab-item-move", this.element);
    console.log(movementItem);
    movementItem.css("transform", "translateX(" + left + "px)");
}

TabBar.prototype.onTabSelect = function(ele, value) {

};

TabBar.prototype.show = function() {
    this.element.show();
}

TabBar.prototype.hide = function() {
    this.element.hide();
}