var header = document.getElementById('header');
header.parentNode.removeChild(header);

var normalVersion = document.getElementsByClassName('normal-version');
if (normalVersion.length > 0) {
    normalVersion[0].parentNode.removeChild(normalVersion[0]);
}

var footer = document.getElementsByClassName('footer');
if (footer.length > 0) {
    footer[0].parentNode.removeChild(footer[0]);
}

var footerApp = document.getElementById('app-dl');
footerApp.style.width = 0;
footerApp.style.height = 0;
footerApp.style.padding = 0;

var titleR = document.getElementsByClassName('red');
var titleR1 = document.getElementsByClassName('book-title-r');
for(var i = 0; i < titleR.length; i++) {
    titleR[i].parentNode.removeChild(titleR[i]);
}
for(var i = 0; i < titleR1.length; i++) {
    titleR1[i].parentNode.removeChild(titleR1[i]);
}

var appDownload = document.getElementById('app-download');
if (appDownload != null && appDownload != undefined) {
    appDownload.parentNode.removeChild(appDownload);
}

// body节点
var body = document.getElementsByTagName("body")[0];
var books = document.getElementById('books');
// 选择需要观察变动的节点
var targetNode = body;

// 观察器的配置（需要观察什么变动）
var config = { attributes: true, childList: true, subtree: true };

// 当观察到变动时执行的回调函数
var callback = function(mutationsList, observer) {
    // Use traditional 'for loops' for IE 11
    var titleR = document.getElementsByClassName('red');
    var titleR1 = document.getElementsByClassName('book-title-r');
    for(var i = 0; i < titleR.length; i++) {
        titleR[i].parentNode.removeChild(titleR[i]);
    }
    for(var i = 0; i < titleR1.length; i++) {
        titleR1[i].parentNode.removeChild(titleR1[i]);
    }
    // 隐藏loading图标
    var loadings = document.getElementsByClassName('loading-x');
    if (loadings.length > 0) {
        var loading = loadings[0];
        if (loading != null) {
            loading.parentNode.removeChild(loading);
        }
    }
};

// 创建一个观察器实例并传入回调函数
var observer = new MutationObserver(callback);

// 以上述配置开始观察目标节点
observer.observe(targetNode, config);

// 添加点击监听
books.addEventListener('click', function(event) {
    var bookName = null;
    var bookNameClass = "book-title";
    var curTarget = event.target;
    // 定位点击的是哪本书
    var count = 0;
    var max = 100;
    while (curTarget.className != "book-li") {
        curTarget = curTarget.parentNode;
        count++;
        // 做一个限制防止循环次数过多
        if (count >= max) {
            break;
        }
    }
    var bookNameTags = curTarget.getElementsByClassName(bookNameClass);
    if (bookNameTags != null && bookNameTags.length > 0) {
        bookName = bookNameTags[0].innerText;
    }
    // 反馈到注入方,警告:INJECT_OBJ这个对象名称不可以更改,返回一个jsonObject字符串
    window.INJECT_OBJ.onSearch(JSON.stringify({"bookName": bookName}));
}, false);