var pageContainer = document.getElementById('page-container');
if (pageContainer != null) {
    /* 隐藏Actionbar */
    var elements = pageContainer.getElementsByClassName('page-header');
    if (elements != null && elements.length > 0) {
        var header = elements[0];
        if (header != null) {
            header.style.display = 'none';
        }
    }
    /* 底部提示 */
    elements = pageContainer.getElementsByClassName('to-star-groups-button');
    if (elements != null && elements.length > 0) {
        var hint = elements[0];
        if (hint != null) {
            hint.style.display = 'none';
        }
    }
    var bookTags = pageContainer.getElementsByClassName('J_RankMergeListContainer');
    if (bookTags != null && bookTags.length > 0) {
    var books = bookTags[0];
    // 添加点击监听
    books.addEventListener('click', function(event) {
        var bookName = '';
        var bookAuthor = '';
        var bookCover = '';
        var bookIntro = '';
        var bookNameClass = 'c-header-title';
        var bookCoverClass = 'cover';
        var bookAuthorParentClass = 'c-paragraph--v1_0_0 c-flex c-flex-center-y c-font-dark c-font-s c-font-normal';
        var bookAuthorClass = 'js-c-paragraph-text';
        var bookIntroClass = 'novel-desc';
        var curTarget = event.target;
        // 定位点击的是哪本书
        var count = 0;
        var max = 200;
        while (curTarget.className != 'js-c-list-container-item c-list-container-item c-border-top dilu-list_container-container') {
            curTarget = curTarget.parentNode;
            count++;
            // 做一个限制防止循环次数过多
            if (count >= max || curTarget == null || curTarget == undefined) {
                break;
            }
        }
        if (count >= max || curTarget == null) {
            curTarget = event.target;
            count = 0;
            while (curTarget.className != 'js-c-list-container-item c-list-container-item  dilu-list_container-container') {
               curTarget = curTarget.parentNode;
               count++;
               // 做一个限制防止循环次数过多
               if (count >= max || curTarget == null || curTarget == undefined) {
                   break;
               }
            }
        }
        if (curTarget != null) {
        var bookNameTags = curTarget.getElementsByClassName(bookNameClass);
        if (bookNameTags != null && bookNameTags.length > 0) {
            var cHeaderTitle = bookNameTags[0];
            var spans = cHeaderTitle.getElementsByTagName('span');
            if (spans != null && spans.length > 0) {
                var span = spans[0];
                var html = span.innerHTML;
                html = html.replace('<i c-bind="data.text">', '');
                html = html.replace('</i>', '');
                var end = '</span>';
                var index = html.indexOf(end);
                if (index == -1) {
                    bookName = span.innerText;
                    var dotIndex = bookName.indexOf('.');
                    bookName = bookName.substring(dotIndex + 1, bookName.length);
                } else {
                    bookName = html.substring(index + end.length, html.length);
                }
            }
        }
        var bookAuthorParentTags = curTarget.getElementsByClassName(bookAuthorParentClass);
        if (bookAuthorParentTags != null && bookAuthorParentTags.length > 0) {
            var bookAuthorParent = bookAuthorParentTags[0];
            var bookAuthorTags = bookAuthorParent.getElementsByClassName(bookAuthorClass);
            if (bookAuthorTags != null && bookAuthorTags.length > 0) {
                bookAuthor = bookAuthorTags[0].innerText;
            }
        }
        var bookIntroTags = curTarget.getElementsByClassName(bookIntroClass);
        if (bookIntroTags != null && bookIntroTags.length > 0) {
           bookIntro = bookIntroTags[0].innerText;
        }
        var bookCoverTags = curTarget.getElementsByClassName(bookCoverClass);
        if (bookCoverTags != null && bookCoverTags.length > 0) {
            var urlMode = bookCoverTags[0].style.backgroundImage;
            if (urlMode != null && urlMode != undefined) {
                bookCover = urlMode.replace('url("','').replace('")','');
                if (bookCover.startsWith('//')) {
                    bookCover = 'http:' + bookCover;
                } else if (bookCover.startsWith('://')) {
                    bookCover = 'http' + bookCover;
                } else if (!bookCover.startsWith("http://") && !bookCover.startsWith("https://")) {
                    bookCover = 'http://' + bookCover;
                }
            }
        }
        console.log(bookName);
        console.log(bookAuthor);
        console.log(bookCover);
        console.log(bookIntro);
        // 反馈到注入方,警告:INJECT_OBJ这个对象名称不可以更改,返回一个jsonObject字符串
        window.INJECT_OBJ.onSearch(JSON.stringify(
        {
            "bookName": bookName,
            "bookAuthor": bookAuthor,
            "bookCover": bookCover,
            "bookIntro": bookIntro
        }));
        }
    }, false);
    }
}