var XKBridge = {
  default: this,// for typescript
  call: function (method, args, cb) {
    var ret = '';
    if (typeof args == 'function') {
      cb = args;
      args = {};
    }
    var arg = {data: args === undefined ? null : args}
    if (typeof cb == 'function') {
      var cbName = 'dscb' + window.dscb++;
      window[cbName] = cb;
      arg['_dscbstub'] = cbName;
    }
    arg = JSON.stringify(arg)

    //if in webview that dsBridge provided, call!
    if (window._dsbridge) {
      ret = _dsbridge.call(method, arg)
    } else if (window._dswk || navigator.userAgent.indexOf("_dsbridge") != -1) {
      ret = prompt("_dsbridge=" + method, arg);
    }
    console.log(ret)
    return JSON.parse(ret || '{}').data
//    console.log(ret)
//    return JSON.parse(ret || '{}')
  },
  register: function (name, fun, asyn) {
    var q = asyn ? window._dsaf : window._dsf
    if (!window._dsInit) {
      window._dsInit = true;
      //notify native that js apis register successfully on next event loop
      setTimeout(function () {
        XKBridge.call("_dsb.dsinit");
      }, 0)
    }
    if (typeof fun == "object") {
      q._obs[name] = fun;
    } else {
      q[name] = fun
    }
  },
  registerAsyn: function (name, fun) {
    this.register(name, fun, true);
  },
  hasNativeMethod: function (name, type) {
    return this.call("_dsb.hasNativeMethod", {name: name, type: type || "all"});
  },
  disableJavascriptDialogBlock: function (disable) {
    this.call("_dsb.disableJavascriptDialogBlock", {
      disable: disable !== false
    })
  },
  ///////////////////XIKANG自定义功能begin/////////////////////////
  //js打开原生功能
  openFunction: function (functionCode, params, cb) {
    this.call("openFunction", {
      functionCode: functionCode,
      params: params
    }, cb);
  },
  //打开体检报告
  openHealthRecords: function (args, cb) {
    this.call("openHealthRecords", args, cb);
  },
  onPageVisible: function (args, cb) {
      this.call("onPageVisible", args, cb);
  },
  selectImage: function (args, cb) {
    this.call("selectImage", args, cb);
  },
  //IM对话
  goChat: function (args, cb) {
    this.call("goChat", args, cb);
  },
  //IM对话
  goChatWithExtension: function (args, cb) {
    this.call("goChatWithExtension", args, cb);
  },
//关闭当前webview
  closeWebview: function () {
    this.call("closeWebview", {}, null);
  },
//清除缓存
  H5clearUserCache: function () {
    this.call("H5clearUserCache", {}, null);
  },
//获取版本号
  getAppVersion: function (cb) {
    this.call("getAppVersion", {}, cb);
  },
//退出登录
  logout: function () {
    this.call("logout", {}, null);
  },
//退上传日志文件
  uploadLogFiles: function (cb) {
    this.call("uploadLogFiles", {}, cb);
  },
//认证CA
  caCertificateApply: function (cb) {
    this.call("caCertificateApply", {}, cb);
  },
//检查CA证书并注册
caCheckAndReg: function (args, cb) {
  this.call("caCheckAndReg", args, cb);
},
//处方签名
  gosign: function (args, cb) {
    this.call("gosign", args, cb);
  },
  openWeChat: function (args, cb) {
    this.call("openWeChat", args, cb);
  },
  savePictureToAlbum: function (args, cb) {
    this.call("savePictureToAlbum", args, cb);
  },
//安卓直接打开系统设置页
  openNotificationSetting: function () {
    this.call("openNotificationSetting", {}, null);
  },
//关闭当前webview并刷新
  closeWebviewWithRefesh: function () {
    this.call("closeWebviewWithRefesh", {}, null);
  },
     shareToWeChat: function (args) {
         this.call("shareToWeChat", args, function(){});
     },
          openQuickReply: function (args, cb) {
              this.call("openQuickReply", args, cb);
          },
  //打开评价
  openEvaluation: function (args) {
      this.call("openEvaluation", args, null);
  },
  //检查升级
  settingsUpdate: function (args) {
      this.call("settingsUpdate", args, null);
  },
  //获取医生是否有视频通话的能力
 getVideoCapability: function (args) {
      this.call("getVideoCapability", args, null);
 },
 //判断是否为新版本
 isNewVersion: function (args, cb) {
      this.call("isNewVersion", args, cb);
 },
    //获取已安装的所有地图app
    getInstalledMapApps: function (cb) {
        console.log("getInstalledMapApps clicked")
        this.call("getInstalledMapApps", {}, cb);
    },
    //打开地图到指定位置
    openMapTo: function (args) {
        console.log("openMapTo clicked")
        this.call("openMapTo", args, null);
    },
    openWebview: function (args) {
        console.log("openWebview clicked")
        this.call("openWebview", args, null);
    },
    reloadWebView: function (args) {
        console.log("reloadWebView clicked")
        this.call("reloadWebView", args, null);
    },
    waitJobUnReadSub: function (args) {
        console.log("waitJobUnReadSub clicked")
        this.call("waitJobUnReadSub", args, null);
    },
    openReicpe: function (args) {
        console.log("openReicpe clicked")
        this.call("openReicpe", args, null);
    },provideAdvice: function (args) {
            console.log("provideAdvice clicked")
            this.call("provideAdvice", args, null);
    },
    goD2PChat: function (args) {
        console.log("goD2PChat clicked")
        this.call("goD2PChat", args, null);
    },
    goFreeClinicVC: function (args) {
         console.log("goFreeClinicVC clicked")
         this.call("goFreeClinicVC", args, null);
    },
    familyAudit: function (args) {
         console.log("familyAudit clicked")
         this.call("familyAudit", args, null);
    },
        //视频呼叫医生
        callDoctor: function (args) {
            console.log("callDoctor clicked")
            this.call("callDoctor", args, null);
        },
        getAnychatStatus: function (cb) {
                console.log("getAnychatStatus")
                this.call("getAnychatStatus", {}, cb);
           },
        openDoctorReviewPage: function (cb) {
                    console.log("openDoctorReviewPage")
                    this.call("openDoctorReviewPage", {}, cb);
        },
        callXiaoDu: function (args) {
                        console.log("callXiaoDu")
                        this.call("callXiaoDu", args, null);
        },
        updateRedPoint: function (args) {
             this.call("updateRedPoint", args, function(){});
        },
        openCommonWebView: function (args) {
             this.call("openCommonWebView", args, function(){});
        },
          //IM对话
          goCall: function (args) {
            this.call("goCall", args, null);
          },
          //打开mdt视频会议
         goMdtVideo: function (args, cb) {
             this.call("goMdtVideo", args, cb);
         },
         //关闭mdt视频会议
         leaveMdtVideo: function (args, cb) {
              this.call("leaveMdtVideo", args, cb);
          },
          sharePicToWeChat: function (args, cb) {
            this.call("sharePicToWeChat", args, cb)
          },
          startBlueTooth: function () {
            console.log("startBlueTooth")
            this.call("startBlueTooth", {}, function(){})
          },
          getConnectedBleDevices: function (cb) {
             this.call("getConnectedBleDevices", {}, cb)
          },
          deleteBleDevice: function (args) {
              this.call("deleteBleDevice", args, function(){})
          },
          getBleResults: function (args, cb) {
               this.call("getBleResults", args, cb)
           },
  ///////////////////XIKANG自定义功能end///////////////////////////////////
};

!function () {
  if (window._dsf) return;
  var ob = {
    _dsf: {
      _obs: {}
    },
    _dsaf: {
      _obs: {}
    },
    dscb: 0,
    dsBridge: XKBridge,
    close: function () {
      XKBridge.call("_dsb.closePage")
    },
    _handleMessageFromNative: function (info) {
      var arg = JSON.parse(info.data);
      var ret = {
        id: info.callbackId,
        complete: true
      }
      var f = this._dsf[info.method];
      var af = this._dsaf[info.method]
      var callSyn = function (f, ob) {
        ret.data = f.apply(ob, arg)
        XKBridge.call("_dsb.returnValue", ret)
      }
      var callAsyn = function (f, ob) {
        arg.push(function (data, complete) {
          ret.data = data;
          ret.complete = complete !== false;
          XKBridge.call("_dsb.returnValue", ret)
        })
        f.apply(ob, arg)
      }
      if (f) {
        callSyn(f, this._dsf);
      } else if (af) {
        callAsyn(af, this._dsaf);
      } else {
        //with namespace
        var name = info.method.split('.');
        if (name.length < 2) return;
        var method = name.pop();
        var namespace = name.join('.')
        var obs = this._dsf._obs;
        var ob = obs[namespace] || {};
        var m = ob[method];
        if (m && typeof m == "function") {
          callSyn(m, ob);
          return;
        }
        obs = this._dsaf._obs;
        ob = obs[namespace] || {};
        m = ob[method];
        if (m && typeof m == "function") {
          callAsyn(m, ob);
          return;
        }
      }
    }
  }
  for (var attr in ob) {
    window[attr] = ob[attr]
  }
  XKBridge.register("_hasJavascriptMethod", function (method, tag) {
    var name = method.split('.')
    if (name.length < 2) {
      return !!(_dsf[name] || _dsaf[name])
    } else {
      // with namespace
      var method = name.pop()
      var namespace = name.join('.')
      var ob = _dsf._obs[namespace] || _dsaf._obs[namespace]
      return ob && !!ob[method]
    }
  })
}();

    var event = new Event('XKBridgeReady');
    if (window.dispatchEvent) {
    window.dispatchEvent(event);
    } else {
    window.fireEvent(event);
    }

//export default bridge;

