#ifndef _BASIC_STRUCTURES_FXH_
#define _BASIC_STRUCTURES_FXH_


#ifdef __cplusplus

#   ifndef BOOL
#      define BOOL int32_t // Do not use bool, because sizeof(bool)==1 !
#   endif

#   ifndef CHECK_STRUCT_ALIGNMENT
        // Note that defining empty macros causes GL shader compilation error on Mac, because
        // it does not allow standalone semicolons outside of main.
        // On the other hand, adding semicolon at the end of the macro definition causes gcc error.
#       define CHECK_STRUCT_ALIGNMENT(s) static_assert( sizeof(s) % 16 == 0, "sizeof(" #s ") is not multiple of 16" )
#   endif

#   ifndef DEFAULT_VALUE
#       define DEFAULT_VALUE(x) =x
#   endif

#else

#   ifndef BOOL
#       define BOOL bool
#   endif

#   ifndef DEFAULT_VALUE
#       define DEFAULT_VALUE(x)
#   endif

#endif


struct CascadeAttribs
{
	float4 f4LightSpaceScale;
	float4 f4LightSpaceScaledBias;
    float4 f4StartEndZ;

    // Cascade margin in light projection space ([-1, +1] x [-1, +1] x [-1(GL) or 0, +1])
    float4 f4MarginProjSpace;
};
#ifdef CHECK_STRUCT_ALIGNMENT
    CHECK_STRUCT_ALIGNMENT(CascadeAttribs);
#endif

#define SHADOW_MODE_PCF 1
#define SHADOW_MODE_VSM 2
#define SHADOW_MODE_EVSM2 3
#define SHADOW_MODE_EVSM4 4
#define SHADOW_MODE_NOSM 5
#ifndef SHADOW_MODE
#   define SHADOW_MODE SHADOW_MODE_PCF
#endif

#define MAX_CASCADES 8
struct ShadowMapAttribs
{
    // 0
#ifdef __cplusplus
    float4x4 mWorldToLightViewT; // Matrices in HLSL are COLUMN-major while float4x4 is ROW major
#else
    matrix mWorldToLightView;  // Transform from view space to light projection space
#endif
    // 16
    CascadeAttribs Cascades[MAX_CASCADES];

#ifdef __cplusplus
    float4x4 mWorldToShadowMapUVDepthT[MAX_CASCADES];
    float fCascadeCamSpaceZEnd[MAX_CASCADES];
#else
    matrix mWorldToShadowMapUVDepth[MAX_CASCADES];
    float4 f4CascadeCamSpaceZEnd[MAX_CASCADES/4];
#endif

    float4 f4ShadowMapDim;    // Width, Height, 1/Width, 1/Height

    // Number of shadow cascades
    int   iNumCascades                  DEFAULT_VALUE(0);
    float fNumCascades                  DEFAULT_VALUE(0);
    // Do not use bool, because sizeof(bool)==1 !
	BOOL  bVisualizeCascades            DEFAULT_VALUE(0);
    BOOL  bVisualizeShadowing           DEFAULT_VALUE(0);

    float fReceiverPlaneDepthBiasClamp  DEFAULT_VALUE(10);
    float fFixedDepthBias               DEFAULT_VALUE(1e-5f);
    float fCascadeTransitionRegion      DEFAULT_VALUE(0.1f);
    int   iMaxAnisotropy                DEFAULT_VALUE(4);

    float fVSMBias                      DEFAULT_VALUE(1e-4f);
    float fVSMLightBleedingReduction    DEFAULT_VALUE(0);
    float fEVSMPositiveExponent         DEFAULT_VALUE(40);
    float fEVSMNegativeExponent         DEFAULT_VALUE(5);

    BOOL  bIs32BitEVSM                  DEFAULT_VALUE(1);
    int   iFixedFilterSize              DEFAULT_VALUE(3); // 3x3 filter
    float fFilterWorldSize              DEFAULT_VALUE(0);
    bool fDummy;

    float pad2;
};
#ifdef CHECK_STRUCT_ALIGNMENT
    CHECK_STRUCT_ALIGNMENT(ShadowMapAttribs);
#endif
struct PointLightAttribs
{
	float3 mPosition;
	float mRange;

	float3 mColor;
	float pad;

	float3 mIntensity;
	float mAtt;
};
struct SkyLightAttribs
{
float3 mDirection;
float pad1;

float3 mIntensity; 
float pad2;

float3 mColor;
float pad3;
};
struct SpotLightAttribs
{
float3 mDirection;
float mSpot;

float mAtt;
float mRange;
float2 pad0;
    
float3 mPosition;
float pad1;

float3 mIntensity;
float pad2;

float3 mColor;
float pad3;
};

struct ToonAttribute
{
    float4 SpecCube_HDR; //(1,1,1,1)
    float4 GlossyEnvironmentColor; //(1,1,1,1)
    float4 FristShadeColor; //(1,1,1,1)
    float4 SecondShadeColor; //(1,1,1,1)
    float4 BaseColor; //   _BaseColor ("BaseColor", Color) = (1,1,1,1)
    float4 Emissive_Color; //("Emissive_Color", Color) = (0,0,0,1)
    //float4 Time; // x: t/20,           y: t,        z: t*2,       w: t*3
    float4 ColorShift; //_ColorShift ("ColorSift", Color) = (0,0,0,1)
    float4 ViewShift; // ("ViewSift", Color) = (0,0,0,1)
    float4 Metalic; //(1,1,1)
    float4 HighColor; //(0,0,0,1)
    float4 RimLightColor; //("RimLightColor", Color) = (1,1,1,1)
    float4 Ap_RimLightColor; // ("Ap_RimLightColor", Color) = (1,1,1,1)
    float4 MatCapColor; //("MatCapColor", Color) = (1,1,1,1)
    float BumpScale; //_BumpScale ("Normal Scale", Range(0, 1)) = 1
    float Smoothness; //(1)
    float OcclusionStrength; //(1)
    float Is_LightColor_Base; //("Is_LightColor_Base", Float ) = 1
    float Use_BaseAs1st; //("Use BaseMap as 1st_ShadeMap", Float ) = 0
    float Is_LightColor_1st_Shade; //("Is_LightColor_1st_Shade", Float ) = 1
    float Is_LightColor_2nd_Shade; //("Is_LightColor_2nd_Shade", Float ) = 1
    float Use_1stAs2nd; //("Use 1st_ShadeMap as 2nd_ShadeMap", Float ) = 0
    float Is_NormalMapToBase; // ("Is_NormalMapToBase", Float ) = 0
    float Tweak_SystemShadowsLevel; // ("Tweak_SystemShadowsLevel", Range(-0.5, 0.5)) = 0
    float Set_SystemShadowsToBase; // _Set_SystemShadowsToBase ("Set_SystemShadowsToBase", Float ) = 1
    float BaseColor_Step; //("BaseColor_Step", Range(0, 1)) = 0.5
    float BaseShade_Feather; //("Base/Shade_Feather", Range(0.0001, 1)) = 0.0001
    float ShadeColor_Step; //("ShadeColor_Step", Range(0, 1)) = 0
    float FstSnd_Shades_Feather; //("1st/2nd_Shades_Feather", Range(0.0001, 1)) = 0.0001
    float BlurLevelMatcap; //("Blur Level of MatCap_Sampler", Range(0, 10)) = 0
    float Is_NormalMapToHighColor; //("Is_NormalMapToHighColor", Float ) = 0
    float Tweak_HighColorMaskLevel; //("Tweak_HighColorMaskLevel", Range(-1, 1)) = 0
    float HighColor_Power; // ("HighColor_Power", Range(0, 1)) = 0
    float Is_SpecularToHighColor; //("Is_SpecularToHighColor", Float ) = 0
    float Is_LightColor_HighColor; // ("Is_LightColor_HighColor", Float ) = 1
    float Is_BlendAddToHiColor; //("Is_BlendAddToHiColor", Float ) = 0
    float TweakHighColorOnShadow; // ("TweakHighColorOnShadow", Range(0, 1)) = 0
    float Is_UseTweakHighColorOnShadow; // ("Is_UseTweakHighColorOnShadow", Float ) = 0
    float Is_LightColor_RimLight; //("Is_LightColor_RimLight", Float ) = 1
    float Is_NormalMapToRimLight; //("Is_NormalMapToRimLight", Float ) = 0
    float RimLight_Power; // ("RimLight_Power", Range(0, 1)) = 0.1
    float RimLight_InsideMask; //("RimLight_InsideMask", Range(0.0001, 1)) = 0.0001
    float RimLight_FeatherOff; //("RimLight_FeatherOff", Float ) = 0
    float Tweak_LightDirection_MaskLevel; //("Tweak_LightDirection_MaskLevel", Range(0, 0.5)) = 0
    float LightDirection_MaskOn; // ("LightDirection_MaskOn", Float ) = 0
    float Ap_RimLight_Power; // ("Ap_RimLight_Power", Range(0, 1)) = 0.1
    float Tweak_RimLightMaskLevel; // ("Tweak_RimLightMaskLevel", Range(-1, 1)) = 0
    float Is_LightColor_Ap_RimLight; // ("Is_LightColor_Ap_RimLight", Float ) = 1
    float Ap_RimLight_FeatherOff; // ("Ap_RimLight_FeatherOff", Float ) = 0
    float Add_Antipodean_RimLight; //("Add_Antipodean_RimLight", Float ) = 0
    float RimLight; // ("RimLight", Float ) = 0
    float Rotate_MatCapUV; // ("Rotate_MatCapUV", Range(-1, 1)) = 0
    float CameraRolling_Stabilizer; //("Activate CameraRolling_Stabilizer", Float ) = 0
    float Rotate_NormalMapForMatCapUV; //("Rotate_NormalMapForMatCapUV", Range(-1, 1)) = 0
    float BumpScaleMatcap; //("Scale for NormalMapforMatCap", Range(0, 1)) = 1
    float Is_NormalMapForMatCap; //_Is_NormalMapForMatCap ("Is_NormalMapForMatCap", Float ) = 0
    float Is_Ortho; //("Orthographic Projection for MatCap", Float ) = 0
    float Tweak_MatCapUV; //("Tweak_MatCapUV", Range(-0.5, 0.5)) = 0
    float MatCap; // ("MatCap", Float ) = 0
    float TweakMatCapOnShadow; // ("TweakMatCapOnShadow", Range(0, 1)) = 0
    float Inverse_MatcapMask; // ("Inverse_MatcapMask", Float ) = 0
    float Tweak_MatcapMaskLevel; // ("Tweak_MatcapMaskLevel", Range(-1, 1)) = 0
    float Is_LightColor_MatCap; //("Is_LightColor_MatCap", Float ) = 1
    float Is_UseTweakMatCapOnShadow; //("Is_UseTweakMatCapOnShadow", Float ) = 0
    float Is_BlendAddToMatCap; //("Is_BlendAddToMatCap", Float ) = 1
    float StepOffset; //("Step_Offset (ForwardAdd Only)", Range(-0.5, 0.5)) = 0
    float Is_Filter_HiCutPointLightColor; //("PointLights HiCut_Filter (ForwardAdd Only)", Float ) = 1
    float Is_ViewCoord_Scroll; // ("Is_ViewCoord_Scroll", Float ) = 0
    float Base_Speed; // ("Base_Speed", Float ) = 0
    float Is_PingPong_Base; // ("Is_PingPong_Base", Float ) = 0
    float Scroll_EmissiveU; //("Scroll_EmissiveU", Range(-1, 1)) = 0
    float Scroll_EmissiveV; //("Scroll_EmissiveV", Range(-1, 1)) = 0
    float Rotate_EmissiveUV; // ("Rotate_EmissiveUV", Float ) = 0
    float ColorShift_Speed; //("ColorShift_Speed", Float ) = 0
    float Is_ColorShift; //_Is_ColorShift ("Activate ColorShift", Float ) = 0
    float Is_Filter_LightColor; // _Is_Filter_LightColor ("VRChat : SceneLights HiCut_Filter", Float ) = 0
    float Is_ViewShift; // ("Activate ViewShift", Float ) = 0
    float GI_Intensity; //("GI_Intensity", Range(0, 1)) = 0
    float Inverse_Clipping; //("Inverse_Clipping", Float) = 0
    float Clipping_Level; // ("Clipping_Level", Range(0, 1)) = 0
    float IsBaseMapAlphaAsClippingMask; // ("IsBaseMapAlphaAsClippingMask", Float) = 0
    float Tweak_transparency; // ("Tweak_transparency", Range(-1, 1)) = 0
    int DebugViewType;
    float3 pad1;
};

struct LightAttribs
{

    SkyLightAttribs skylight;
    PointLightAttribs pointlights[3];
    SpotLightAttribs spotlights[3];
	int mPointlightCount;
	int mSpotlightCount;
	float pad;
	float pad1;
    ShadowMapAttribs ShadowAttribs;
};

#ifdef CHECK_STRUCT_ALIGNMENT
    CHECK_STRUCT_ALIGNMENT(LightAttribs);
#endif

struct CameraAttribs
{
    float4 f4Position;     // Camera world position
    float4 f4ViewportSize; // (width, height, 1/width, 1/height)

    float2 f2ViewportOrigin; // (min x, min y)
    float fNearPlaneZ; 
    float fFarPlaneZ; // fNearPlaneZ < fFarPlaneZ

#ifdef __cplusplus
    float4x4 mViewT;
    float4x4 mProjT;
    float4x4 mViewProjT;
    float4x4 mViewInvT;
    float4x4 mProjInvT;
    float4x4 mViewProjInvT;
#else
    matrix mView;
    matrix mProj;
    matrix mViewProj;
    matrix mViewInv;
    matrix mProjInv;
    matrix mViewProjInv;
#endif

    float4 f4ExtraData[5]; // Any appliation-specific data
    // Sizeof(CameraAttribs) == 256*2
};
#ifdef CHECK_STRUCT_ALIGNMENT
    CHECK_STRUCT_ALIGNMENT(CameraAttribs);
#endif

#endif //_BASIC_STRUCTURES_FXH_
