#ifndef _GLTF_PBR_SHADING_FXH_
#define _GLTF_PBR_SHADING_FXH_

#include "GLTF_PBR_Structures.fxh"
#include "PBR_Common.fxh"
#include "ShaderUtilities.fxh"

#ifndef GLTF_PBR_MANUAL_SRGB
#   define  GLTF_PBR_MANUAL_SRGB    1
#endif

#ifndef SRGB_FAST_APPROXIMATION
#   define  SRGB_FAST_APPROXIMATION 1
#endif
#define GLTF_PBR_USE_ENV_MAP_LOD
#define GLTF_PBR_USE_HDR_CUBEMAPS

//#ifdef GLTF_PBR_USE_TANGENT
//#   define  GLTF_PBR_USE_TANGENT    1
//#endif

#ifdef GLTF_PBR_USE_SHEEN
#   define  GLTF_PBR_USE_SHEEN    1
#endif

static matrix Idmatrix =(matrix(1.0));

float GetPerceivedBrightness(float3 rgb)
{
    return sqrt(0.299 * rgb.r * rgb.r + 0.587 * rgb.g * rgb.g + 0.114 * rgb.b * rgb.b);
}

// https://github.com/KhronosGroup/glTF/blob/master/extensions/2.0/Khronos/KHR_materials_pbrSpecularGlossiness/examples/convert-between-workflows/js/three.pbrUtilities.js#L34
float GLTF_PBR_SolveMetallic(float3 diffuse,
                             float3 specular,
                             float  oneMinusSpecularStrength)
{
    const float c_MinReflectance = 0.04;
    float specularBrightness = GetPerceivedBrightness(specular);
    if (specularBrightness < c_MinReflectance)
    {
        return 0.0;
    }

    float diffuseBrightness = GetPerceivedBrightness(diffuse);

    float a = c_MinReflectance;
    float b = diffuseBrightness * oneMinusSpecularStrength / (1.0 - c_MinReflectance) + specularBrightness - 2.0 * c_MinReflectance;
    float c = c_MinReflectance - specularBrightness;
    float D = b * b - 4.0 * a * c;

    return clamp((-b + sqrt(D)) / (2.0 * a), 0.0, 1.0);
}


float3 SRGBtoLINEAR(float3 srgbIn)
{
#ifdef GLTF_PBR_MANUAL_SRGB
#   ifdef SRGB_FAST_APPROXIMATION
    	float3 linOut = pow(saturate(srgbIn.xyz), float3(2.2, 2.2, 2.2));
#   else
	    float3 bLess  = step(float3(0.04045, 0.04045, 0.04045), srgbIn.xyz);
	    float3 linOut = mix( srgbIn.xyz/12.92, pow(saturate((srgbIn.xyz + float3(0.055, 0.055, 0.055)) / 1.055), float3(2.4, 2.4, 2.4)), bLess );
#   endif
	    return linOut;
#else
	return srgbIn;
#endif
}

float4 SRGBtoLINEAR(float4 srgbIn)
{
    return float4(SRGBtoLINEAR(srgbIn.xyz), srgbIn.w);
}



struct GLTF_PBR_Light_Contribution
{
    float3 f3Diffuse;
    float3 f3Specular;
	float3 f3clearcoat;
	float3 clearcoatFresnel;
    float3 sheencolor;
    float3 transmissioncolor;
    float3 SSS;
    float3 Furspec;
};
 void ApplyDirectionalLight(
 out GLTF_PBR_Light_Contribution Light,
 float3 lightDir, 
 float3 lightColor,
 float3 lightIntensity,
 SurfaceReflectanceInfo srfInfo,
 MaterialInfo materialInfo, 
 float3 normal,
 float3 tangent,
 float3 bittangent, 
 float3 view)
{

    Light.f3Diffuse = float3(0.0, 0.0, 0.0);
    Light.f3Specular = float3(0.0, 0.0, 0.0);
    Light.f3clearcoat = float3(0.0, 0.0, 0.0);
    Light.clearcoatFresnel = float3(0.0, 0.0, 0.0);
    Light.sheencolor = float3(0.0, 0.0, 0.0);
    Light.transmissioncolor = float3(0.0, 0.0, 0.0);
    Light.SSS = float3(0.0, 0.0, 0.0);
    Light.Furspec = float3(0.0, 0.0, 0.0);
    float3 pointToLight = -lightDir;
    float3 diffuseContrib, specContrib, clearcoat, clearcoatFresnel, sheencolor, transmissioncolor, sss, furspec;
    float  NdotL;
    BRDF(pointToLight, normal, tangent, bittangent, view, srfInfo, materialInfo, diffuseContrib, 
    specContrib, clearcoat, clearcoatFresnel, sheencolor, transmissioncolor, sss,furspec,NdotL);
    // Obtain final intensity as reflectance (BRDF) scaled by the energy of the light (cosine law)
   // float3 shade = (diffuseContrib + specContrib) * NdotL;
    Light.f3Diffuse += (diffuseContrib) * NdotL * lightIntensity * lightColor;
    Light.f3Specular += (specContrib) * NdotL * lightIntensity * lightColor ;
    Light.f3clearcoat = clearcoat * NdotL * lightIntensity;
    Light.clearcoatFresnel = clearcoatFresnel;
    Light.sheencolor += sheencolor * lightIntensity * lightColor;
    Light.transmissioncolor += transmissioncolor * lightIntensity;
    Light.Furspec+= furspec;
 
}

void ApplyPointLight(
out GLTF_PBR_Light_Contribution Light,
 float3 worldpos,
float3 lightPos, 
float3 lightColor,
float3 lightIntensity, 
float range,
float Att,
SurfaceReflectanceInfo srfInfo,
MaterialInfo materialInfo, 
float3 normal,
float3 tangent,
float3 bittangent, 
float3 view)
{
    Light.f3Diffuse = float3(0.0, 0.0, 0.0);
    Light.f3Specular = float3(0.0, 0.0, 0.0);
    Light.f3clearcoat = float3(0.0, 0.0, 0.0);
    Light.clearcoatFresnel = float3(0.0, 0.0, 0.0);
    Light.sheencolor = float3(0.0, 0.0, 0.0);
    Light.transmissioncolor = float3(0.0, 0.0, 0.0);
    Light.SSS = float3(0.0, 0.0, 0.0);
    Light.Furspec = float3(0.0, 0.0, 0.0);
    float3 pointToLight = lightPos-worldpos;
  
	float d=length(pointToLight);
	if(d>range)
	{
	Light.f3Diffuse+=float3(0.0,0.0,0.0);
    Light.f3Specular+=float3(0.0,0.0,0.0);
	Light.f3clearcoat+=float3(0.0,0.0,0.0);
	Light.clearcoatFresnel+=float3(0.0,0.0,0.0);
    Light.sheencolor+= float3(0.0, 0.0, 0.0);
    Light.transmissioncolor+= float3(0.0, 0.0, 0.0);
    Light.SSS= float3(0.0, 0.0, 0.0);
    Light.Furspec = float3(0.0, 0.0, 0.0);
        return;
    }

	
    float3 diffuseContrib, specContrib, clearcoat, clearcoatFresnel, sheencolor, transmissioncolor, sss,furspec;
    float  NdotL;
    BRDF(pointToLight, normal, tangent, bittangent, view, srfInfo, materialInfo, diffuseContrib, specContrib,
    clearcoat, clearcoatFresnel, sheencolor, transmissioncolor, sss, furspec,NdotL);
    // Obtain final intensity as reflectance (BRDF) scaled by the energy of the light (cosine law)
    float3 shade = (diffuseContrib + specContrib) * NdotL;
	float att = 1.0f / dot(float3(Att,Att,Att), float3(1.0f, d, d * d));
	
    Light.f3Diffuse = (diffuseContrib) * NdotL * lightIntensity * att * lightColor;
    Light.f3Specular = (specContrib) * NdotL * lightIntensity * att * lightColor;
    Light.f3clearcoat= clearcoat * NdotL * lightIntensity * att;
    Light.clearcoatFresnel= clearcoatFresnel;
    Light.sheencolor = sheencolor * lightIntensity * att * lightColor;
    Light.transmissioncolor= float3(0.0, 0.0, 0.0);
    Light.SSS = sss * lightColor * lightIntensity*att;
    Light.Furspec += furspec * lightIntensity * att;
}

void ApplySpotLight(
out GLTF_PBR_Light_Contribution Light,
float3 worldpos,
float3 direction,
float lightspot,
float3 lightPos,
float3 lightColor,
float3 lightIntensity, 
float range,
float Att,
SurfaceReflectanceInfo srfInfo, 
MaterialInfo materialInfo,
float3 normal,
float3 tangent,
float3 bittangent, 
float3 view)
{
    Light.f3Diffuse = float3(0.0, 0.0, 0.0);
    Light.f3Specular = float3(0.0, 0.0, 0.0);
    Light.f3clearcoat = float3(0.0, 0.0, 0.0);
    Light.clearcoatFresnel = float3(0.0, 0.0, 0.0);
    Light.sheencolor = float3(0.0, 0.0, 0.0);
    Light.transmissioncolor = float3(0.0, 0.0, 0.0);
    Light.SSS = float3(0.0, 0.0, 0.0);
    Light.Furspec = float3(0.0, 0.0, 0.0);
    float3 SpotToLight = lightPos-worldpos;
 
	float d=length(SpotToLight);
	if(d>range)
	{
        Light.f3Diffuse+= float3(0.0, 0.0, 0.0);
        Light.f3Specular+= float3(0.0, 0.0, 0.0);
        Light.f3clearcoat+= float3(0.0, 0.0, 0.0);
        Light.clearcoatFresnel+= float3(0.0, 0.0, 0.0);
        Light.sheencolor+= float3(0.0, 0.0, 0.0);
        Light.transmissioncolor+= float3(0.0, 0.0, 0.0);
        Light.SSS += float3(0.0, 0.0, 0.0);
        Light.Furspec = float3(0.0, 0.0, 0.0);
        return;
    }
	
    float3 diffuseContrib, specContrib, clearcoat, clearcoatFresnel, sheencolor, transmissioncolor, sss, furspec;
    float  NdotL;
    BRDF(SpotToLight, normal, tangent, bittangent, view, srfInfo, materialInfo, diffuseContrib,
    specContrib, clearcoat, clearcoatFresnel, sheencolor, transmissioncolor, sss,furspec,NdotL);
    // Obtain final intensity as reflectance (BRDF) scaled by the energy of the light (cosine law)
    float3 shade = (diffuseContrib + specContrib) * NdotL;
    float spot=pow(max(dot(-SpotToLight,direction),0.0),lightspot);
	float att = spot/ dot(float3(Att,Att,Att), float3(1.0f, d, d * d));
    Light.f3Diffuse = (diffuseContrib) * NdotL * lightIntensity * att * lightColor;
    Light.f3Specular = (specContrib) * NdotL * lightIntensity * att * lightColor;
    Light.f3clearcoat = clearcoat * NdotL * lightIntensity * att * lightColor;
    Light.clearcoatFresnel= clearcoatFresnel;
    Light.sheencolor = sheencolor * lightIntensity * att * lightColor;
    Light.transmissioncolor= float3(0.0, 0.0, 0.0);
    Light.SSS = sss * lightColor * lightIntensity * att;
    Light.Furspec += furspec * lightIntensity * att;
	//return Light;
    //return lightColor * shade*lightIntensity*att;
}

// Find the normal for this fragment, pulling either from a predefined normal map
// or from the interpolated mesh normal and tangent attributes.
float3 GLTF_PBR_PerturbNormal(in float3 dPos_dx,
                              in float3 dPos_dy,
                              in float2 dUV_dx,
                              in float2 dUV_dy,
                              in float3 Normal,
                              in float3 TSNormal,
                              bool      HasUV,
                              bool      IsFrontFace)
{
    // Retrieve the tangent space matrix
    float NormalLen = length(Normal);
    float3 ng;
    if (NormalLen > 1e-5)
    {
        ng = Normal/NormalLen;
    }
    else
    {
        ng = normalize(cross(dPos_dx, dPos_dy));
#if (defined(GLSL) || defined(GL_ES)) && !defined(VULKAN)
        // In OpenGL screen is upside-down, so we have to invert the vector
        ng *= -1.0;
#endif
    }
	
    if (HasUV)
   {
        return TransformTangentSpaceNormalGrad(dPos_dx, dPos_dy, dUV_dx, dUV_dy, ng, TSNormal * (IsFrontFace ? +1.0 : -1.0));
   }
    else
    {
        return ng * (IsFrontFace ? +1.0 : -1.0);
    }
}



void Toon_PerturbNormal(in float3 dPos_dx,
                              in float3 dPos_dy,
                              in float2 dUV_dx,
                              in float2 dUV_dy,
                              in float3 Normal,
                              in float3 TSNormal,
out float3 Pnormal,
out float3x3 transform,
                              bool HasUV,
                              bool IsFrontFace)
{
    // Retrieve the tangent space matrix
    float NormalLen = length(Normal);
    float3 ng;
    if (NormalLen > 1e-5)
    {
        ng = Normal / NormalLen;
    }
    else
    {
        ng = normalize(cross(dPos_dx, dPos_dy));
#if (defined(GLSL) || defined(GL_ES)) && !defined(VULKAN)
        // In OpenGL screen is upside-down, so we have to invert the vector
        //ng *= -1.0;
#endif
    }

    if (HasUV)
    {
        ToonTransformTangentSpaceNormalGrad(dPos_dx, dPos_dy, dUV_dx, dUV_dy, ng, TSNormal * (IsFrontFace ? +1.0 : -1.0), Pnormal, transform);
    }
    else
    {
        ng * (IsFrontFace ? +1.0 : -1.0);
    }
}

float3 GLTF_PBR_PerturbTangent(in float3 dPos_dx,
                              in float3 dPos_dy,
                              in float2 dUV_dx,
                              in float2 dUV_dy,
                              in float3 Normal,
                              in float3 Tangent,
                              bool      HasUV,
                              bool      IsFrontFace)
{
    // Retrieve the tangent space matrix
    float NormalLen = length(Normal);
    float3 ng;
    if (NormalLen > 1e-5)
    {
        ng = Normal/NormalLen;
    }
    else
    {
        ng = normalize(cross(dPos_dx, dPos_dy));
#if (defined(GLSL) || defined(GL_ES)) && !defined(VULKAN)
        // In OpenGL screen is upside-down, so we have to invert the vector
        //ng *= -1.0;
#endif
    }

    if (HasUV)
    {
        return TransformTangentSpaceTangentGrad(dPos_dx, dPos_dy, dUV_dx, dUV_dy, ng, Tangent * (IsFrontFace ? +1.0 : -1.0));
    }
    else
    {
        return ng * (IsFrontFace ? +1.0 : -1.0);
    }
}

float max3(float3 v)
{
    return max(max(v.x, v.y), v.z);
}

struct GLTF_PBR_IBL_Contribution
{
    float3 f3Diffuse;
    float3 f3Specular;
	float3 f3clearcoat;
};
struct GLTF_SHEEN_IBL_Contribution
{
    float3 sheeniblight;
    float albedoSheenScaling;
 
};
// Calculation of the lighting contribution from an optional Image Based Light source.
// Precomputed Environment Maps are required uniform inputs and are computed as outlined in [1].
// See our README.md on Environment Maps [3] for additional discussion.
GLTF_SHEEN_IBL_Contribution GLTF_PBR_GetIBLSheenContribution(
                        in float3 n,
                        in float3 v,
                        in float3 l,
						in MaterialInfo materialInfo,
                        in float PrefilteredCubeMipLevels,
                        in Texture2D CharlieLUT,
                        in SamplerState CharlieLUT_sampler,
                        in Texture2D SheenLUT,
                        in SamplerState SheenLUT_sampler,
                        in TextureCube SheenMap,
                        in SamplerState SheenMap_sampler
                       )
{
    

    float NdotV = clamp(dot(n, v), 0.0, 1.0);

    float lod = clamp(materialInfo.SheenRoughness * PrefilteredCubeMipLevels, 0.0, PrefilteredCubeMipLevels);
	
    float3 reflection = float3(0.0, 0.0, 0.0);
    reflection = normalize(reflect(-v, n));

    float2 brdfSamplePoint = clamp(float2(NdotV, materialInfo.SheenRoughness), float2(0.0, 0.0), float2(1.0, 1.0));
 
    float brdf = CharlieLUT.Sample(CharlieLUT_sampler, brdfSamplePoint).b;
    GLTF_SHEEN_IBL_Contribution IBL;
    float3 sheeniblight = SheenMap.SampleLevel(SheenMap_sampler, reflection, lod).rgb;
   
    IBL.sheeniblight = sheeniblight*materialInfo.SheenColor * brdf;
   
    float3 light = normalize(-l);
    float NdotL = clamp(dot(n, light), 0.0, 1.0);
   
    float albedoSheenScalingLUTa = SheenLUT.Sample(SheenLUT_sampler, float2(NdotV, materialInfo.SheenRoughness)).r;
    float albedoSheenScalingLUTb = SheenLUT.Sample(SheenLUT_sampler, float2(NdotL, materialInfo.SheenRoughness)).r;

    IBL.albedoSheenScaling = min(1.0 - max3(materialInfo.SheenColor) * albedoSheenScalingLUTa,
                1.0 - max3(materialInfo.SheenColor) * albedoSheenScalingLUTb);
  
    return IBL;

}



// Calculation of the lighting contribution from an optional Image Based Light source.
// Precomputed Environment Maps are required uniform inputs and are computed as outlined in [1].
// See our README.md on Environment Maps [3] for additional discussion.
GLTF_PBR_IBL_Contribution GLTF_PBR_GetIBLClearcoatContribution(
                        in SurfaceReflectanceInfo SrfInfo,
                        in float3                 n,
                        in float3                 v,	
						in MaterialInfo           materialInfo,
                        in float                  PrefilteredCubeMipLevels,
                        in Texture2D              BRDF_LUT,
                        in SamplerState           BRDF_LUT_sampler,
                        in TextureCube            IrradianceMap,
                        in SamplerState           IrradianceMap_sampler,
                        in TextureCube            PrefilteredEnvMap,
                        in SamplerState           PrefilteredEnvMap_sampler)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);

    float lod = clamp(materialInfo.ClearCoatRounghness * PrefilteredCubeMipLevels, 0.0, PrefilteredCubeMipLevels);
	
	float3 reflection=float3(0.0,0.0,0.0);
    reflection = normalize(reflect(-v, n));

    float2 brdfSamplePoint = clamp(float2(NdotV, materialInfo.ClearCoatRounghness), float2(0.0, 0.0), float2(1.0, 1.0));
    // retrieve a scale and bias to F0. See [1], Figure 3
    float2 brdf = BRDF_LUT.Sample(BRDF_LUT_sampler, brdfSamplePoint).rg;

   // float4 diffuseSample = IrradianceMap.Sample(IrradianceMap_sampler, n);

#ifdef GLTF_PBR_USE_ENV_MAP_LOD
    float4 specularSample = PrefilteredEnvMap.SampleLevel(PrefilteredEnvMap_sampler, reflection, lod);
#else
    float4 specularSample = PrefilteredEnvMap.Sample(PrefilteredEnvMap_sampler, reflection);
#endif

#ifdef GLTF_PBR_USE_HDR_CUBEMAPS
    // Already linear.
    //float3 diffuseLight  = diffuseSample.rgb;
    float3 specularLight = specularSample.rgb;
#else
    //float3 diffuseLight  = SRGBtoLINEAR(diffuseSample).rgb;
    float3 specularLight = SRGBtoLINEAR(specularSample).rgb;
#endif

    GLTF_PBR_IBL_Contribution IBLContrib;
    IBLContrib.f3Diffuse  =float3(0.0,0.0,0.0);
    IBLContrib.f3Specular = specularLight * (SrfInfo.Reflectance0 * brdf.x + SrfInfo.Reflectance90 * brdf.y);
    return IBLContrib;
}


GLTF_PBR_IBL_Contribution GLTF_PBR_GetIBLContribution(
                        in SurfaceReflectanceInfo SrfInfo,
                        in float3                 n,
                        in float3                 v,
						in float3 				  t,
						in float3 				  b,	
						in MaterialInfo           materialInfo,
                        in float                  PrefilteredCubeMipLevels,
                        in Texture2D              BRDF_LUT,
                        in SamplerState           BRDF_LUT_sampler,
                        in TextureCube            IrradianceMap,
                        in SamplerState           IrradianceMap_sampler,
                        in TextureCube            PrefilteredEnvMap,
                        in SamplerState           PrefilteredEnvMap_sampler)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);

    float lod = clamp(SrfInfo.PerceptualRoughness * PrefilteredCubeMipLevels, 0.0, PrefilteredCubeMipLevels);
	float3 reflection=float3(0.0,0.0,0.0);
	#if PBR_Default||GLTF_PBR_USE_IRR||GLTF_PBR_USE_SHEEN
    reflection = normalize(reflect(-v, n));
	#endif

	#ifdef GLTF_PBR_USE_TANGENT
	 reflection = getReflectedfloattor(v, n, t,b, materialInfo.Anisotropic);
	 #endif
    float2 brdfSamplePoint = clamp(float2(NdotV, SrfInfo.PerceptualRoughness), float2(0.0, 0.0), float2(1.0, 1.0));
    // retrieve a scale and bias to F0. See [1], Figure 3
    float2 brdf = BRDF_LUT.Sample(BRDF_LUT_sampler, brdfSamplePoint).rg;

    float4 diffuseSample = IrradianceMap.Sample(IrradianceMap_sampler, n);

#ifdef GLTF_PBR_USE_ENV_MAP_LOD
    float4 specularSample = PrefilteredEnvMap.SampleLevel(PrefilteredEnvMap_sampler, reflection, 7.0);
#else
    float4 specularSample = PrefilteredEnvMap.Sample(PrefilteredEnvMap_sampler, reflection);
#endif

#ifdef GLTF_PBR_USE_HDR_CUBEMAPS
    // Already linear.
    float3 diffuseLight  = diffuseSample.rgb;
    float3 specularLight = specularSample.rgb;
#else
    float3 diffuseLight  = SRGBtoLINEAR(diffuseSample).rgb;
    float3 specularLight = SRGBtoLINEAR(specularSample).rgb;
#endif
    float3 iridescenceFresnel = float3(0.0f,0.0f,0.0f);
#ifdef GLTF_PBR_USE_IRR
    iridescenceFresnel = lerp(float3(0.0,0.0,0.0),fresnelIridescence( materialInfo.FilmThickness,materialInfo.BaseIor, materialInfo.KExtinction, NdotV),materialInfo.IridescenceMask);
#endif
    GLTF_PBR_IBL_Contribution IBLContrib;
    IBLContrib.f3Diffuse  = diffuseLight * SrfInfo.DiffuseColor;
    float3 fr = float3(1.0, 1.0, 1.0);
    fr = (SrfInfo.Reflectance0 * brdf.x + SrfInfo.Reflectance90 * brdf.y);
#ifdef GLTF_PBR_USE_IRR
    fr=lerp(SrfInfo.Reflectance0 * brdf.x + SrfInfo.Reflectance90 * brdf.y,iridescenceFresnel,materialInfo.IridescenceMask);
    IBLContrib.f3Specular = specularLight * fr;
    float3 iridescenceAttenuation = 1.0 - iridescenceFresnel * materialInfo.IridescenceMask;
    IBLContrib.f3Diffuse*=iridescenceAttenuation;
     IBLContrib.f3Specular *= iridescenceAttenuation * iridescenceAttenuation;
#endif
#if PBR_Default
    IBLContrib.f3Specular = specularLight* fr;
#endif
    IBLContrib.f3clearcoat = float3(0.0, 0.0, 0.0);
    return IBLContrib;
}



float3 GLTF_PBR_GetIBLTranmissionContribution(
                        in SurfaceReflectanceInfo SrfInfo,
                        in float3 n,
                        in float3 v,
                        in float3 BaseColor,  
                        in float3 position,
                        in float4x4 projMatrix,
						in MaterialInfo materialInfo,
                        in float PrefilteredCubeMipLevels,
                        in Texture2D BRDF_LUT,
                        in SamplerState BRDF_LUT_sampler,   
                        in Texture2D FrameMap,
                        in SamplerState FrameMap_sampler)
{
    
    float3 transmission=getIBLVolumeRefraction(
     n, v, SrfInfo.PerceptualRoughness,
    BaseColor, SrfInfo.Reflectance0,
    SrfInfo.Reflectance90, position, materialInfo.worldmatrix, projMatrix, materialInfo.BaseIor, materialInfo.thickness,
    materialInfo.attenuationColor, materialInfo.attenuationDistance, BRDF_LUT, BRDF_LUT_sampler,
    FrameMap, FrameMap_sampler, PrefilteredCubeMipLevels);

    return transmission;

}

/// Calculates surface reflectance info

/// \param [in]  Workflow     - PBR workflow (PBR_WORKFLOW_SPECULAR_GLOSINESS or PBR_WORKFLOW_METALLIC_ROUGHNESS).
/// \param [in]  BaseColor    - Material base color.
/// \param [in]  PhysicalDesc - Physical material description. For Metallic-roughness workflow,
///                             'g' channel stores roughness, 'b' channel stores metallic.
/// \param [out] Metallic     - Metallic value used for shading.
SurfaceReflectanceInfo GLTF_PBR_GetSurfaceReflectance(int        Workflow,
                                                      float4     BaseColor,
                                                      float4     PhysicalDesc,
                                                      out float  Metallic)
{
    SurfaceReflectanceInfo SrfInfo;

    float3 specularColor;

    float3 f0 = float3(0.04, 0.04, 0.04);

    // Metallic and Roughness material properties are packed together
    // In glTF, these factors can be specified by fixed scalar values
    // or from a metallic-roughness map
   /* if (Workflow == PBR_WORKFLOW_SPECULAR_GLOSINESS)
    {
        SrfInfo.PerceptualRoughness = 1.0 - PhysicalDesc.a; // glossiness to roughness
        f0 = PhysicalDesc.rgb;

        // f0 = specular
        specularColor = f0;
        float oneMinusSpecularStrength = 1.0 - max(max(f0.r, f0.g), f0.b);
        SrfInfo.DiffuseColor = BaseColor.rgb * oneMinusSpecularStrength;

        // do conversion between metallic M-R and S-G metallic
        Metallic = GLTF_PBR_SolveMetallic(BaseColor.rgb, specularColor, oneMinusSpecularStrength);
    }
    else if (Workflow == PBR_WORKFLOW_METALLIC_ROUGHNESS)*/
    {
        // Roughness is stored in the 'g' channel, metallic is stored in the 'b' channel.
        // This layout intentionally reserves the 'r' channel for (optional) occlusion map data
        SrfInfo.PerceptualRoughness = PhysicalDesc.g;
        Metallic                    = PhysicalDesc.b;

        SrfInfo.DiffuseColor  = BaseColor.rgb * (float3(1.0, 1.0, 1.0) - f0) * (1.0 - Metallic);
        specularColor         = lerp(f0, BaseColor.rgb, Metallic);
    }

//#ifdef ALPHAMODE_OPAQUE
//    baseColor.a = 1.0;
//#endif
//
//#ifdef MATERIAL_UNLIT
//    gl_FragColor = float4(gammaCorrection(baseColor.rgb), baseColor.a);
//    return;
//#endif

    SrfInfo.PerceptualRoughness = clamp(SrfInfo.PerceptualRoughness, 0.0, 1.0);

    // Compute reflectance.
    float reflectance = max(max(specularColor.r, specularColor.g), specularColor.b);

    SrfInfo.Reflectance0  = specularColor.rgb;
    // Anything less than 2% is physically impossible and is instead considered to be shadowing. Compare to "Real-Time-Rendering" 4th editon on page 325.
    SrfInfo.Reflectance90 = clamp(reflectance * 50.0, 0.0, 1.0) * float3(1.0, 1.0, 1.0);

    return SrfInfo;
}

#endif // _GLTF_PBR_SHADING_FXH_
