#ifndef _GLTF_PBR_STRUCTURES_FXH_
#define _GLTF_PBR_STRUCTURES_FXH_

#ifdef __cplusplus

#   ifndef CHECK_STRUCT_ALIGNMENT
        // Note that defining empty macros causes GL shader compilation error on Mac, because
        // it does not allow standalone semicolons outside of main.
        // On the other hand, adding semicolon at the end of the macro definition causes gcc error.
#       define CHECK_STRUCT_ALIGNMENT(s) static_assert( sizeof(s) % 16 == 0, "sizeof(" #s ") is not multiple of 16" )
#   endif

#endif

#ifndef PBR_WORKFLOW_METALLIC_ROUGHNESS
#   define PBR_WORKFLOW_METALLIC_ROUGHNESS 0
#endif

#ifndef PBR_WORKFLOW_SPECULAR_GLOSINESS
#   define PBR_WORKFLOW_SPECULAR_GLOSINESS 1
#endif


#ifndef GLTF_ALPHA_MODE_OPAQUE
#   define GLTF_ALPHA_MODE_OPAQUE 0
#endif

#ifndef GLTF_ALPHA_MODE_MASK
#   define GLTF_ALPHA_MODE_MASK 1
#endif

#ifndef GLTF_ALPHA_MODE_BLEND
#   define GLTF_ALPHA_MODE_BLEND 2
#endif


struct GLTFNodeShaderTransforms
{
	float4x4 NodeMatrix;

	int      JointCount;
    float    Dummy0;
    float    Dummy1;
    float    Dummy2;
};
#ifdef CHECK_STRUCT_ALIGNMENT
	CHECK_STRUCT_ALIGNMENT(GLTFNodeShaderTransforms);
#endif


struct GLTFRendererShaderParameters
{
	float AverageLogLum;
	float MiddleGray;
    float WhitePoint;
	float PrefilteredCubeMipLevels;

	float IBLScale;
	int   DebugViewType;
    float OcclusionStrength;
    float EmissionScale;
};
#ifdef CHECK_STRUCT_ALIGNMENT
	CHECK_STRUCT_ALIGNMENT(GLTFRendererShaderParameters);
#endif

struct GLTFMaterialShaderInfo
{
	float4  BaseColorFactor;
	float4  EmissiveFactor;
	float4  SpecularFactor;

	int     Workflow;
    //float BaseColorTextureUVSelector;
    //float PhysicalDescriptorTextureUVSelector;
    //float NormalTextureUVSelector;
    
    //float TangentTextureUVSelector;
    //float OcclusionTextureUVSelector;
    //float EmissiveTextureUVSelector;
    //float ClearCoatUVSelector;
    
    //float ClearCoatRounghnessUVSelector;
    //float TransmissionUVSelector;
    //float TicknessUVSelector;
    //float BaseColorSlice;
    
    //float PhysicalDescriptorSlice;
    //float NormalSlice;
    //float OcclusionSlice;
    //float EmissiveSlice;
    
    //float TangentSlice;
    //float ClearCoatSlice;
    //float ClearCoatRounghnessSlice;
    //float TransmissionSlice;
    
    //float TicknessSlice;
	float   MetallicFactor;
	float   RoughnessFactor;
	int     AlphaMode;	
    
	float   AlphaMaskCutoff;
    float   Anisotropy;
	float 	ClearcoatFactor;
	float 	ClearcoatRoughnessFactor;
    
    float   SheenRoughness;
    float   IridescenceMask;
    float   FilmThickness;
    float   BaseIor;
    
    float   Extinction;
    float   TransmissionFactor;
    float   Thickness;
    float AttenuationDistance;
    
 
    float sssDistortion;
    float sssPower;
    float sssScale;
    float sssAttenuation;

    float FurLength;
    float GravityStrength;
    float FurOffset;
    float FurUVOffset;
    float FurThickness;
    float Blur;
    float Glossiness1;
    float Glossiness2;
    float SpecShift1;
    float SpecShift2;
    float SpecSmooth1;
    float SpecSmooth2;
    float4 SpecColor1;
    float4 SpecColor2;
    
    float4 SheenColor;
    float4 AttenuationColor;
   
    // When texture atlas is used, UV scale and bias applied to
    // each texture coordinate set
    //float4 BaseColorUVScaleBias;
    //float4 PhysicalDescriptorUVScaleBias;
    //float4 NormalMapUVScaleBias;
    //float4 OcclusionUVScaleBias;
    
    //float4 EmissiveUVScaleBias;
    //float4 TangentUVScaleBias;
    //float4 ClearCoatUVScaleBias;
    //float4 ClearCoatRounghnessUVScaleBias;
    
    //float4 TransmissionUVScaleBias;
    //float4 TicknessUVScaleBias;
    float4 mEffectTranslucent;
    float3 mGravity;
    float pad;

};

#ifdef CHECK_STRUCT_ALIGNMENT
	CHECK_STRUCT_ALIGNMENT(GLTFMaterialShaderInfo);
#endif

#endif // _GLTF_PBR_STRUCTURES_FXH_
