#include "BasicStructures.fxh"
#include "GLTF_PBR_VertexProcessing.fxh"


cbuffer cbCameraAttribs
{
    CameraAttribs g_CameraAttribs;
}



cbuffer cbTransforms
{
    GLTFNodeShaderTransforms g_Transforms;
}

#ifndef MAX_JOINT_COUNT
#   define MAX_JOINT_COUNT 64
#endif

cbuffer cbJointTransforms
{
    float4x4 g_Joints[MAX_JOINT_COUNT];
}
   
struct VSInput
{
    float4 Position  : ATTRIB0;
    float4 Normal    : ATTRIB1;
    float2 TexCoord  : ATTRIB2;
	float2 TexCoord1  : ATTRIB3;
	float4 Joint0  : ATTRIB4;
    float4 Weight0 : ATTRIB5;
	

};


void main(in  VSInput  VSIn,
             out float4 ClipPos  : SV_POSITION)
{

float4x4 Transform = g_Transforms.NodeMatrix;
    if (g_Transforms.JointCount > 0)
    {
        // Mesh is skinned
        float4x4 SkinMat = 
            VSIn.Weight0.x * g_Joints[int(VSIn.Joint0.x)] +
            VSIn.Weight0.y * g_Joints[int(VSIn.Joint0.y)] +
            VSIn.Weight0.z * g_Joints[int(VSIn.Joint0.z)] +
            VSIn.Weight0.w * g_Joints[int(VSIn.Joint0.w)];
        Transform = mul(Transform,SkinMat);
    }
float4 locPos = mul(Transform,float4(VSIn.Position.xyz, 1.0));
float3 WorldPos = locPos.xyz / locPos.w;
 ClipPos   = mul(float4(WorldPos, 1.0),g_CameraAttribs.mViewProj);
  
}
