#include "BasicStructures.fxh"
#include "GLTF_PBR_VertexProcessing.fxh"

struct GLTF_VS_Input
{
    float4 Pos     : ATTRIB0;
    float4 Normal  : ATTRIB1;
    float2 UV0     : ATTRIB2;
    float2 UV1     : ATTRIB3;
    float4 Joint0  : ATTRIB4;
    float4 Weight0 : ATTRIB5;
};

cbuffer cbLightAttribs
{
    LightAttribs g_LightAttribs;
}

cbuffer cbCameraAttribs
{
    CameraAttribs g_CameraAttribs;
}

cbuffer cbTransforms
{
    GLTFNodeShaderTransforms g_Transforms;
}

/*cbuffer cbMorphInfo
{
    int morphcount;
    int numberver;
    float padding;
    float padding1;
}*/

//StructuredBuffer<float3> MorphBuffer;
//StructuredBuffer<double> MorphWeight;


#ifndef MAX_JOINT_COUNT
#   define MAX_JOINT_COUNT 64
#endif

#ifdef GLTF_USE_ULIT
#   define GLTF_USE_ULIT 1
#endif

cbuffer cbJointTransforms
{
    float4x4 g_Joints[MAX_JOINT_COUNT];
}


#ifdef GLTF_USE_ULIT
cbuffer cbUVMatrix
{
   float4x4 UVMatrix;
}
#endif
#ifdef GLTF_PBR_USE_FUR
cbuffer cbFur
{
    float FurOffset;
    float GravityStrgenth;
    float FurLength;
    float pad1;
    float3 Gravity;
    float pad2;
}
#endif
void main(in  GLTF_VS_Input  VSIn,
          out float4 ClipPos  : SV_POSITION,
          out float3 WorldPos : WORLD_POS,
          out float3 Normal   : NORMAL,
          out float2 UV0      : UV0,
          out float2 UV1      : UV1,
          out float3 PosInLightViewSpace 	: LIGHT_SPACE_POS)
{
    // Warning: moving this block into GLTF_TransformVertex() function causes huge
    // performance degradation on Vulkan because glslang/SPIRV-Tools are apparently not able
    // to eliminate the copy of g_Transforms structure.
    float4 pos = float4(VSIn.Pos.xyz, 0.0);
   
   /* float3 dp = 0.0f;
    for (int i = 0; i < morphcount; i++)
    {
        dp = MorphBuffer.Load(t + numberver * i);
       
        pos += float4(float3(-dp.x, dp.z, -dp.y) * MorphWeight[i],0.0f);
    }*/
    

    float4x4 Transform = g_Transforms.NodeMatrix;
    if (g_Transforms.JointCount > 0)
    {
        // Mesh is skinned
        float4x4 SkinMat = 
            VSIn.Weight0.x * g_Joints[int(VSIn.Joint0.x)] +
            VSIn.Weight0.y * g_Joints[int(VSIn.Joint0.y)] +
            VSIn.Weight0.z * g_Joints[int(VSIn.Joint0.z)] +
            VSIn.Weight0.w * g_Joints[int(VSIn.Joint0.w)];
        Transform = mul(Transform,SkinMat);
    }
    float furOffset = 0.0;
    float gravityStrgenth = 0.0;
    float furLength = 0.0;
    float3 gravity = float3(0.0, 0.0, 0.0);
#ifdef GLTF_PBR_USE_FUR
     furOffset = FurOffset;
     gravityStrgenth = GravityStrgenth;
     furLength = FurLength;
     gravity=Gravity;
#endif
    GLTF_TransformedVertex TransformedVert = GLTF_TransformVertex(pos.xyz, VSIn.Normal.xyz, Transform, gravityStrgenth, furOffset, gravity, furLength);

	float4 LightSpacePos= mul(float4(TransformedVert.WorldPos, 1.0),g_LightAttribs.ShadowAttribs.mWorldToLightView);
    PosInLightViewSpace = LightSpacePos.xyz/LightSpacePos.w;

    ClipPos  = mul(float4(TransformedVert.WorldPos, 1.0),g_CameraAttribs.mViewProj);
    WorldPos = TransformedVert.WorldPos;
    Normal   = TransformedVert.Normal;
#ifdef GLTF_USE_ULIT
    UV0      = mul(UVMatrix,float4(VSIn.UV0,0.0,1.0)).xy;
    UV1      = VSIn.UV1;
#else
    UV0      = VSIn.UV0;
    UV1      = VSIn.UV1;
 #endif
}
