#include "BasicStructures.fxh"
#include "GLTF_PBR_VertexProcessing.fxh"

struct GLTF_VS_Input
{
    float4 Pos     : ATTRIB0;
    float4 Normal  : ATTRIB1;
    float2 UV0     : ATTRIB2;
    float2 UV1     : ATTRIB3;
    float4 Joint0  : ATTRIB4;
    float4 Weight0 : ATTRIB5;
};


cbuffer cbCameraAttribs
{
    CameraAttribs g_CameraAttribs;
}

cbuffer cbTransforms
{
    GLTFNodeShaderTransforms g_Transforms;
}

/*cbuffer cbMorphInfo
{
    int morphcount;
    int numberver;
    float padding;
    float padding1;
}*/
cbuffer cbToonOutlineVSAttribs
{
    float Outline_Width;
    float Farthest_Distance;
    float Nearest_Distance;
    float Offset_Z;
    float ZOverDrawMode;
    float4 eyeposition;
};
//StructuredBuffer<float3> MorphBuffer;
//StructuredBuffer<double> MorphWeight;


#ifndef MAX_JOINT_COUNT
#   define MAX_JOINT_COUNT 64
#endif

cbuffer cbJointTransforms
{
    float4x4 g_Joints[MAX_JOINT_COUNT];
}
   

void main(in  GLTF_VS_Input  VSIn,
          out float4 ClipPos  : SV_POSITION,
          out float2 UV0      : UV0
          //uint t : SV_VertexID
          )
{
    // Warning: moving this block into GLTF_TransformVertex() function causes huge
    // performance degradation on Vulkan because glslang/SPIRV-Tools are apparently not able
    // to eliminate the copy of g_Transforms structure.
    float4 pos = float4(VSIn.Pos.xyz, 0.0);
	float4 nor=float4(VSIn.Normal.xyz,1.0);
   /* float3 dp = 0.0f;
    for (int i = 0; i < morphcount; i++)
    {
        dp = MorphBuffer.Load(t + numberver * i);
       
        pos += float4(float3(-dp.x, dp.z, -dp.y) * MorphWeight[i],0.0f);
    }*/
    

    float4x4 Transform = g_Transforms.NodeMatrix;
    if (g_Transforms.JointCount > 0)
    {
        // Mesh is skinned
        float4x4 SkinMat = 
            VSIn.Weight0.x * g_Joints[int(VSIn.Joint0.x)] +
            VSIn.Weight0.y * g_Joints[int(VSIn.Joint0.y)] +
            VSIn.Weight0.z * g_Joints[int(VSIn.Joint0.z)] +
            VSIn.Weight0.w * g_Joints[int(VSIn.Joint0.w)];
        Transform = mul(Transform,SkinMat);
    }


    float4 objPos = mul(float4(0, 0, 0, 1),Transform);
    float2 Set_UV0 = VSIn.UV0;
  //  float Outline_Sampler_var = OutlineMap.SampleLevel(OutlineMap_sampler, float3(Set_UV0, 0), 0).r;
 
    float SetOutline_Width = Outline_Width * 1.0* 
    0.001 * smoothstep(Farthest_Distance, Nearest_Distance,
     distance(objPos.rgb, g_CameraAttribs.f4Position.xyz));

 
    float4 _ClipCameraPos = mul(float4(g_CameraAttribs.f4Position.xyz, 1)
    ,g_CameraAttribs.mViewProj);
    float Offset_Z1 = 0.0;
//#if defined(REVERSED_Z)
    //v.2.0.4.2 (DX)
 //   Offset_Z1 = Offset_Z * -0.01;
//#else

    Offset_Z1 = Offset_Z * 0.01;
//#endif
   
	
    float4 wp = mul(Transform, float4(pos.xyz + nor.xyz*float3(SetOutline_Width,SetOutline_Width,SetOutline_Width),1.0));
	ClipPos = mul(wp, g_CameraAttribs.mViewProj);
    /*SetOutline_Width = SetOutline_Width * 2.0f;
    float4x4 MVP = mul(g_CameraAttribs.mViewProj,Transform);
    float signVar =dot(normalize(VSIn.Pos.xyz), normalize(VSIn.Normal.xyz)) < 0.0 ? -1.0 : 1.0;
    float4 wp = mul(Transform, float4(pos.xyz + signVar * normalize(pos.xyz) * SetOutline_Width, 1));
	ClipPos = mul(wp, g_CameraAttribs.mViewProj);*/
    float z = ClipPos.z;
	//float z = ClipPos.z;
    ClipPos.z = z + Offset_Z1 * _ClipCameraPos.z;
    UV0=Set_UV0;



}
