#ifndef _TOON_SHADING_FXH_
#define _TOON_SHADING_FXH_


#include "ShaderUtilities.fxh"



float GetPerceivedBrightness(float3 rgb)
{
    return sqrt(0.299 * rgb.r * rgb.r + 0.587 * rgb.g * rgb.g + 0.114 * rgb.b * rgb.b);
}




void Toon_PerturbNormal(in float3 dPos_dx,
                              in float3 dPos_dy,
                              in float2 dUV_dx,
                              in float2 dUV_dy,
                              in float3 Normal,
                              in float3 TSNormal,
out float3 Pnormal,
out float3x3 transform,
                              bool HasUV,
                              bool IsFrontFace)
{
    // Retrieve the tangent space matrix
    float NormalLen = length(Normal);
    float3 ng;
    if (NormalLen > 1e-5)
    {
        ng = Normal / NormalLen;
    }
    else
    {
        ng = normalize(cross(dPos_dx, dPos_dy));

        // In OpenGL screen is upside-down, so we have to invert the vector
        ng *= -1.0;

    }

    if (HasUV)
    {
        ToonTransformTangentSpaceNormalGrad(dPos_dx, dPos_dy, dUV_dx, dUV_dy, ng, TSNormal * (IsFrontFace ? +1.0 : -1.0), Pnormal, transform);
    }
    else
    {
        ng * (IsFrontFace ? +1.0 : -1.0);
    }
}

float max3(float3 v)
{
    return max(max(v.x, v.y), v.z);
}



#endif // _GLTF_PBR_SHADING_FXH_
