ArtTreeView_parameter = function () {
    this.m_parentDiv = null;
    this.width = 300;
    this.height = 600;
    this.pathList = null;
}

ArtTreeView = function (parameter) {
    class_CopyInherit(this, new UIBase())
    this.parameter = parameter;
    this.ui_new(parameter.m_parentDiv, "ArtTreeView")
}
ArtTreeView.prototype = {
    parameter: null,// new ArtTreeView_parameter(), 
    o_jsTree: null,
    _ui_init: function () {
        this.base._ui_init.call(this) 
        this.m_rootDiv.style.width = this.parameter.width + "px";
        this.m_rootDiv.style.height = this.parameter.height + "px";
        this.m_rootDiv.style.backgroundColor = "#005588";
        this.m_rootDiv.o_thisObj = this;
        let thisObj = this;
        CreateCard.CreateBtn(this.m_rootDiv, "获取所有资源", function () {
            thisObj.refreshTree(thisObj.parameter.pathList);
        });
        this.m_clearBtn.style.left = "200px";
    },

    refreshTree: function (pathList) {
        let nodeData = new JSTree_nodeData();
        nodeData.name = "WeData数据类型";
        nodeData.isViewNode = true;
        nodeData.isShow = true;
        nodeData.nodeDepth = -1;
        nodeData.index = 0;
        nodeData.childDic = {}
        nodeData.pathTag = "root";

        for (let i in pathList) {
            //cc.log("加载..........", onlyPathTag)
            //let weObj = pathList[onlyPathTag]; 
            let pathObj = pathList[i];
            if (pathObj.onlyPath == null) {
                cc.error("错误............", pathObj.path)
                continue;
            }
            let arr = pathObj.onlyPath.tag.split('_');
            let parentNode = nodeData;
            let pathTag = "";
            for (let i in arr) {
                let strId = arr[i];
                pathTag += strId + "-";
                let subNodeData = parentNode.childDic[strId];
                if (subNodeData == null) {
                    subNodeData = new JSTree_nodeData();
                    subNodeData.name = strId;
                    subNodeData.pathTag = pathTag;
                    subNodeData.nodeDepth = parseInt(i);
                    subNodeData.index = Object.keys(parentNode.childDic).length;
                    subNodeData.isViewNode = true;
                    subNodeData.isShow = true;
                    subNodeData.childDic = {}
                    subNodeData.parent = parentNode;
                    parentNode.childDic[strId] = subNodeData;
                }
                parentNode = subNodeData;
            }
            parentNode.name = pathObj.name;
            parentNode.data = pathObj;
        }


        let parameter = new JSTree_parameter();
        parameter.o_nodeData = nodeData;
        parameter.m_parentDiv = this.m_rootDiv;
        parameter.logicObj = this;
        parameter.onClick = function (logicObj, nodeData) {
            let pathObj = nodeData.data;
            if (pathObj != null) {
                // let thisObj = uiRoot.o_ArtTreeView
                // let fullPath = thisObj.prjDir + "/" + nodeData.data.path
                cc.log("加载对象........" + pathObj.path)
                // WebPost_FileRead(fullPath, "text", thisObj.S_OpenWeDataView)
            }
        };
        parameter.startPosX = 0;
        parameter.startPosY = 30;
        parameter.treeWidth = this.parameter.width;
        parameter.treeHigh = this.parameter.height - 30;
        parameter.isShowTitle = false;//是否显示标题头 
        this.o_jsTree = new JSTree();
        this.o_jsTree.Init0(parameter);
    },
    S_OpenWeDataView: function (weDataStr) {
        cc.log("weDataStr........" + weDataStr)
        let weDataObj = CSUtils.WeData.S_DeSerializationString(weDataStr, false);

        WeDataNodeView.GetInstance().loadWeData(weDataObj);
    },
    ui_open: function (pathList) {
        if (pathList != null) {
            this.parameter.pathList = pathList;
        }
        base.ui_open.call(this);
    },

    CreateNodeTree: function (pathList) {
        let nodeData = {}
        nodeData.isViewNode = true;
        nodeData.name = "root";
        nodeData.childDic = {}
        for (let i = 0; i < pathList.length; i++) {
            let pathObj = pathList[i];
            let onlyPath = pathObj.onlyPath;
            //cc.log("...." + onlyPath)
            if (onlyPath == null) {
                cc.error("...." + pathObj.path)
                continue
            }
            if (i > 100) {
                break;
            }
            if (nodeData.childDic[onlyPath.a] == null) {
                let data = {};
                data.isViewNode = true;
                data.name = "" + onlyPath.a;
                data.childDic = {}
                nodeData.childDic[onlyPath.a] = data;
            }
            if (nodeData.childDic[onlyPath.a].childDic[onlyPath.b] == null) {
                let data = {};
                data.isViewNode = true;
                data.name = "" + onlyPath.b;
                data.childDic = {}
                nodeData.childDic[onlyPath.a].childDic[onlyPath.b] = data;
            }
            if (nodeData.childDic[onlyPath.a].childDic[onlyPath.b].childDic[onlyPath.c] == null) {
                let data = {};
                data.isViewNode = true;
                data.name = "" + onlyPath.c;
                data.childDic = {}
                nodeData.childDic[onlyPath.a].childDic[onlyPath.b].childDic[onlyPath.c] = data;
            }

            let data = {};
            data.isViewNode = true;
            data.name = "" + onlyPath;
            data.data = pathObj;
            data.childDic = {}
            nodeData.childDic[onlyPath.a].childDic[onlyPath.b].childDic[onlyPath.c].childDic[onlyPath.d] = data;// pathObj.onlyPath.id;

        }

        this.tree_nodeRootObj = tree_genNode(nodeData, this.m_rootDiv, null, function (nodeData) {
            if (nodeData.data != null) {
                let thisObj = uiRoot.o_ArtTreeView
                let fullPath = thisObj.prjDir + "/" + nodeData.data.path
                cc.log("加载对象........" + fullPath)
                WebPost_FileRead(fullPath, "text", thisObj.S_OpenWeDataView)
            }
        });
        // this.tree_nodeRootObj.offsetLeft = this.offsetLeft;
        // this.tree_nodeRootObj.offsetTop = this.offsetTop;
        // this.tree_nodeRootObj.S_Refresh(null, this.offsetLeft, this.offsetTop);
        this.tree_nodeRootObj.initOffectX = 0;
        this.tree_nodeRootObj.initOffectY = 20;
        this.tree_nodeRootObj.S_Refresh(null, 0, 20);
    },

}
 

