BinaryReader = function (buffer) {
    this.buffer = buffer;
    this.dataView = new DataView(buffer);
    //---如果返回true，就是小端字节序；如果返回false，就是大端字节序。----
    this._isLittleEndian = (function () {
        var buffer = new ArrayBuffer(2);
        new DataView(buffer).setInt16(0, 256, true);
        return new Int16Array(buffer)[0] === 256;
    })();
}

BinaryReader.prototype = {
    _position: 0,
    // getInt8：读取1个字节，返回一个8位整数。
    getInt8: function () {
        let value = this.dataView.getInt8(this._position);
        this._position += 1;
        return value;
    },
    // getUint8：读取1个字节，返回一个无符号的8位整数。
    getUint8: function () {
        let value = this.dataView.getUint8(this._position);
        this._position += 1;
        return value;
    },
    // getInt16：读取2个字节，返回一个16位整数。
    getInt16: function () {
        let value = this.dataView.getInt16(this._position);
        this._position += 2;
        return value;
    },
    // getUint16：读取2个字节，返回一个无符号的16位整数。
    getUint16: function () {
        let value = this.dataView.getUint16(this._position);
        this._position += 2;
        return value;
    },
    // getInt32：读取4个字节，返回一个32位整数。
    getInt32: function () {
        let value = this.dataView.getInt32(this._position);
        this._position += 4;
        return value;
    },
    // getUint32：读取4个字节，返回一个无符号的32位整数。
    getUint32: function () {
        let value = this.dataView.getUint32(this._position);
        this._position += 4;
        return value;
    },
    // getFloat32：读取4个字节，返回一个32位浮点数。
    getFloat32: function () {
        let value = this.dataView.getFloat32(this._position);
        this._position += 4;
        return value;
    },
    // getFloat64：读取8个字节，返回一个64位浮点数。
    getFloat64: function () {
        let value = this.dataView.getFloat64(this._position);
        this._position += 8;
        return value;
    },
}