CBytes = function () {
}
CBytes.prototype = {}

//---如果返回true，就是小端字节序；如果返回false，就是大端字节序。----
var littleEndian = (function () {
	var buffer = new ArrayBuffer(2);
	new DataView(buffer).setInt16(0, 256, true);
	return new Int16Array(buffer)[0] === 256;
})();


//字符串 转 字节序列
CBytes.stringToByte = function (str) {
	let bytes = new Array();
	let len, c;
	len = str.length;
	for (let i = 0; i < len; i++) {
		c = str.charCodeAt(i);
		if (c >= 0x010000 && c <= 0x10FFFF) {
			bytes.push(((c >> 18) & 0x07) | 0xF0);
			bytes.push(((c >> 12) & 0x3F) | 0x80);
			bytes.push(((c >> 6) & 0x3F) | 0x80);
			bytes.push((c & 0x3F) | 0x80);
		} else if (c >= 0x000800 && c <= 0x00FFFF) {
			bytes.push(((c >> 12) & 0x0F) | 0xE0);
			bytes.push(((c >> 6) & 0x3F) | 0x80);
			bytes.push((c & 0x3F) | 0x80);
		} else if (c >= 0x000080 && c <= 0x0007FF) {
			bytes.push(((c >> 6) & 0x1F) | 0xC0);
			bytes.push((c & 0x3F) | 0x80);
		} else {
			bytes.push(c & 0xFF);
		}
	}
	return bytes;
}

//字节序列 转 ASCII码
//[0x24, 0x26, 0x28, 0x2A] ==> "$&C*"
CBytes.byteToString = function (arr) {
	if (typeof arr === 'string') {
		return arr;
	}
	let str = '', _arr = arr;
	for (let i = 0; i < _arr.length; i++) {
		let one = _arr[i].toString(2),
			v = one.match(/^1+?(?=0)/);
		if (v && one.length == 8) {
			let bytesLength = v[0].length;
			let store = _arr[i].toString(2).slice(7 - bytesLength);
			for (let st = 1; st < bytesLength; st++) {
				store += _arr[st + i].toString(2).slice(2);
			}
			str += String.fromCharCode(parseInt(store, 2));
			i += bytesLength - 1;
		} else {
			str += String.fromCharCode(_arr[i]);
		}
	}
	return str;
}


// 字符串转为ArrayBuffer对象，参数为字符串
CBytes.S_stringToByte = function (str) {
	let buf = new ArrayBuffer(str.length * 2); // 每个字符占用2个字节
	let bufView = new Uint16Array(buf);
	for (let i = 0, strLen = str.length; i < strLen; i++) {
		bufView[i] = str.charCodeAt(i);
	}
	return buf;
}


// ArrayBuffer转为字符串，参数为ArrayBuffer对象, 字符串编码为一个字节
//----无法处理中文-----
CBytes.S_byteToString2 = function (buf) {
	return String.fromCharCode.apply(null, new Uint8Array(buf));
}

// ArrayBuffer转为字符串，参数为ArrayBuffer对象字符串编码为js默认编码
CBytes.S_byteToString = function (buf) {
	return String.fromCharCode.apply(null, new Uint16Array(buf));
}


//---------------------ArrayBuffer与十六进制的互相转换---------------------------

//十六进制 转 bytearray
CBytes.hex2ab = function (hex) {
	var typedArray = new Uint8Array(hex.match(/[\da-f]{2}/gi).map(function (h) {
		return parseInt(h, 16)
	}))
	var buffer = typedArray.buffer
	return buffer
}

// ArrayBuffer转16进度字符串示例
CBytes.ab2hex = function (buffer) {
	var hexArr = Array.prototype.map.call(
		new Uint8Array(buffer),
		function (bit) {
			return ('00' + bit.toString(16)).slice(-2)
		}
	)
	return hexArr.join('');
}

//js ArrayBuffer   拼接
CBytes.concatenate = function (resultConstructor, ...arrays) {
	let totalLength = 0;
	for (let arr of arrays) {
		totalLength += arr.length;
	}
	let result = new resultConstructor(totalLength);
	let offset = 0;
	for (let arr of arrays) {
		result.set(arr, offset);
		offset += arr.length;
	}
	return result;
}